/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;

public final class StringCharacterIterator
implements CharacterIterator {
    private String text;
    private int pos;
    private int begin;
    private int end;

    public Object clone() {
        return new StringCharacterIterator(this.text, this.begin, this.end, this.pos);
    }

    public char current() {
        if (this.pos < this.end) {
            return this.text.charAt(this.pos);
        }
        return '\uffff';
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StringCharacterIterator)) {
            return false;
        }
        StringCharacterIterator sci = (StringCharacterIterator)obj;
        return this.pos == sci.pos && this.begin == sci.begin && this.end == sci.end && this.text.equals(sci.text);
    }

    public char first() {
        this.pos = this.begin;
        return this.current();
    }

    public int getBeginIndex() {
        return this.begin;
    }

    public int getEndIndex() {
        return this.end;
    }

    public int getIndex() {
        return this.pos;
    }

    public int hashCode() {
        return this.text.hashCode() + this.pos + this.begin + this.end;
    }

    public char last() {
        this.pos = this.end;
        return this.current();
    }

    public char next() {
        if (this.pos == this.end) {
            return '\uffff';
        }
        ++this.pos;
        return this.current();
    }

    public char previous() {
        if (this.pos == this.begin) {
            return '\uffff';
        }
        this.pos += -1;
        return this.current();
    }

    public char setIndex(int idx) {
        if (idx < this.begin || idx > this.end) {
            throw new IllegalArgumentException();
        }
        this.pos = idx;
        return this.current();
    }

    public StringCharacterIterator(String text) {
        this(text, 0, text.length(), 0);
    }

    public StringCharacterIterator(String text, int pos) {
        this(text, 0, text.length(), pos);
    }

    public StringCharacterIterator(String text, int begin, int end, int pos) {
        if (begin < 0 || begin > end || end > text.length() || pos < begin || pos > end) {
            throw new IllegalArgumentException();
        }
        this.text = text;
        this.begin = begin;
        this.end = end;
        this.pos = pos;
    }

    public void setText(String text) {
        this.text = text;
        this.begin = 0;
        this.end = text.length();
        this.pos = 0;
    }
}

