/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DateFormatSymbols
implements Serializable,
Cloneable {
    String[] ampms;
    String[] eras;
    private String localPatternChars;
    String[] months;
    String[] shortMonths;
    String[] shortWeekdays;
    String[] weekdays;
    private String[][] zoneStrings;
    private static final long serialVersionUID = -5987973545549424702L;
    private static final String[] formatPrefixes = new String[]{"full", "long", "medium", "short"};
    private static final String[] ampmsDefault = new String[]{"AM", "PM"};
    private static final String[] erasDefault = new String[]{"BC", "AD"};
    private static final String localPatternCharsDefault = "GyMdkHmsSEDFwWahKz";
    private static final String[] monthsDefault;
    private static final String[] shortMonthsDefault;
    private static final String[] shortWeekdaysDefault;
    private static final String[] weekdaysDefault;
    private static String[][] zoneStringsDefault;
    transient String[] dateFormats;
    transient String[] timeFormats;

    private String[] formatsForKey(ResourceBundle res, String key) {
        String[] values = new String[formatPrefixes.length];
        for (int i = 0; i < formatPrefixes.length; ++i) {
            values[i] = res.getString(formatPrefixes[i] + key);
        }
        return values;
    }

    private final Object safeGetResource(ResourceBundle res, String key, Object def) {
        if (res != null) {
            try {
                return res.getObject(key);
            }
            catch (MissingResourceException x) {
                // empty catch block
            }
        }
        return def;
    }

    public DateFormatSymbols(Locale locale) {
        ResourceBundle res;
        try {
            res = ResourceBundle.getBundle("gnu.gcj.text.LocaleData", locale);
        }
        catch (MissingResourceException x) {
            res = null;
        }
        this.ampms = (String[])this.safeGetResource(res, "ampm", ampmsDefault);
        this.eras = (String[])this.safeGetResource(res, "eras", erasDefault);
        this.localPatternChars = (String)this.safeGetResource(res, "datePatternChars", localPatternCharsDefault);
        this.months = (String[])this.safeGetResource(res, "months", monthsDefault);
        this.shortMonths = (String[])this.safeGetResource(res, "shortMonths", shortMonthsDefault);
        this.shortWeekdays = (String[])this.safeGetResource(res, "shortWeekdays", shortWeekdaysDefault);
        this.weekdays = (String[])this.safeGetResource(res, "weekdays", weekdaysDefault);
        this.zoneStrings = (String[][])this.safeGetResource(res, "zoneStrings", zoneStringsDefault);
        this.dateFormats = this.formatsForKey(res, "DateFormat");
        this.timeFormats = this.formatsForKey(res, "TimeFormat");
    }

    public DateFormatSymbols() {
        this(Locale.getDefault());
    }

    private DateFormatSymbols(DateFormatSymbols old) {
        this.ampms = old.ampms;
        this.eras = old.eras;
        this.localPatternChars = old.localPatternChars;
        this.months = old.months;
        this.shortMonths = old.shortMonths;
        this.shortWeekdays = old.shortWeekdays;
        this.weekdays = old.weekdays;
        this.zoneStrings = old.zoneStrings;
        this.dateFormats = old.dateFormats;
        this.timeFormats = old.timeFormats;
    }

    public String[] getAmPmStrings() {
        return this.ampms;
    }

    public String[] getEras() {
        return this.eras;
    }

    public String getLocalPatternChars() {
        return this.localPatternChars;
    }

    public String[] getMonths() {
        return this.months;
    }

    public String[] getShortMonths() {
        return this.shortMonths;
    }

    public String[] getShortWeekdays() {
        return this.shortWeekdays;
    }

    public String[] getWeekdays() {
        return this.weekdays;
    }

    public String[][] getZoneStrings() {
        return this.zoneStrings;
    }

    public void setAmPmStrings(String[] value) {
        this.ampms = value;
    }

    public void setEras(String[] value) {
        this.eras = value;
    }

    public void setLocalPatternChars(String value) {
        this.localPatternChars = value;
    }

    public void setMonths(String[] value) {
        this.months = value;
    }

    public void setShortMonths(String[] value) {
        this.shortMonths = value;
    }

    public void setShortWeekdays(String[] value) {
        this.shortWeekdays = value;
    }

    public void setWeekdays(String[] value) {
        this.weekdays = value;
    }

    public void setZoneStrings(String[][] value) {
        this.zoneStrings = value;
    }

    private static boolean equals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (!(x instanceof Object[]) || !(y instanceof Object[])) {
            return x.equals(y);
        }
        Object[] xa = (Object[])x;
        Object[] ya = (Object[])y;
        if (xa.length != ya.length) {
            return false;
        }
        int i = xa.length;
        while (--i >= 0) {
            if (DateFormatSymbols.equals(xa[i], ya[i])) continue;
            return false;
        }
        return true;
    }

    private static int hashCode(Object x) {
        if (x == null) {
            return 0;
        }
        if (!(x instanceof Object[])) {
            return x.hashCode();
        }
        Object[] xa = (Object[])x;
        int hash = 0;
        for (int i = 0; i < xa.length; ++i) {
            hash = 37 * DateFormatSymbols.hashCode(xa[i]);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DateFormatSymbols)) {
            return false;
        }
        DateFormatSymbols other = (DateFormatSymbols)obj;
        return DateFormatSymbols.equals(this.ampms, other.ampms) && DateFormatSymbols.equals(this.eras, other.eras) && DateFormatSymbols.equals(this.localPatternChars, other.localPatternChars) && DateFormatSymbols.equals(this.months, other.months) && DateFormatSymbols.equals(this.shortMonths, other.shortMonths) && DateFormatSymbols.equals(this.shortWeekdays, other.shortWeekdays) && DateFormatSymbols.equals(this.weekdays, other.weekdays) && DateFormatSymbols.equals(this.zoneStrings, other.zoneStrings);
    }

    public Object clone() {
        return new DateFormatSymbols(this);
    }

    public int hashCode() {
        return DateFormatSymbols.hashCode(this.ampms) ^ DateFormatSymbols.hashCode(this.eras) ^ DateFormatSymbols.hashCode(this.localPatternChars) ^ DateFormatSymbols.hashCode(this.months) ^ DateFormatSymbols.hashCode(this.shortMonths) ^ DateFormatSymbols.hashCode(this.shortWeekdays) ^ DateFormatSymbols.hashCode(this.weekdays) ^ DateFormatSymbols.hashCode(this.zoneStrings);
    }

    static {
        localPatternCharsDefault = localPatternCharsDefault;
        monthsDefault = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December", ""};
        shortMonthsDefault = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", ""};
        shortWeekdaysDefault = new String[]{"", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        weekdaysDefault = new String[]{"", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        zoneStringsDefault = new String[][]{{"GMT", "Greenwich Mean Time", "GMT", "Greenwich Mean Time", "GMT", "GMT"}, {"PST", "Pacific Standard Time", "PST", "Pacific Daylight Time", "PDT", "San Francisco"}, {"MST", "Mountain Standard Time", "MST", "Mountain Daylight Time", "MDT", "Denver"}, {"PNT", "Mountain Standard Time", "MST", "Mountain Standard Time", "MST", "Phoenix"}, {"CST", "Central Standard Time", "CST", "Central Daylight Time", "CDT", "Chicago"}, {"EST", "Eastern Standard Time", "EST", "Eastern Daylight Time", "EDT", "Boston"}, {"IET", "Eastern Standard Time", "EST", "Eastern Standard Time", "EST", "Indianapolis"}, {"PRT", "Atlantic Standard Time", "AST", "Atlantic Daylight Time", "ADT", "Halifax"}, {"CNT", "Newfoundland Standard Time", "NST", "Newfoundland Daylight Time", "NDT", "St. Johns"}, {"ECT", "Central European Standard Time", "CET", "Central European Daylight Time", "CEST", "Paris"}, {"CTT", "China Standard Time", "CST", "China Standard Time", "CST", "Shanghai"}, {"JST", "Japan Standard Time", "JST", "Japan Standard Time", "JST", "Tokyo"}, {"HST", "Hawaii Standard Time", "HST", "Hawaii Standard Time", "HST", "Honolulu"}, {"AST", "Alaska Standard Time", "AKST", "Alaska Daylight Time", "AKDT", "Anchorage"}};
    }
}

