/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;

public abstract class DateFormat
extends Format
implements Cloneable {
    protected Calendar calendar;
    protected NumberFormat numberFormat;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    public static final int DEFAULT = 2;
    public static final int ERA_FIELD = 0;
    public static final int YEAR_FIELD = 1;
    public static final int MONTH_FIELD = 2;
    public static final int DATE_FIELD = 3;
    public static final int HOUR_OF_DAY1_FIELD = 4;
    public static final int HOUR_OF_DAY0_FIELD = 5;
    public static final int MINUTE_FIELD = 6;
    public static final int SECOND_FIELD = 7;
    public static final int MILLISECOND_FIELD = 8;
    public static final int DAY_OF_WEEK_FIELD = 9;
    public static final int DAY_OF_YEAR_FIELD = 10;
    public static final int DAY_OF_WEEK_IN_MONTH_FIELD = 11;
    public static final int WEEK_OF_YEAR_FIELD = 12;
    public static final int WEEK_OF_MONTH_FIELD = 13;
    public static final int AM_PM_FIELD = 14;
    public static final int HOUR1_FIELD = 15;
    public static final int HOUR0_FIELD = 16;
    public static final int TIMEZONE_FIELD = 17;

    protected DateFormat() {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DateFormat)) {
            return false;
        }
        DateFormat d = (DateFormat)obj;
        return this.calendar.equals(d.calendar) && this.numberFormat.equals(d.numberFormat);
    }

    public Object clone() {
        return super.clone();
    }

    public final StringBuffer format(Object obj, StringBuffer buf, FieldPosition pos) {
        if (obj instanceof Number) {
            return this.format(new Date(((Number)obj).longValue()), buf, pos);
        }
        return this.format((Date)obj, buf, pos);
    }

    public final String format(Date date) {
        StringBuffer sb = new StringBuffer();
        this.format(date, sb, new FieldPosition(2));
        return sb.toString();
    }

    public abstract StringBuffer format(Date var1, StringBuffer var2, FieldPosition var3);

    public static Locale[] getAvailableLocales() {
        return null;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    private static final DateFormat computeInstance(int style, Locale loc, boolean use_date, boolean use_time) {
        return DateFormat.computeInstance(style, style, loc, use_date, use_time);
    }

    private static final DateFormat computeInstance(int dateStyle, int timeStyle, Locale loc, boolean use_date, boolean use_time) {
        String def;
        String name;
        ResourceBundle res;
        try {
            res = ResourceBundle.getBundle("gnu.gcj.text.LocaleData", loc);
        }
        catch (MissingResourceException x) {
            res = null;
        }
        String pattern = null;
        if (use_date) {
            switch (dateStyle) {
                case 0: {
                    name = "fullDateFormat";
                    def = "EEEE MMMM d, yyyy G";
                    break;
                }
                case 1: {
                    name = "longDateFormat";
                    def = "MMMM d, yyyy";
                    break;
                }
                case 2: {
                    name = "mediumDateFormat";
                    def = "d-MMM-yy";
                    break;
                }
                case 3: {
                    name = "shortDateFormat";
                    def = "M/d/yy";
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            try {
                pattern = res == null ? def : res.getString(name);
            }
            catch (MissingResourceException x) {
                pattern = def;
            }
        }
        if (use_time) {
            String s;
            pattern = pattern == null ? "" : pattern + " ";
            switch (timeStyle) {
                case 0: {
                    name = "fullTimeFormat";
                    def = "h:mm:ss;S 'o''clock' a z";
                    break;
                }
                case 1: {
                    name = "longTimeFormat";
                    def = "h:mm:ss a z";
                    break;
                }
                case 2: {
                    name = "mediumTimeFormat";
                    def = "h:mm:ss a";
                    break;
                }
                case 3: {
                    name = "shortTimeFormat";
                    def = "h:mm a";
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            try {
                s = res == null ? def : res.getString(name);
            }
            catch (MissingResourceException x) {
                s = def;
            }
            pattern = pattern + s;
        }
        return new SimpleDateFormat(pattern, loc);
    }

    public static final DateFormat getDateInstance() {
        return DateFormat.getDateInstance(2, Locale.getDefault());
    }

    public static final DateFormat getDateInstance(int style) {
        return DateFormat.getDateInstance(style, Locale.getDefault());
    }

    public static final DateFormat getDateInstance(int style, Locale loc) {
        return DateFormat.computeInstance(style, loc, true, false);
    }

    public static final DateFormat getDateTimeInstance() {
        return DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
    }

    public static final DateFormat getDateTimeInstance(int dateStyle, int timeStyle) {
        return DateFormat.getDateTimeInstance(dateStyle, timeStyle, Locale.getDefault());
    }

    public static final DateFormat getDateTimeInstance(int dateStyle, int timeStyle, Locale loc) {
        return DateFormat.computeInstance(dateStyle, timeStyle, loc, true, true);
    }

    public static final DateFormat getInstance() {
        return DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public static final DateFormat getTimeInstance() {
        return DateFormat.getTimeInstance(2, Locale.getDefault());
    }

    public static final DateFormat getTimeInstance(int style) {
        return DateFormat.getTimeInstance(style, Locale.getDefault());
    }

    public static final DateFormat getTimeInstance(int style, Locale loc) {
        return DateFormat.computeInstance(style, loc, false, true);
    }

    public TimeZone getTimeZone() {
        return this.calendar.getTimeZone();
    }

    public int hashCode() {
        int hash = this.calendar.hashCode();
        if (this.numberFormat != null) {
            hash ^= this.numberFormat.hashCode();
        }
        return hash;
    }

    public boolean isLenient() {
        return this.calendar.isLenient();
    }

    public Date parse(String source) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        Date result = this.parse(source, pos);
        if (result == null) {
            int index = pos.getErrorIndex();
            if (index < 0) {
                index = pos.getIndex();
            }
            throw new ParseException("invalid Date syntax", index);
        }
        return result;
    }

    public abstract Date parse(String var1, ParsePosition var2);

    public Object parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public void setLenient(boolean lenient) {
        this.calendar.setLenient(lenient);
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.calendar.setTimeZone(timeZone);
    }
}

