/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;

public abstract class Signature {
    protected static final int UNINITIALIZED = 0;
    protected static final int SIGN = 2;
    protected static final int VERIFY = 3;
    protected int state = 0;
    private String name;

    protected Signature(String name) {
        this.name = name;
    }

    public static Signature getInstance(String algorithm) throws NoSuchAlgorithmException {
        String name = "Signature." + algorithm;
        Provider[] provs = Security.getProviders();
        for (int i = 0; i < provs.length; ++i) {
            String val = provs[i].getProperty(name);
            if (val == null) continue;
            try {
                return (Signature)Class.forName(val).newInstance();
            }
            catch (Throwable _) {
                // empty catch block
            }
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static Signature getInstance(String algorithm, String provider) throws NoSuchProviderException, NoSuchAlgorithmException {
        String name = "Signature." + algorithm;
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        String val = p.getProperty(name);
        if (val != null) {
            try {
                return (Signature)Class.forName(val).newInstance();
            }
            catch (Throwable _) {
                // empty catch block
            }
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public final void initVerify(PublicKey publicKey) throws InvalidKeyException {
        this.engineInitVerify(publicKey);
    }

    public final void initSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey);
    }

    public final byte[] sign() throws SignatureException {
        return this.engineSign();
    }

    public final boolean verify(byte[] signature) throws SignatureException {
        return this.engineVerify(signature);
    }

    public final void update(byte b) throws SignatureException {
        this.engineUpdate(b);
    }

    public final void update(byte[] data) throws SignatureException {
        this.engineUpdate(data, 0, data.length);
    }

    public final void update(byte[] data, int off, int len) throws SignatureException {
        this.engineUpdate(data, off, len);
    }

    public final String getAlgorithm() {
        return this.name;
    }

    public String toString() {
        return this.name + "; state = " + this.state;
    }

    public final void setParameter(String param, Object value) {
        this.engineSetParameter(param, value);
    }

    public final Object getParameter(String param) {
        return this.engineGetParameter(param);
    }

    protected abstract void engineInitVerify(PublicKey var1) throws InvalidKeyException;

    protected abstract void engineInitSign(PrivateKey var1) throws InvalidKeyException;

    protected abstract void engineUpdate(byte var1) throws SignatureException;

    protected abstract void engineUpdate(byte[] var1, int var2, int var3) throws SignatureException;

    protected abstract byte[] engineSign() throws SignatureException;

    protected abstract boolean engineVerify(byte[] var1) throws SignatureException;

    protected abstract void engineSetParameter(String var1, Object var2) throws InvalidParameterException;

    protected abstract Object engineGetParameter(String var1) throws InvalidParameterException;

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

