/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;

public final class Method
extends AccessibleObject
implements Member {
    private Class declaringClass;
    private Class[] exception_types;
    private String name;
    private Class[] parameter_types;
    private Class return_type;
    private int offset;

    public boolean equals(Object obj) {
        if (!(obj instanceof Method)) {
            return false;
        }
        Method m = (Method)obj;
        return this.declaringClass == m.declaringClass && this.offset == m.offset;
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public Class[] getExceptionTypes() {
        if (this.exception_types == null) {
            this.getType();
        }
        return (Class[])this.exception_types.clone();
    }

    public native int getModifiers();

    public native String getName();

    private native void getType();

    public Class[] getParameterTypes() {
        if (this.parameter_types == null) {
            this.getType();
        }
        return (Class[])this.parameter_types.clone();
    }

    public Class getReturnType() {
        if (this.return_type == null) {
            this.getType();
        }
        return this.return_type;
    }

    public int hashCode() {
        return this.getName().hashCode() + this.declaringClass.getName().hashCode();
    }

    public native Object invoke(Object var1, Object[] var2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    public String toString() {
        int i;
        if (this.parameter_types == null) {
            this.getType();
        }
        StringBuffer b = new StringBuffer();
        Modifier.toString(this.getModifiers(), b);
        b.append(" ");
        b.append(this.return_type.getName());
        b.append(" ");
        b.append(this.declaringClass.getName());
        b.append(".");
        b.append(this.getName());
        b.append("(");
        for (i = 0; i < this.parameter_types.length; ++i) {
            b.append(this.parameter_types[i].getName());
            if (i >= this.parameter_types.length - 1) continue;
            b.append(",");
        }
        b.append(")");
        if (this.exception_types.length > 0) {
            b.append(" throws ");
            for (i = 0; i < this.exception_types.length; ++i) {
                b.append(this.exception_types[i].getName());
                if (i >= this.exception_types.length - 1) continue;
                b.append(",");
            }
        }
        return b.toString();
    }

    private Method() {
    }
}

