/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.PropertyPermission;
import java.util.TimeZone;

public final class System {
    public static final InputStream in = new BufferedInputStream(new FileInputStream(FileDescriptor.in));
    public static final PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.out)), true);
    public static final PrintStream err = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.err)), true);
    private static SecurityManager secman = null;
    private static Properties properties = null;

    static /* synthetic */ Class class$(String type$) {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    public static native long currentTimeMillis();

    private static native String getSystemTimeZone();

    private static String getDefaultTimeZoneId() {
        String tzBasename;
        int GMToffset;
        String sysTimeZoneId = System.getSystemTimeZone();
        TimeZone tz = TimeZone.getTimeZone(sysTimeZoneId);
        if (tz.getID().equals(sysTimeZoneId)) {
            return sysTimeZoneId;
        }
        int startGMToffset = 0;
        int sysTimeZoneIdLength = sysTimeZoneId.length();
        for (int i = 0; i < sysTimeZoneIdLength && startGMToffset == 0; ++i) {
            if (!Character.isDigit(sysTimeZoneId.charAt(i))) continue;
            startGMToffset = i;
        }
        int startDaylightZoneName = 0;
        boolean usesDaylight = false;
        int i = sysTimeZoneIdLength - 1;
        while (i >= 0 && !Character.isDigit(sysTimeZoneId.charAt(i))) {
            startDaylightZoneName = i--;
        }
        if (startDaylightZoneName > 0) {
            usesDaylight = true;
        }
        if ((GMToffset = Integer.parseInt(startDaylightZoneName == 0 ? sysTimeZoneId.substring(startGMToffset) : sysTimeZoneId.substring(startGMToffset, startDaylightZoneName))) < 24) {
            GMToffset *= 3600;
        }
        if ((tz = TimeZone.getTimeZone(tzBasename = sysTimeZoneId.substring(0, startGMToffset))).getID().equals(tzBasename) && tz.getRawOffset() == (GMToffset *= -1000)) {
            boolean tzUsesDaylight = tz.useDaylightTime();
            if (usesDaylight && tzUsesDaylight || !usesDaylight && !tzUsesDaylight) {
                return tzBasename;
            }
        }
        String[] IDs = TimeZone.getAvailableIDs(GMToffset);
        for (int i2 = 0; i2 < IDs.length; ++i2) {
            boolean IDusesDaylight = TimeZone.getTimeZone(IDs[i2]).useDaylightTime();
            if ((!usesDaylight || !IDusesDaylight) && (usesDaylight || IDusesDaylight)) continue;
            return IDs[i2];
        }
        return null;
    }

    public static void exit(int status) {
        Runtime.getRuntime().exit(status);
    }

    public static void gc() {
        Runtime.getRuntime().gc();
    }

    public static String getenv(String name) {
        throw new Error();
    }

    private static native void init_properties();

    public static Properties getProperties() {
        if (secman != null) {
            secman.checkPropertiesAccess();
        }
        if (properties == null) {
            System.init_properties();
        }
        return properties;
    }

    public static String getProperty(String property) {
        if (secman != null) {
            secman.checkPropertyAccess(property);
        }
        if (properties == null) {
            System.init_properties();
        }
        return properties.getProperty(property);
    }

    public static String getProperty(String property, String defval) {
        if (secman != null) {
            secman.checkPropertyAccess(property, defval);
        }
        if (properties == null) {
            System.init_properties();
        }
        return properties.getProperty(property, defval);
    }

    public static SecurityManager getSecurityManager() {
        return secman;
    }

    public static native int identityHashCode(Object var0);

    public static void load(String pathname) {
        Runtime.getRuntime().load(pathname);
    }

    public static void loadLibrary(String libname) {
        Runtime.getRuntime().loadLibrary(libname);
    }

    public static void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }

    public static void runFinalizersOnExit(boolean run) {
        Runtime.getRuntime();
        Runtime.runFinalizersOnExit(run);
    }

    private static void checkSetIO() {
        if (secman != null) {
            secman.checkExec("");
        }
    }

    public static native void setErr(PrintStream var0);

    public static native void setIn(InputStream var0);

    public static native void setOut(PrintStream var0);

    public static void setProperties(Properties props) {
        if (secman != null) {
            secman.checkPropertiesAccess();
        }
        Class clazz = System.class$("java.lang.System");
        synchronized (clazz) {
            try {
                properties = props;
            }
            finally {
                Object var3_2 = null;
            }
            return;
        }
    }

    public static String setProperty(String key, String value) {
        if (secman != null) {
            secman.checkPermission(new PropertyPermission(key, "write"));
        }
        if (properties == null) {
            System.init_properties();
        }
        return (String)properties.setProperty(key, value);
    }

    public static void setSecurityManager(SecurityManager s) {
        if (secman != null) {
            secman.checkPermission(new RuntimePermission("setSecurityManager"));
        }
        secman = s;
    }

    private System() {
    }
}

