/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Long
extends Number
implements Comparable {
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final Class TYPE;
    private long value;
    private static final long serialVersionUID = 4290774380558885855L;

    public Long(long val) {
        this.value = val;
    }

    public Long(String str) {
        this.value = Long.parseLong(str, 10);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int compareTo(Long anotherLong) {
        if (this.value == anotherLong.value) {
            return 0;
        }
        if (this.value > anotherLong.value) {
            return 1;
        }
        return -1;
    }

    public int compareTo(Object o) {
        return this.compareTo((Long)o);
    }

    public static Long decode(String str) {
        boolean isNeg = false;
        int index = 0;
        int radix = 10;
        int len = str.length();
        if (len == 0) {
            throw new NumberFormatException();
        }
        if (str.charAt(0) == '-') {
            radix = 10;
            ++index;
            isNeg = true;
        } else if (str.charAt(index) == '#') {
            radix = 16;
            ++index;
        } else if (str.charAt(index) == '0') {
            if (len == 1) {
                return new Long(0L);
            }
            if (str.charAt(++index) == 'x') {
                radix = 16;
                ++index;
            } else {
                radix = 8;
            }
        }
        if (index >= len) {
            throw new NumberFormatException();
        }
        return new Long(Long.parseLong(str, index, len, isNeg, radix));
    }

    public boolean equals(Object obj) {
        return obj instanceof Long && ((Long)obj).value == this.value;
    }

    public static Long getLong(String prop) {
        return Long.getLong(prop, null);
    }

    public static Long getLong(String prop, long defval) {
        Long val = Long.getLong(prop, null);
        if (val == null) {
            return new Long(defval);
        }
        return val;
    }

    public static Long getLong(String prop, Long defobj) {
        try {
            String val = System.getProperty(prop);
            if (val != null) {
                return Long.decode(val);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defobj;
    }

    public int hashCode() {
        return (int)this.longValue() ^ (int)(this >>> 32);
    }

    public static long parseLong(String str) {
        return Long.parseLong(str, 10);
    }

    public static long parseLong(String str, int radix) {
        int len = str.length();
        if (len == 0 || radix < 2 || radix > 36) {
            throw new NumberFormatException();
        }
        boolean isNeg = false;
        int index = 0;
        if (str.charAt(index) == '-') {
            if (len > 1) {
                isNeg = true;
                ++index;
            } else {
                throw new NumberFormatException();
            }
        }
        return Long.parseLong(str, index, len, isNeg, radix);
    }

    private static long parseLong(String str, int index, int len, boolean isNeg, int radix) {
        long val = 0L;
        long max = Long.MAX_VALUE / (long)radix;
        if (isNeg && Long.MAX_VALUE % (long)radix == (long)(radix - 1)) {
            ++max;
        }
        while (index < len) {
            if (val < 0L || val > max) {
                throw new NumberFormatException();
            }
            int digval = Character.digit(str.charAt(index), radix);
            if (digval < 0) {
                throw new NumberFormatException();
            }
            if (!((val = val * (long)radix + (long)digval) >= 0L || isNeg && val == Long.MIN_VALUE)) {
                throw new NumberFormatException();
            }
            ++index;
        }
        if (isNeg) {
            return -val;
        }
        return val;
    }

    public static String toBinaryString(long num) {
        return Long.toUnsignedString(num, 1);
    }

    public static String toHexString(long num) {
        return Long.toUnsignedString(num, 4);
    }

    public static String toOctalString(long num) {
        return Long.toUnsignedString(num, 3);
    }

    private static String toUnsignedString(long num, int exp) {
        int radix = 1 << (exp & 0x1F);
        long mask = radix - 1;
        char[] buffer = new char[64];
        int i = 64;
        do {
            buffer[--i] = Character.forDigit((int)num & (int)mask, radix);
        } while ((num >>>= exp & 0x3F) != 0L);
        return String.valueOf(buffer, i, 64 - i);
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public static String toString(long num) {
        boolean isNeg;
        if (num <= Integer.MAX_VALUE && num >= Integer.MIN_VALUE) {
            return Integer.toString((int)num);
        }
        char[] buffer = new char[20];
        int i = 20;
        if (num < 0L) {
            isNeg = true;
            if ((num = -num) < 0L) {
                buffer[--i] = 56;
                num = 0xCCCCCCCCCCCCCCCL;
            }
        } else {
            isNeg = false;
        }
        do {
            buffer[--i] = (char)((long)48 + num % (long)10);
        } while ((num /= (long)10) > 0L);
        if (isNeg) {
            buffer[--i] = 45;
        }
        return String.valueOf(buffer, i, 20 - i);
    }

    public static String toString(long num, int radix) {
        boolean isNeg;
        if (radix == 10 || radix < 2 || radix > 36) {
            return Long.toString(num);
        }
        if (num <= Integer.MAX_VALUE && num >= Integer.MIN_VALUE) {
            return Integer.toString((int)num, radix);
        }
        char[] buffer = new char[65];
        int i = 65;
        if (num < 0L) {
            isNeg = true;
            if ((num = -num) < 0L) {
                buffer[--i] = Character.forDigit((int)(-(num + (long)radix) % (long)radix), radix);
                num = -(num / (long)radix);
            }
        } else {
            isNeg = false;
        }
        do {
            buffer[--i] = Character.forDigit((int)(num % (long)radix), radix);
        } while ((num /= (long)radix) > 0L);
        if (isNeg) {
            buffer[--i] = 45;
        }
        return String.valueOf(buffer, i, 65 - i);
    }

    public static Long valueOf(String str) {
        return new Long(Long.parseLong(str, 10));
    }

    public static Long valueOf(String str, int radix) {
        return new Long(Long.parseLong(str, radix));
    }
}

