/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Float
extends Number
implements Comparable {
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final float MIN_VALUE = 1.4E-45f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NaN = 0.0f / 0.0f;
    public static final Class TYPE;
    private float value;
    private static final long serialVersionUID = -2671257302660747028L;

    public Float(float value) {
        this.value = value;
    }

    public Float(double value) {
        this.value = (float)value;
    }

    public Float(String s) {
        this.value = Float.valueOf(s).floatValue();
    }

    public static float parseFloat(String s) {
        return (float)Double.parseDouble(s);
    }

    public String toString() {
        return Float.toString(this.value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Float)) {
            return false;
        }
        Float f = (Float)obj;
        return Float.floatToIntBits(this.value) == Float.floatToIntBits(f.floatValue());
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public static String toString(float v) {
        return Double.toString(v, true);
    }

    public static Float valueOf(String s) {
        return new Float(Double.valueOf(s).floatValue());
    }

    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public static boolean isNaN(float v) {
        int bits = Float.floatToIntBits(v);
        int e = bits & 0x7F800000;
        int f = bits & 0x7FFFFF;
        return e == 2139095040 && f != 0;
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public static boolean isInfinite(float v) {
        int bits = Float.floatToIntBits(v);
        int f = bits & Integer.MAX_VALUE;
        return f == 2139095040;
    }

    public static native int floatToIntBits(float var0);

    public static native int floatToRawIntBits(float var0);

    public static native float intBitsToFloat(int var0);

    public int compareTo(Float d) {
        float v = d.value;
        if (Float.isNaN(this.value)) {
            if (Float.isNaN(v)) {
                return 1;
            }
            return 0;
        }
        if (Float.isNaN(v)) {
            return -1;
        }
        if ((double)this.value == 0.0 && (double)v == 0.0) {
            return 1;
        }
        if ((double)this.value == 0.0 && (double)v == 0.0) {
            return -1;
        }
        if (this.value == v) {
            return 0;
        }
        if (this.value > v) {
            return 1;
        }
        return -1;
    }

    public int compareTo(Object o) {
        return this.compareTo((Float)o);
    }
}

