/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.gcj.runtime.VMClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;

public abstract class ClassLoader {
    private static ClassLoader system;
    private ClassLoader parent;

    public final ClassLoader getParent() {
        return this.parent;
    }

    public static ClassLoader getSystemClassLoader() {
        if (system == null) {
            system = VMClassLoader.instance;
        }
        return system;
    }

    protected ClassLoader() {
        this(null);
    }

    protected ClassLoader(ClassLoader parent) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
        this.parent = parent;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected Class loadClass(String name, boolean link) throws ClassNotFoundException {
        Class c = this.findLoadedClass(name);
        if (c == null) {
            try {
                if (this.parent != null) {
                    return this.parent.loadClass(name, link);
                }
                c = system.findClass(name);
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        if (c == null) {
            c = this.findClass(name);
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        if (link) {
            this.resolveClass(c);
        }
        return c;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException(name);
    }

    protected final Class defineClass(byte[] data, int off, int len) {
        return this.defineClass(null, data, off, len);
    }

    protected final synchronized Class defineClass(String name, byte[] data, int off, int len) {
        if (data == null || data.length < off + len || off < 0 || len < 0) {
            throw new ClassFormatError("arguments to defineClass are meaningless");
        }
        if (name != null && this.findLoadedClass(name) != null) {
            throw new LinkageError("class " + name + " already loaded");
        }
        try {
            return this.defineClass0(name, data, off, len);
        }
        catch (ClassFormatError x) {
            throw x;
        }
        catch (VirtualMachineError x) {
            throw x;
        }
        catch (Throwable x) {
            throw new InternalError("Unexpected exception while defining class " + name + ": " + x.toString());
        }
    }

    private native Class defineClass0(String var1, byte[] var2, int var3, int var4) throws ClassFormatError;

    protected final void resolveClass(Class clazz) {
        ClassLoader.resolveClass0(clazz);
    }

    static void resolveClass0(Class clazz) {
        Class clazz2 = clazz;
        synchronized (clazz2) {
            try {
                try {
                    ClassLoader.linkClass0(clazz);
                }
                catch (Throwable x) {
                    ClassLoader.markClassErrorState0(clazz);
                    if (x instanceof Error) {
                        throw (Error)x;
                    }
                    throw new InternalError("unexpected exception during linking: " + x);
                }
                Object var3_4 = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                throw throwable;
            }
        }
    }

    private static native void linkClass0(Class var0);

    private static native void markClassErrorState0(Class var0);

    protected final Class findSystemClass(String name) throws ClassNotFoundException {
        return ClassLoader.getSystemClassLoader().loadClass(name);
    }

    protected final void setSigners(Class claz, Object[] signers) {
    }

    protected final native Class findLoadedClass(String var1);

    public static InputStream getSystemResourceAsStream(String name) {
        return ClassLoader.getSystemClassLoader().getResourceAsStream(name);
    }

    public static URL getSystemResource(String name) {
        return ClassLoader.getSystemClassLoader().getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        try {
            URL res = this.getResource(name);
            if (res == null) {
                return null;
            }
            return res.openStream();
        }
        catch (IOException x) {
            return null;
        }
    }

    public URL getResource(String name) {
        URL result = null;
        ClassLoader delegate = this.parent;
        if (delegate == null) {
            delegate = ClassLoader.getSystemClassLoader();
        }
        if (this != delegate) {
            result = delegate.getResource(name);
        }
        if (result != null) {
            return result;
        }
        return this.findResource(name);
    }

    protected URL findResource(String name) {
        return null;
    }

    public final Enumeration getResources(String name) throws IOException {
        Enumeration result = null;
        ClassLoader delegate = this.parent;
        if (delegate == null) {
            delegate = ClassLoader.getSystemClassLoader();
        }
        if (this != delegate) {
            result = delegate.getResources(name);
        }
        if (result != null) {
            return result;
        }
        return this.findResources(name);
    }

    protected Enumeration findResources(String name) throws IOException {
        return null;
    }
}

