/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PushbackInputStream
extends FilterInputStream {
    protected byte[] buf;
    protected int pos;

    public PushbackInputStream(InputStream in) {
        this(in, 1);
    }

    public PushbackInputStream(InputStream in, int size) {
        super(in);
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        this.buf = new byte[size];
        this.pos = this.buf.length;
    }

    public int available() throws IOException {
        return this.pos + super.available();
    }

    public void close() throws IOException {
        this.buf = null;
        super.close();
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.pos < this.buf.length) {
            return this.buf[this.pos++] & 0xFF;
        }
        return super.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int numBytes = Math.min(this.buf.length - this.pos, len);
        if (numBytes > 0) {
            System.arraycopy(this.buf, this.pos, b, off, numBytes);
            this.pos += numBytes;
            return numBytes;
        }
        return super.read(b, off, len);
    }

    public void unread(int b) throws IOException {
        if (this.pos <= 0) {
            throw new IOException();
        }
        this.buf[this.pos += -1] = (byte)b;
    }

    public void unread(byte[] b) throws IOException {
        this.unread(b, 0, b.length);
    }

    public void unread(byte[] b, int off, int len) throws IOException {
        if (this.pos < len) {
            throw new IOException();
        }
        System.arraycopy(b, off, this.buf, this.pos - len, len);
        this.pos -= len;
    }

    public long skip(long n) throws IOException {
        long origN = n;
        if (n > 0L) {
            int numread = (int)Math.min((long)(this.buf.length - this.pos), n);
            this.pos += numread;
            n -= (long)numread;
            n -= super.skip(n);
        }
        return origN - n;
    }
}

