/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LineNumberInputStream
extends FilterInputStream {
    private int lineNumber;
    private int markLineNumber;
    private boolean justReadReturnChar;

    private /* synthetic */ void finit$() {
        this.lineNumber = 0;
        this.markLineNumber = 0;
        this.justReadReturnChar = false;
    }

    public LineNumberInputStream(InputStream in) {
        super(in);
        this.finit$();
    }

    public int available() throws IOException {
        return this.in.available() / 2;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.markLineNumber = this.lineNumber;
    }

    public int read() throws IOException {
        int ch = this.in.read();
        if (ch == 10) {
            if (this.justReadReturnChar) {
                ch = this.in.read();
                this.justReadReturnChar = false;
            } else {
                ++this.lineNumber;
            }
        } else if (ch == 13) {
            ch = 10;
            this.justReadReturnChar = true;
            ++this.lineNumber;
        } else {
            this.justReadReturnChar = false;
        }
        return ch;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int ch;
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int origOff = off;
        while (len-- > 0 && (ch = this.read()) >= 0) {
            b[off++] = (byte)ch;
        }
        if (off == origOff) {
            return -1;
        }
        return off - origOff;
    }

    public void reset() throws IOException {
        this.in.reset();
        this.lineNumber = this.markLineNumber;
        this.justReadReturnChar = false;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public long skip(long n) throws IOException {
        int ch;
        if (n <= 0L) {
            return 0L;
        }
        long origN = n;
        while ((ch = this.read()) >= 0) {
            if (ch == 10 || ch == 13) {
                ++this.lineNumber;
            }
            if ((n += (long)-1) > 0L) continue;
        }
        return origN - n;
    }
}

