/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import gnu.java.io.ClassLoaderObjectInputStream;
import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;

public class Beans {
    static boolean designTime = false;
    static boolean guiAvailable = true;

    public static Object instantiate(ClassLoader cl, String beanName) throws ClassNotFoundException, IOException {
        Class beanClass;
        Object bean;
        InputStream serStream = cl == null ? ClassLoader.getSystemResourceAsStream(beanName.replace('.', '/') + ".ser") : cl.getResourceAsStream(beanName.replace('.', '/') + ".ser");
        if (serStream != null) {
            ObjectInputStream ois;
            if (cl == null) {
                ois = new ObjectInputStream(serStream);
                bean = ois.readObject();
            } else {
                ois = new ClassLoaderObjectInputStream(serStream, cl);
                bean = ois.readObject();
            }
        } else if (cl == null) {
            beanClass = Class.forName(beanName);
            try {
                bean = beanClass.newInstance();
            }
            catch (IllegalAccessException E) {
                bean = null;
            }
            catch (InstantiationException E) {
                bean = null;
            }
        } else {
            beanClass = cl.loadClass(beanName);
            try {
                bean = beanClass.newInstance();
            }
            catch (IllegalAccessException E) {
                bean = null;
            }
            catch (InstantiationException E) {
                bean = null;
            }
        }
        if (bean instanceof Applet) {
            Applet a = (Applet)bean;
            if (serStream == null) {
                a.init();
            }
        }
        return bean;
    }

    public static Object getInstanceOf(Object bean, Class newClass) {
        return bean;
    }

    public static boolean isInstanceOf(Object bean, Class newBeanClass) {
        return newBeanClass.isInstance(bean);
    }

    public static boolean isGuiAvailable() {
        return guiAvailable;
    }

    public static boolean isDesignTime() {
        return designTime;
    }

    public static void setGuiAvailable(boolean guiAvailable) {
        Beans.guiAvailable = guiAvailable;
    }

    public static void setDesignTime(boolean designTime) {
        Beans.designTime = designTime;
    }

    static {
        designTime = false;
        guiAvailable = true;
    }
}

