/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;

public class InvocationEvent
extends AWTEvent
implements ActiveEvent {
    public static final int INVOCATION_DEFAULT = 1200;
    public static final int INVOCATION_FIRST = 1200;
    public static final int INVOCATION_LAST = 1200;
    protected boolean catchExceptions;
    protected Object notifier;
    protected Runnable runnable;
    private Exception exception;

    protected InvocationEvent(Object source, int id, Runnable runnable, Object notifier, boolean catchExceptions) {
        super(source, id);
        this.runnable = runnable;
        this.notifier = notifier;
        this.catchExceptions = catchExceptions;
    }

    public InvocationEvent(Object source, Runnable runnable) {
        super(source, 1200);
        this.runnable = runnable;
    }

    public InvocationEvent(Object source, Runnable runnable, Object notifier, boolean catchExceptions) {
        super(source, 1200);
        this.runnable = runnable;
        this.notifier = notifier;
        this.catchExceptions = catchExceptions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispatch() {
        Object e = null;
        if (this.catchExceptions) {
            try {
                this.runnable.run();
            }
            catch (Exception x) {
                this.exception = x;
            }
        } else {
            this.runnable.run();
        }
        if (this.notifier == null) return;
        Object object = this.notifier;
        synchronized (object) {
            try {
                this.notifier.notifyAll();
                return;
            }
            finally {
                Object var4_4 = null;
            }
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public String paramString() {
        String r = this.id == 1200 ? "INVOCATION_DEFAULT" : "unknown type";
        r = r + new StringBuffer(",runnable=").append(this.runnable).append(",notifier=").append(this.notifier).append(",catchExceptions=").append(this.catchExceptions);
        return r;
    }
}

