/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.AdjustmentListener;
import java.awt.peer.ScrollPanePeer;

public class ScrollPane
extends Container {
    public static final int SCROLLBARS_AS_NEEDED = 0;
    public static final int SCROLLBARS_ALWAYS = 1;
    public static final int SCROLLBARS_NEVER = 2;
    ScrollPaneAdjustable hscroll;
    ScrollPaneAdjustable vscroll;
    int policy;

    private /* synthetic */ void finit$() {
        this.hscroll = new ScrollPaneAdjustable(this, 0);
        this.vscroll = new ScrollPaneAdjustable(this, 1);
    }

    public ScrollPane() {
        this(0);
    }

    public ScrollPane(int policy) {
        this.finit$();
        if (policy != 0 && policy != 1 && policy != 2) {
            throw new IllegalArgumentException("invalid value for policy");
        }
        this.policy = policy;
        this.setSize(100, 100);
    }

    protected final void addImpl(Component comp, Object constraints, int pos) {
        if (pos > 0) {
            throw new IllegalArgumentException("pos must be <= 0");
        }
        if (this.ncomponents > 0) {
            this.remove(this.component[0]);
        }
        if (comp.isLightweight()) {
            Panel p = new Panel();
            p.add(comp);
            comp = p;
        }
        super.addImpl(comp, constraints, pos);
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createScrollPane(this);
        }
        super.addNotify();
    }

    public void doLayout() {
        ScrollPanePeer spp = (ScrollPanePeer)this.peer;
        Dimension c = this.component[0].getPreferredSize();
        this.component[0].setSize(c.width, c.height);
        spp.childResized(c.width, c.height);
        this.setScrollPosition(this.hscroll.getValue(), this.vscroll.getValue());
    }

    public Adjustable getHAdjustable() {
        return this.hscroll;
    }

    public int getHScrollbarHeight() {
        if (this.peer == null) {
            return 0;
        }
        ScrollPanePeer spp = (ScrollPanePeer)this.peer;
        return spp.getHScrollbarHeight();
    }

    public int getScrollbarDisplayPolicy() {
        return this.policy;
    }

    public Point getScrollPosition() {
        return new Point(this.hscroll.getValue(), this.vscroll.getValue());
    }

    public Adjustable getVAdjustable() {
        return this.vscroll;
    }

    public Dimension getViewportSize() {
        Insets ins = this.getInsets();
        int myw = this.width - ins.left - ins.right;
        int myh = this.height - ins.top - ins.bottom;
        Dimension cs = this.ncomponents > 0 ? this.component[0].getPreferredSize() : new Dimension(myw, myh);
        cs.setSize(myw, myh);
        return cs;
    }

    public int getVScrollbarWidth() {
        if (this.peer == null) {
            return 0;
        }
        ScrollPanePeer spp = (ScrollPanePeer)this.peer;
        return spp.getVScrollbarWidth();
    }

    public String paramString() {
        return "[" + this.getClass().getName() + ": " + (this.ncomponents > 0 ? this.component[0].paramString() : "") + "]";
    }

    public final void setLayout(LayoutManager m) {
    }

    public void setScrollPosition(int x, int y) {
        if (this.ncomponents == 0) {
            throw new NullPointerException("no child in ScrollPane");
        }
        Dimension child_d = this.component[0].getPreferredSize();
        Dimension our_d = this.getViewportSize();
        int xmax = Math.max(0, child_d.width - our_d.width);
        int ymax = Math.max(0, child_d.height - our_d.height);
        if (x < 0) {
            x = 0;
        } else if (x > xmax) {
            x = xmax;
        }
        if (y < 0) {
            y = 0;
        } else if (y > ymax) {
            y = ymax;
        }
        ScrollPanePeer spp = (ScrollPanePeer)this.peer;
        spp.setScrollPosition(x, y);
    }

    public void setScrollPosition(Point p) {
        this.setScrollPosition(p.x, p.y);
    }

    class ScrollPaneAdjustable
    implements Adjustable {
        private /* synthetic */ ScrollPane this$0;
        AdjustmentListener listeners;
        int orient;
        int unit;
        int block;
        int value;

        public ScrollPaneAdjustable(ScrollPane this$0, int orient) {
            this.this$0 = this$0;
            this.orient = orient;
        }

        public void addAdjustmentListener(AdjustmentListener l) {
            this.listeners = AWTEventMulticaster.add(this.listeners, l);
        }

        public int getBlockIncrement() {
            return this.block;
        }

        public int getMaximum() {
            Dimension child_d = ((Component)this.this$0).getPreferredSize();
            Dimension our_d = this.this$0.getViewportSize();
            int xmax = Math.max(0, child_d.width - our_d.width);
            int ymax = Math.max(0, child_d.height - our_d.height);
            if (this.orient == 0) {
                return xmax;
            }
            return ymax;
        }

        public int getMinimum() {
            return 0;
        }

        public int getOrientation() {
            return this.orient;
        }

        public int getUnitIncrement() {
            return this.unit;
        }

        public int getValue() {
            return this.value;
        }

        public int getVisibleAmount() {
            Dimension d = this.this$0.getViewportSize();
            if (this.orient == 0) {
                return d.width;
            }
            return d.height;
        }

        public void removeAdjustmentListener(AdjustmentListener l) {
            this.listeners = AWTEventMulticaster.remove(this.listeners, l);
        }

        public void setBlockIncrement(int b) {
            throw new AWTError("can't use setBlockIncrement on this Adjustable");
        }

        public void setMaximum(int max) {
            throw new AWTError("can't use setMaximum on this Adjustable");
        }

        public void setMinimum(int min) {
            throw new AWTError("can't use setMinimum on this Adjustable");
        }

        public void setUnitIncrement(int u) {
            this.unit = u;
            if (this.this$0.peer != null) {
                ScrollPanePeer spp = (ScrollPanePeer)this.this$0.peer;
                spp.setUnitIncrement(this, u);
            }
        }

        public void setValue(int v) {
            this.value = v;
            if (this.this$0.peer != null) {
                ScrollPanePeer spp = (ScrollPanePeer)this.this$0.peer;
                spp.setValue(this, v);
            }
        }

        public void setVisibleAmount(int v) {
            throw new AWTError("can't use setVisibleAmount on this Adjustable");
        }
    }
}

