/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.MenuComponent;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.MenuItemPeer;
import java.util.EventListener;

public class MenuItem
extends MenuComponent {
    boolean enabled;
    String label;
    String actionCommand;
    long eventMask;
    MenuShortcut shortcut;
    int menuItemSerializedDataVersion;
    transient ActionListener actionListener;

    static /* synthetic */ Class class$(String type$) {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public MenuItem() {
        this.label = "";
    }

    public MenuItem(String label) {
        this.label = label;
    }

    public MenuItem(String label, MenuShortcut shortcut) {
        this.label = label;
        this.shortcut = shortcut;
    }

    public String getLabel() {
        return this.label;
    }

    public synchronized void setLabel(String label) {
        this.label = label;
        if (this.peer != null) {
            MenuItemPeer mp = (MenuItemPeer)this.peer;
            mp.setLabel(label);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean b) {
        if (this.enabled != b) {
            this.enabled = b;
            if (this.peer != null) {
                MenuItemPeer mp = (MenuItemPeer)this.peer;
                mp.setEnabled(b);
            }
        }
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void enable(boolean b) {
        this.setEnabled(b);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public MenuShortcut getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(MenuShortcut s) {
        this.shortcut = s;
    }

    public void deleteShortcut() {
        this.setShortcut(null);
    }

    protected final void enableEvents(long eventsToEnable) {
        this.eventMask |= eventsToEnable;
    }

    protected final void disableEvents(long eventsToDisable) {
        this.eventMask &= eventsToDisable ^ (long)-1;
    }

    public void setActionCommand(String command) {
        this.actionCommand = command;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public synchronized void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
        if (this.actionListener != null) {
            this.enableEvents(128);
        }
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public void addNotify() {
        if (this.peer != null) {
            this.peer = Toolkit.getDefaultToolkit().createMenuItem(this);
        }
    }

    public EventListener[] getListeners(Class listenerType) {
        if (listenerType == MenuItem.class$("java.awt.event.ActionListener")) {
            return Component.getListenersImpl(listenerType, this.actionListener);
        }
        return Component.getListenersImpl(listenerType, null);
    }

    void dispatchEventImpl(AWTEvent e) {
        if (e.id <= 1001 && e.id >= 1001 && (this.actionListener != null || (this.eventMask & (long)128) != 0L)) {
            this.processEvent(e);
        }
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e);
        }
    }

    protected void processActionEvent(ActionEvent e) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e);
        }
    }

    public String paramString() {
        return this.name + ",label=" + this.label;
    }
}

