/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class BorderLayout
implements LayoutManager2,
Serializable {
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";
    public static final String BEFORE_FIRST_LINE = "First";
    public static final String AFTER_LAST_LINE = "Last";
    public static final String BEFORE_LINE_BEGINS = "Before";
    public static final String AFTER_LINE_ENDS = "After";
    int hgap;
    int vgap;
    Component north;
    Component south;
    Component east;
    Component west;
    Component center;
    static final Dimension DIM_0;
    static final Dimension DIM_MAX;

    public BorderLayout() {
        this(0, 0);
    }

    public BorderLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints == null || CENTER.equals(constraints)) {
            this.center = comp;
        } else if (NORTH.equals(constraints)) {
            this.north = comp;
        } else if (SOUTH.equals(constraints)) {
            this.south = comp;
        } else if (EAST.equals(constraints)) {
            this.east = comp;
        } else if (WEST.equals(constraints)) {
            this.west = comp;
        }
    }

    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(comp, name);
    }

    public void removeLayoutComponent(Component comp) {
        if (this.center == comp) {
            this.center = null;
        } else if (this.north == comp) {
            this.north = null;
        } else if (this.south == comp) {
            this.south = null;
        } else if (this.east == comp) {
            this.east = null;
        } else if (this.west == comp) {
            this.west = null;
        }
    }

    public Dimension minimumLayoutSize(Container target) {
        return this.calcSize(this.getMinimumSize(this.center), this.getMinimumSize(this.north), this.getMinimumSize(this.south), this.getMinimumSize(this.east), this.getMinimumSize(this.west), target);
    }

    public Dimension preferredLayoutSize(Container target) {
        return this.calcSize(this.getPreferredSize(this.center), this.getPreferredSize(this.north), this.getPreferredSize(this.south), this.getPreferredSize(this.east), this.getPreferredSize(this.west), target);
    }

    public Dimension maximumLayoutSize(Container target) {
        return (Dimension)DIM_MAX.clone();
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }

    public void layoutContainer(Container target) {
        Insets i = target.getInsets();
        Dimension c = this.getPreferredSize(this.center);
        Dimension n = this.getPreferredSize(this.north);
        Dimension s = this.getPreferredSize(this.south);
        Dimension e = this.getPreferredSize(this.east);
        Dimension w = this.getPreferredSize(this.west);
        Dimension t = target.getSize();
        int x1 = i.left;
        int x2 = x1 + w.width + this.hgap;
        int x3 = t.width - i.right - e.width;
        int ww = t.width - i.right - i.left;
        int y1 = i.top;
        int y2 = y1 + n.height + this.vgap;
        int y3 = t.height - i.bottom - s.height;
        int hh = y3 - y2 - this.vgap;
        this.setBounds(this.center, x2, y2, x3 - x2 - this.hgap, hh);
        this.setBounds(this.north, x1, y1, ww, n.height);
        this.setBounds(this.south, x1, y3, ww, s.height);
        this.setBounds(this.west, x1, y2, w.width, hh);
        this.setBounds(this.east, x3, y2, e.width, hh);
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + "]";
    }

    void setBounds(Component comp, int x, int y, int w, int h) {
        if (comp == null) {
            return;
        }
        comp.setBounds(x, y, w, h);
    }

    Dimension getMinimumSize(Component comp) {
        if (comp == null) {
            return DIM_0;
        }
        return comp.getMinimumSize();
    }

    Dimension getPreferredSize(Component comp) {
        if (comp == null) {
            return DIM_0;
        }
        return comp.getPreferredSize();
    }

    Dimension calcSize(Dimension c, Dimension n, Dimension s, Dimension e, Dimension w, Container target) {
        Insets i = target.getInsets();
        return new Dimension(c.width + e.width + w.width + this.hgap * 2 + i.left + i.right, c.height + n.height + s.height + this.vgap * 2 + i.top + i.bottom);
    }

    static {
        NORTH = NORTH;
        SOUTH = SOUTH;
        EAST = EAST;
        WEST = WEST;
        CENTER = CENTER;
        BEFORE_FIRST_LINE = BEFORE_FIRST_LINE;
        AFTER_LAST_LINE = AFTER_LAST_LINE;
        BEFORE_LINE_BEGINS = BEFORE_LINE_BEGINS;
        AFTER_LINE_ENDS = AFTER_LINE_ENDS;
        DIM_0 = new Dimension(0, 0);
        DIM_MAX = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }
}

