/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MPEG3IO_H
#define MPEG3IO_H


#include <stdio.h>
#include "libxmps/libxmps.h"
#include "mpeg3private.inc"


typedef struct {
  
  xmps_media_plugin_t *media;
  char                 path[MPEG3_STRLEN];
  long                 current_byte;
  long                 total_bytes;
  
} mpeg3_fs_t;

#define mpeg3io_tell(fs)        (((mpeg3_fs_t *)(fs))->current_byte)
#define mpeg3io_eof(fs)         (((mpeg3_fs_t *)(fs))->current_byte >= ((mpeg3_fs_t *)(fs))->total_bytes)
#define mpeg3io_bof(fs)	        (((mpeg3_fs_t *)(fs))->current_byte < 0)
#define mpeg3io_total_bytes(fs) (((mpeg3_fs_t *)(fs))->total_bytes)


extern inline unsigned int mpeg3io_read_int32(mpeg3_fs_t *fs)
{
  unsigned int result;
  unsigned char  a, b, c, d;

  fs->media->read(fs->media, &a, 1);
  fs->media->read(fs->media, &b, 1);
  fs->media->read(fs->media, &c, 1);
  fs->media->read(fs->media, &d, 1);

  result = ((unsigned int) a << 24) + ((unsigned int)b << 16) + ((unsigned int)c << 8) + (unsigned int)d;

  fs->current_byte += 4;
  
  return result;
}

extern inline unsigned int mpeg3io_read_char(mpeg3_fs_t *fs)
{
  unsigned char data;
  unsigned int  result;

  fs->current_byte++;

  fs->media->read(fs->media, &data, 1);

  result = data;
  
  return result;
}

#endif









