/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * xmps_plugins.h : global types and definitions for plugins.
 *
 */

#ifndef _DUMMY_SYSTEM_H
#define _DUMMY_SYSTEM_H

/*********************************************************************
 *                             INCLUDES                              *
 *********************************************************************/

#include <libxmps/libxmps.h>

/*
 * includes : system 
 *
 */

#include <glib.h>

/*********************************************************************
 *                            FUNCTIONS                              *
 *********************************************************************/

/*
 * see libxmps.h for
 * function details.
 *
 */

unsigned int      dummy_open (xmps_system_plugin_t *system);
void*             dummy_get  (xmps_system_plugin_t *system, unsigned int flag, void * data);
unsigned int      dummy_set  (xmps_system_plugin_t *system, unsigned int flag, void *data);
unsigned int      dummy_seek (xmps_system_plugin_t *system, unsigned int data_id, unsigned int pos, xmps_seeking_method_t method);
int               dummy_read (xmps_system_plugin_t *system, unsigned int data_id, void *buffer, long size);
unsigned int      dummy_write(xmps_system_plugin_t *system, unsigned int data_id, const void *buffer, unsigned int size);
unsigned int      dummy_close(xmps_system_plugin_t *system);

#endif
