/*
    Image stretcher
    Copyright (C) 2000 damien chavarria

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/  
  
/*********************************************************************
 *                             INCLUDES                              *
 *********************************************************************/

#include "stretch.h"
#include "libxmps/libxmps.h"

/*********************************************************************
 *                             FUNCTIONS                             *
 *********************************************************************/

void stretch_line_16bpp(short *src, short* dst, int width, int new_width) {
  
  register int i;

  for( i = 0; i < new_width; i++) {
    *(dst + i) = *(src + i*width/new_width);
  }

}

void AS_stretchBlit (void *scr, 
		     void *dest, 
		     int srcw, 
		     int srch, 
		     int dstw, 
		     int dsth, 
		     int bpp)
{
  unsigned short  *src_s;
  unsigned short  *dst_s;
  
  unsigned char   *src_b;
  unsigned char   *dst_b;
  
  register int i, j;

  switch(bpp)
    {
    case 16:

      XMPS_DEBUG("bitting");

      src_s = (unsigned short *) scr;
      dst_s = (unsigned short *) dest;

      memset(dst_s, 255, dstw*dsth*2);

      /*
       * stretch each line into place
       *
       */
      
      for(j = 0; j < srch; j++) {
	stretch_line_16bpp(src_s + srcw*j, dst_s + dstw*(j*dsth/srch), srcw, dstw);
      }
      
      /*
       * then final pass the memcopy lines
       *
       */
      
      for(j = 0; j < dsth; j++) {
	
	if( *(dst_s + dstw*j) == 65535 && *(dst_s + dstw*j + dstw/2) == 65535) {
	  memcpy(dst_s + dstw*j, dst_s + dstw*(j - 1), dstw*2);
	}
      }
      

      break;
    case 24:
    case 32:
      src_b = (unsigned char *) scr;
      dst_b = (unsigned char *) dest;

      for(j = 0; j < dsth; j++)
	{
	  for(i = 0; i < dstw; i++)
	    {
	      *dst_b++ = *(src_b + (j * srch / dsth) * 3 * srcw + 3*(i*srcw/dstw));
	      *dst_b++ = *(src_b + (j * srch / dsth) * 3 * srcw + 3*(i*srcw/dstw) + 1);
	      *dst_b++ = *(src_b + (j * srch / dsth) * 3 * srcw + 3*(i*srcw/dstw) + 2);
	    }
	}
      break;
    }
  
}

void AS_copy_decal(void *src, 
		   void *dst, 
		   int x, 
		   int y, 
		   int w, 
		   int h, 
		   int bpp)
{
  register int j;
  unsigned int width;

  width = w*bpp/8;

  switch(bpp)
    {
    case 16:
      for(j=0; j<h; j++)
	{
	  memcpy(dst + 2*(j+y)*(w+x+1) + 2*x, src + j*width, width);
	}
      break;
    case 24:
      for(j=0; j<h; j++)
	{
	  memcpy(dst + 3*(j+y)*(w+x) + 3*x, src + j*width +1, 3*width);
	}
      break;
    case 32:
      for(j=0; j<h; j++)
	{
	  memcpy(dst + 4*(j+y)*(w+x) + 4*x, src + j*width, width);
	}
      break;
    default:
      break;
    }
}

