/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *  skins_draw_titlebar.c
 *
 *  Functions for handling the titlebar.xpm
 *  @Author : Damien Chavarria (1999)
 *
 */

/* INCLUDES */

#include "skins_draw_titlebar.h"

/* FUNCTIONS */

/****************** draw_titlebar *********************
 * 						      *
 ******************************************************/

void draw_titlebar(gint state, GtkWidget *widget)
{
  gint dx, i;
  dx = xmps_config.window_size_x - 275;

  switch (state)
  {
    case ACTIVE :  
#ifdef HAVE_GDKPIXBUF
      gdk_pixbuf_render_to_drawable (titlebar_pixbuf,widget->window,
				     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				     2, 2,
				     5, 5,
				     45, 18,GDK_RGB_DITHER_NONE, 0, 0);
      for (i=0; i < dx/2; i++)
	gdk_pixbuf_render_to_drawable (titlebar_pixbuf,widget->window,
				       widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				       47, 2,
				       50+i, 5,
				       1, 18,GDK_RGB_DITHER_NONE, 0, 0);

      gdk_pixbuf_render_to_drawable (titlebar_pixbuf,widget->window,
				     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				     47, 2,
				     50+dx/2, 5,
				     175, 18,GDK_RGB_DITHER_NONE, 0, 0);

      for (i=0; i < dx - (dx/2,GDK_RGB_DITHER_NONE, 0, 0); i++)
	gdk_pixbuf_render_to_drawable (titlebar_pixbuf,widget->window,
				       widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				       222, 2,
				       225+dx/2+i, 5,
				       1, 18,GDK_RGB_DITHER_NONE, 0, 0);
      
      gdk_pixbuf_render_to_drawable (titlebar_pixbuf,widget->window,
				     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				     222, 2,
				     225+dx, 5,
				     45, 18,GDK_RGB_DITHER_NONE, 0, 0);
#else

      gdk_draw_pixmap(widget->window,
		      widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		      titlebar_pixmap,
		      2, 2,
		      5, 5,
		      45, 18);
      for (i=0; i < dx/2; i++)
	gdk_draw_pixmap(widget->window,
			widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
			titlebar_pixmap,
			47, 2,
			50+i, 5,
			1, 18);
      gdk_draw_pixmap(widget->window,
		      widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		      titlebar_pixmap,
		      47, 2,
		      50+dx/2, 5,
		      175, 18);
      for (i=0; i < dx - (dx/2); i++)
	gdk_draw_pixmap(widget->window,
                                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
			titlebar_pixmap,
                                  222, 2,
			225+dx/2+i, 5,
			1, 18);
      gdk_draw_pixmap(widget->window,
		      widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		      titlebar_pixmap,
		      222, 2,
		      225+dx, 5,
		      45, 18);
#endif
      break;
      
  case INACTIVE :  
#ifdef HAVE_GDKPIXBUF    
    gdk_pixbuf_render_to_drawable (titlebar_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   2, 22,
				   5, 5,
				   45, 18,GDK_RGB_DITHER_NONE, 0, 0);
    
    for (i=0; i < dx/2; i++)
      gdk_pixbuf_render_to_drawable (titlebar_pixbuf,widget->window,
				     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				     47, 22,
				     50+i, 5,
				     1, 18,GDK_RGB_DITHER_NONE, 0, 0);
    
    gdk_pixbuf_render_to_drawable (titlebar_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   47, 22,
				   50+dx/2, 5,
				   175, 18,GDK_RGB_DITHER_NONE, 0, 0);

    for (i=0; i < dx - (dx/2,GDK_RGB_DITHER_NONE, 0, 0); i++)
      gdk_pixbuf_render_to_drawable (titlebar_pixbuf,widget->window,
				     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				     222, 22,
				     225+dx/2+i, 5,
				     1, 18,GDK_RGB_DITHER_NONE, 0, 0);

    gdk_pixbuf_render_to_drawable (titlebar_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   222, 22,
				   225+dx, 5,
				   45, 18,GDK_RGB_DITHER_NONE, 0, 0);
#else

    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    titlebar_pixmap,
		    2, 22,
		    5, 5,
		    45, 18);
    for (i=0; i < dx/2; i++)
      gdk_draw_pixmap(widget->window,
		      widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		      titlebar_pixmap,
		      47, 22,
		      50+i, 5,
		      1, 18);
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    titlebar_pixmap,
		    47, 22,
		    50+dx/2, 5,
		    175, 18);
    for (i=0; i < dx - (dx/2); i++)
      gdk_draw_pixmap(widget->window,
		      widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		      titlebar_pixmap,
		      222, 22,
		      225+dx/2+i, 5,
		      1, 18);
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    titlebar_pixmap,
		    222, 22,
		    225+dx, 5,
		    45, 18);
#endif
		  break;
 }
}

