/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *  skins_draw_controls.h
 *
 *  Functions for handling the controls.xpm
 *  @Author : Damien Chavarria (1999)
 *
 */

#ifndef _XMPS_CONTROLS
#define _XMPS_CONTROLS

/* INCLUDES */

#include "xmps_graphics.h"
#include "skins_pixmaps.h"
#include "libxmps/libxmps.h"
#include "libxmpsutils/libxmpsutils.h"

/* FUNCTIONS */

void draw_full_screen_button(gint state, GtkWidget *widget);
/* draws the full screen button, state is either NORMAL or PUSHED */
void draw_loop_button(gint state, GtkWidget *widget);
/* draws the loop button, state is either NORMAL or PUSHED */
void draw_playlist_button(gint state, GtkWidget *widget);
/* draws the playlist button, state is either NORMAL, PUSHED, NORMAL_TOGGLED or PUSHED_TOGGLED */

void draw_progress_bar(xmps_progress_bar, GtkWidget *widget);
/* draws a given progress bar */
void draw_progression_bar(GtkWidget *widget);
/* specific for the progression bar because of resizing */

void draw_resize(GtkWidget *widget);
/* draw the resize control*/

#endif
