/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


/**
 *  playlist.h
 *
 *  Header file for the playlist.
 *  @Author : Damien Chavarria (1999)
 *
 */

#ifndef _SKINNED_PLAYLIST_H
#define _SKINNED_PLAYLIST_H 

/* CONSTANTS */

#define ALPHABETICALY         0
#define ALPHABETICALY_REVERSE 1
#define TIME                  2

/* INCLUDES */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <sys/stat.h>
#include <pthread.h>

#include "libxmps/libxmps.h"
#include "libxmpsutils/libxmpsutils.h"
#include <xmps_graphics.h>
#include <skins_draw_playlist.h>

#include <stdio.h>
#include <string.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

/* TYPES */

/* VARIABLES */

pthread_mutex_t playlist_mutex;

extern GtkWidget       *playlist_window;
extern GtkWidget       *playlist_drawing_area;
extern GtkWidget       *playlist_file_selection;

GtkItemFactory  *add_menu, *remove_menu, *sort_menu, *rand_menu;

/* FUNCTIONS */

/* Playlist window functions */

void initialize_playlist();
/* default values */
void playlist_window_create();
 /* creates the window and the drawing area but don't show it */
void playlist_window_show();
 /* shows the playlist */
void playlist_window_hide();
 /* hides the playlist */
void playlist_clear_items(GtkWidget *widget);
 /* do the contrary */

#endif
 





