/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *
 * flx_codec.h
 *
 * FLI/FLC Video Codec.
 * @Authors Chavarria Damien.
 *          Jasper Berlijn <jasper@il.fontys.nl>
 * 	    Copyright 1999-2000
 */

#ifndef _FLX_CODEC_H
#define _FLX_CODEC_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define ReadU16(tmp1, tmp2) (Uint16)*(tmp1) = ((Uint8)*(tmp2+1)<<8)+(Uint8)*(tmp2);
#define ReadU32(tmp1, tmp2) (Uint32)*(tmp1) = (((((((Uint8)*(tmp2+3)<<8)+((Uint8)*(tmp2+2)))<<8)+((Uint8)*(tmp2+1)))<<8)+(Uint8)*(tmp2));

/*
 * includes : local
 *
 */

#include "libxmps/libxmps.h"

/*
 * includes : system
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <SDL/SDL.h>

typedef struct {

  Uint8           *pMembuf;
  Uint32           membufSize;
  Uint8           *pFrame;
  Uint8           *pChunk;
  Uint16           FrameCount; 
  Uint32           HeaderSize;    
  Uint16           HeaderCheck;   
  Uint16           HeaderFrames;  
  Uint16           HeaderWidth;   
  Uint16           HeaderHeight;  
  Uint16           HeaderDepth;   
  Uint16           HeaderSpeed;   
  Uint32           FrameSize;     
  Uint16           FrameCheck;    
  Uint16           FrameChunks;   
  Uint32           ChunkSize;     
  Uint16           ChunkType;     
  xmps_rgb_color_t colors[256];
  int              screen_w;
  int              screen_h;
  int              screen_depth;

} flc_data_t;

unsigned int     flx_open      (xmps_video_decoder_plugin_t *video_decoder);
void*            flx_get       (xmps_video_decoder_plugin_t *video_decoder, unsigned int flag, void *data);
unsigned int     flx_set       (xmps_video_decoder_plugin_t *video_decoder, unsigned int flag, void *data); 
unsigned int     flx_decompress(xmps_video_decoder_plugin_t *video_decoder, void *in_buffer, void *out_buffer, unsigned int size);
unsigned int     flx_close     (xmps_video_decoder_plugin_t *video_decoder);

#endif






