/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *
 * wav_codec.h
 *
 * WAV Video Codec.
 * @Author Chavarria Damien.
 * 	   Copyright 1999-2000
 */

#ifndef _WAV_CODEC_H
#define _WAV_CODEC_H

/*********************************************************************
 *                             INCLUDES                              *
 *********************************************************************/

#include "libxmps/libxmps.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

/*********************************************************************
 *                            FUNCTIONS                              *
 *********************************************************************/


unsigned int wav_open      (xmps_audio_decoder_plugin_t *audio_decoder);
void*        wav_get       (xmps_audio_decoder_plugin_t *audio_decoder, unsigned int flag, void *data);
unsigned int wav_set       (xmps_audio_decoder_plugin_t *audio_decoder, unsigned int flag, void *data);
unsigned int wav_decompress(xmps_audio_decoder_plugin_t *audio_decoder, void *in_buffer, void *out_buffer, unsigned int size);
unsigned int wav_close     (xmps_audio_decoder_plugin_t *audio_decoder);

#endif


