/* histogram.c
 *
 * Time-stamp: <01 Sep 96 12:00:01 HST edo@eosys.com>
 *
 * Version 0.1
 */


/******************************************************************

Copyright (C) 1996 by Ed Orcutt Systems

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated documentation
files (the "Software"), to deal in the Software without
restriction, including without limitation the rights to use,
copy, modify, merge, publish, and/or distribute copies of the
Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

1. The above copyright notice and this permission notice shall
   be included in all copies or substantial portions of the
   Software.

2. Redistribution for profit requires the express, written
   permission of the author.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT.  IN NO EVENT SHALL ED ORCUTT SYSTEMS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

******************************************************************/

#include <stdio.h>
#include "qcam.h"
#include "qcamip.h"

/* Caveat: Assume histogram[] is large enough :-) */

void
qcip_histogram(struct qcam *q, scanbuf *scan, int *histogram)
{
  int i, j;
  int width, height;
  int maxpixval;

  /* actual image width & height after scaling */
  width = q->width / q->transfer_scale;
  height = q->height / q->transfer_scale;

  /* calculate maximum pixel value: 2**bpp */
  for (maxpixval = 1, i = q->bpp; i > 0; i--)
    maxpixval *= 2;

  /* initialize to zero */
  for (i = 0; i < maxpixval; i++)
    histogram[i] = 0;

  /* for each pixel value increment it's tally */
  for (i = width - 1; i >= 0; i--) {
    for (j = height - 1; j >= 0; j--) {
      histogram[scan[(j*width)+i]]++;
    }
  }
}

/*
 * Caveat: Assume image height >= 2**bpp :-)
 */

void
qcip_display_histogram(struct qcam *q, scanbuf *scan)
{
  int i, j;
  int histogram[64];  /* tally of pixel values */
  int maxpixval;      /* greatest pixel value */
  int maxhisval;      /* greatest histogram tally value */
  int hiswidth;       /* width of histogram */
  int hispixval;      /* color(?) of histogram bars */
  int width, height;

  /* actual image width & height after scaling */
  width = q->width / q->transfer_scale;
  height = q->height / q->transfer_scale;

  /* calculate maximum pixel value: 2**bpp */
  for (maxpixval = 1, i = q->bpp; i > 0; i--)
    maxpixval *= 2;

  /* use 1/5 of the image width to display the histogram */
  hiswidth = width / 5;

  /* color the histogram bars with medium value */
  hispixval = maxpixval / 2 + 1;

  qcip_histogram(q, scan, histogram);

  /* in order to scale the histogram we need to know the max value */
  for (maxhisval = 0, i = 0; i < maxpixval; i++) {
    if (histogram[i] > maxhisval)
      maxhisval = histogram[i];
  }

  /* overlay the histogram in the upper-left of the image*/
  for (j = 0; j < maxpixval; j++) {
    for (i = (histogram[j]*hiswidth/maxhisval)-1; i >=0; i--)
      scan[(j*width)+i] = hispixval;
    for (i = (histogram[j]*hiswidth/maxhisval); i <= hiswidth; i++)
      scan[(j*width)+i] = 0;
  }
  
  /* let's add a border to the histogram, make it more visible! */
  j = maxpixval * width;
  for (i = 0; i < hiswidth; i++)
    scan[j+i] = 0;
}
