#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "user_io.h"

GdkColor dark, yellow, white, red, green;

void
on_about1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *aboutdialog, *aboutlabel;
  GString *info;

  aboutdialog = create_dialog1();
  aboutlabel = lookup_widget(aboutdialog, "label1");
  info = g_string_new(_("xcall version "));
  g_string_append(info, VERSION);
  g_string_append(info, "\nJoop Stakenborg <pa4tu@amsat.org>\n\n");
  g_string_append(info, _("xcall is a quick hack made in glade\n\n"));
  g_string_append(info, _("This program is distributed under the\n"));
  g_string_append(info, "GNU General Public License\n");
  gtk_label_set_text(GTK_LABEL(aboutlabel), info->str);
  g_string_free(info, TRUE);
  gtk_widget_show(aboutdialog);
}


void
on_button1_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(gtk_widget_get_toplevel(GTK_WIDGET (button)));
}


void
on_entry1_activate                     (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GString *entry;
  GtkWidget *mainentry;
  extern GtkWidget *window1;
  extern gboolean connected;

  mainentry = lookup_widget(window1, "entry1");
  entry = g_string_new(gtk_editable_get_chars(GTK_EDITABLE(mainentry), 0, -1));
  gtk_entry_select_region(GTK_ENTRY(mainentry), 0, GTK_ENTRY(mainentry)->text_length);
  gtk_entry_set_text(GTK_ENTRY(mainentry),"");
  
  if (g_strncasecmp(entry->str, ":c", 2) == 0) {
    entry = g_string_erase(entry, 0, 2);
    if (!connected) connectto(entry);
  } else 
  if (g_strncasecmp(entry->str, ":d", 2) == 0) {
    entry = g_string_erase(entry, 0, 2);
    if (connected) disconn();
  } else
  if (connected) tx(entry);

  g_string_free(entry, TRUE);
}


void
on_window1_show                        (GtkWidget       *widget,
                                        gpointer         user_data)
{
  GString *message = NULL;
  GdkColormap *colormap;
  GtkWidget *maintext;
  extern GtkWidget *window1;
  extern gboolean connected;
  GtkStyle *maintextstyle;

  colormap = gdk_colormap_get_system();
  gdk_color_parse("white", &white);
  gdk_color_parse("grey20", &dark);
  gdk_color_parse("yellow", &yellow);
  gdk_color_parse("red", &red);
  gdk_color_parse("green", &green);
  maintext = lookup_widget(window1, "text1");
  maintextstyle = gtk_style_new();
  maintextstyle->base[GTK_STATE_NORMAL] = dark;
  gtk_widget_set_style(maintext, maintextstyle);
  
  message = g_string_new(_("xcall version "));
  g_string_append(message, VERSION);
  g_string_append(message, ", copyright (C) 2001, Joop Stakenborg <pa4tu@amsat.org>");
  g_string_append(message, _("\nType ':c [ax25 port] [callsign] v [digi]' to connect,"));
  g_string_append(message, _(" ':d' to disconnect\n"));
  write_text(message->str, STATUSMESSAGE);
  g_string_free(message, TRUE);
  
  connected = FALSE;
}
