/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
//---------------------------------------------------------------------------
#ifndef DIDADIT_H
#define DIDADIT_H
//---------------------------------------------------------------------------
#include <time.h>
#include <qwidget.h>
#include <qtimer.h>
#include <qstring.h>
#include "dialog.h"
#include "filetransfer.h"
//---------------------------------------------------------------------------
class Channel;
//---------------------------------------------------------------------------
// KISS-Konstanten
#define FEND '\xC0'             // FrameEND
#define FESC '\xDB'             // FrameESCape
#define TFEND '\xDC'            // Transponiertes FrameEND
#define TFESC '\xDD'            // Transponiertes FrameESCape
//---------------------------------------------------------------------------
#define RBLOCK_INFO 1
#define RBLOCK_START 2
#define RBLOCK_ERR 3
#define RBLOCK_DATA 4
#define RBLOCK_FIN 5
#define RBLOCK_REQ 6
#define RBLOCK_FINACK 7
#define RBLOCK_TYPEREJ 8
#define RBLOCK_ECHOREQ 9
#define RBLOCK_ECHOREP 10
#define RBLOCK_ABORT 11
//---------------------------------------------------------------------------
#define MAXBLOCKSIZE 8192
#define MAXROHBLOCKSIZE 2*MAXBLOCKSIZE+100
//---------------------------------------------------------------------------
#define DIDADIT_VERSION "0.9.1"
//---------------------------------------------------------------------------
typedef struct _s_rxliste
{
   struct _s_rxliste *next;
   unsigned long start;
   unsigned long ende;
} s_rxliste;
//---------------------------------------------------------------------------
typedef struct _s_reqliste
{
   struct _s_reqliste *next;
   unsigned long offset;
   unsigned long len;
} s_reqliste;
//---------------------------------------------------------------------------
typedef struct
{
   bool error;
   unsigned short id;         // Block-ID
   int len;                   // Laenge der Daten
   char *data;                // Daten
   unsigned short crc;        // 16-Bit CRC
   unsigned char md5[16];     // 16 Bytes MD5-Hash
} t_RBlock;
//---------------------------------------------------------------------------
#define WHEN_LATER 1
#define WHEN_NOW 2
//---------------------------------------------------------------------------
/*
 * class DIDADIT
 *
 * Funktionen und variablen, die man zum Senden und zum Empfangen
 * benoetigt.
 */
class DIDADIT : public QObject
{
   Q_OBJECT;
public:
   DIDADIT( QWidget *_chan );
   ~DIDADIT();

   int proceed(char *data, int len);

   void SendBytes(char *, int);
	void SendBytesNow( char *, int );
   void sendMessage(char *);
   void abortIt();

   int getStatus();

public slots:
   void sendBlock();

private:
   void SendBlock (const char *_data, int datalen, unsigned short blockid, int when=WHEN_LATER);
   void DecodeBlock(char *data, int len, t_RBlock *block);

   int checkBlock( const char *data, int & len );
//   void sendInfoBlock();
   void sendStartBlock();
   void getHexMD5( unsigned char *md5, char *hexmd5 );
   void md5HexToBin( char *hex, unsigned char *bin );
	bool checkMD5();
	void showError( const char *text );
	void sendReqBlock( char *data, int & len, unsigned long start, unsigned long stop );

   bool readInfoBlock();
   bool readDataBlock();
   bool readFinBlock();

   // Routinen, um die Verwaltungs- und Datenfiles zu verwalten
	bool createDataFiles();
   void writeRFile();
   void deleteRFile();
	unsigned long lookForRFile();

   long addRXListe( unsigned long start, unsigned long ende );
   void showEndText();
   bool allReceived();

   bool waitForOkAbort;
   QWidget *chan;
   QString filename;
   long size;
   time_t modtime;
   time_t starttime;
   int blocksize;
   unsigned char md5[16];
   int status;
   bool firstblock;
   unsigned long offset;

   int lastBlockSent;
   QTimer *timer;

   int reqCount;
   long reqLength;

   int fd_data;
   int fd_r;

   char *rxData;        // Hier wird gerade ein Block empfangen
   int rxDataLen;
   t_RBlock block;
   bool fileSent;			// true, wenn das ganze File ausgesendet wurde
   							// und nur noch auf REQ-Bloecke gewartet wird
	bool sendBlocksize;	// Wenn die Blocksize geaendert wurde, wird diese
   							// Variable auf TRUE gesetzt.

   s_rxliste *rxlistroot;

   TransferInfo *transInfo;

   char compfilename[500];
	int gzipfilesize;

   int wascomp;				// 0 = keine kompression, 1 = //COMP, 2 = #HUF#
};
//---------------------------------------------------------------------------
class DIDADIT_TX : public FileTransfer
{
	Q_OBJECT;

public:
	DIDADIT_TX( Channel *chan, const QString & filename, int blocksize );
   ~DIDADIT_TX();

	void getFileData();
   void startSending();
   int sentReady();
	void abortTransmission();

public slots:
	void slotReceivedString( const char *data, int len );

signals:

private:
	void sendText( const char *data );
	void SendBlock( const char *_data, int datalen, unsigned short blockid );
	void DecodeBlock(char *data, int len, t_RBlock *block);
	int checkBlock( const char *data, int & len );
	void sendInfoBlock();
	void readStartBlock();
	void readFinAck();
	void showEndText();
	void getHexMD5( unsigned char *md5, char *hexmd5 );
	void md5HexToBin( char *hex, unsigned char *bin );
	bool checkMD5();
	void showError( const char *text );
	bool readReqBlock();

	int fd;
   Channel *chan;
   time_t starttime;
   time_t modtime;
   int blocksize;

   long rxbytes, txbytes;
   long size;
   s_reqliste *reqlistroot;
   int fd_data;
   int reqCount;
   long reqLength;
   int lastBlockSent;
   QTimer *timer;
   unsigned long offset;
   unsigned char md5[16];
   int status;
   char *rxData;        // Hier wird gerade ein Block empfangen
   int rxDataLen;
	t_RBlock block;
   bool waitForOkAbort;
   bool fileSent;
   int txready;
};
//---------------------------------------------------------------------------
#endif /* DIDADIT_H */
//---------------------------------------------------------------------------

