/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2001 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
//---------------------------------------------------------------------------
#ifndef CHANNEL_H
#define CHANNEL_H
//---------------------------------------------------------------------------
#include "bin.h"

#include <qwidget.h>
#include <qobject.h>
#include <qdialog.h>
#include <qsocketnotifier.h>
#include <qevent.h>
#include <qpopupmenu.h>
#include <qaccel.h>
#include <qlist.h>
#include <qsplitter.h>
#include <qtoolbutton.h>
#include <qlayout.h>

#include <ktoolbar.h>
#include <ktmainwindow.h>

#include "output.h"
#include "vorschreib.h"
#include "remote.h"
#include "flags.h"
#include "userinfo.h"
#include "passwords.h"
#include "boxcheck.h"
#include "sendqueue.h"

#include <time.h>
//---------------------------------------------------------------------------
class FileTransfer;
class YAPP;
class AHUF;
class CheckGPG;
class DIDADIT;
class TransferInfo;
class InfoBar;
class ConnectPathCheck;
//---------------------------------------------------------------------------
class Channel : public KTMainWindow
{
   Q_OBJECT;
public:
   // Konstruktor fuer ankommende Connects von aussen
   Channel( char *port, char *mycall, char *call, char *digis, int fd, bool connected );
   ~Channel();

   void makeNewConnect( char *port, char *mycall, char *call, char *digis, int fd );

   // Funktionen, um private Variablen zurueckzugeben
   const QString & getCall();
   const QString & getMycall();
   const QString & getPort();
   void discStn();
   void discStnAuto();
   void closeQSOWindow();
   void reallyDisconnect();
   bool validCallsign(char */*call*/);
   int getFlags();
   int getTxfd();
   QWidget * getVorschreibPtr();
   QWidget *centralWidget;
   QVBoxLayout *centralVBox;

   // Funktionen, ueber die das Kernel-AX.25-Interface die Verbindungs-
   // Daten setzt
   void setUnack(int value);
   void setSQueue(int value);
   void setTries(int value);
   void setStatus(int value);

   void sendStringComp(int len, const char *data, bool show, int comp);
   void sendString(int len, const char *data, bool show);
   void sendString( const char *data );
   void sendString( const QString & data, bool show=true );
	void sendStringNow( int len, const char *data, bool show );
   void sendMacroString( const QString & data, bool show=true );
	void sendMacrofile( const QString & filename );
	void macroLine( QString & makroString );
   void sendTextFile( char *filename, bool show);
   void updateFont();
	void updateWindowPos();
	void updateToolbar( KConfig *kconfig, const QString & configGroup );
	void updateKontextMenu();
	void getCookie( QString & cookie );
   void updateBoxcheckCfg();
   void enableBoxcheckMenu();
   void statusConnectGot();
   bool isConnected();
	void updateBCSize();
   void setReceiving( bool enable );

   void withTransInfo( TransferInfo *win );
   void withoutTransInfo();

   void outText( const char *text, int len, int color );

   UserInfo *userinfo;
   InfoBar *infobar;
   SendQueue *sendQueue;

   int flags;

private:
   QSplitter *panner;
   QPopupMenu *kontextmenu, *kontextvorschr;
   int mnu_textfile, mnu_sendabin, mnu_didadit, mnu_yapp, mnu_boxcheck;
   int mnu_sendabin_btn, mnu_didadit_btn, mnu_yapp_btn, mnu_gpg_1;
   KToolBar *toolbar;
	int toolb_gpg, toolb_boxcheck;
   void setupToolbar();

   myVorschreib *vorschreib;
   OutputWidget *output;

   BoxCheckWin *boxcheck;
   RemoteCmds *remote;
   auto7plus *auto7;
   BinRX *binrx;
   DIDADIT *didadit;
   YAPP *yapp;
   AHUF *ahuf;
   CheckGPG *gpg;
   Passwords *password;
   int filerx_fd;
   bool closeWinDisc;
   TransferInfo *transferDlg;
   ConnectPathCheck *connectPath;

   QList<QAccel> *accels;


   // Daten ueber die Verbindung
   QString data_firstcall;
   QString data_call;
   QString data_mycall;
   time_t data_logintime;
   QString data_port;
   QString data_digis;
   long bytesRX;
   long bytesTX;
   int maxframe;

   // Kommunikation
   QSocketNotifier *sockrx;
   int txfd;
   void sendFrame( char *str, int len, int comp );
	int getMaxframe( const char *port );

   // Sendqueue
   bool send_error;

   // Kanal-Parameter
   int framesize;
   int old_status;
   int squeue;

   int typeCheckLine;

   char *save_text;
   int save_text_len;
   int save_text_showed;
   int len_already_showed;

   void showConnectMessage( const QString & port, const QString & call, const QString & digis);
   void showDisconnectMessage( const QString & port, const QString & call, const QString & digis );
	void showConnFailedMessage( const QString & port, const QString & call, int reason );
   void setCaption();
   void work_with_frame( char *neu_str, int neu_str_len );
   void sendCText();
   void send_a_frame();
   void logBookEntry();
   void checkForHUF(char *data, int len);
   void insertBINChatLine( char *text, bool out );
   void updateColors();

	void sendTerminalSID();
	void checkTerminalSID( const char *str );

	void checkConnectedTo( const QString & rxcall );
	void checkReconnectedTo( const QString & rxcall );
   void checkReconnectedTo(char *call);
   void checkSwType(char *line);
   void checkSIDFlags( char *line );

   void checkPi1chlConnect(char *data);
	void checkTNNConnect( const QString & data);
   void checkTNNReconnect(char *data);

   int pollStatus();

public slots:
   void rxFrame(int socket);
   void returnPressedGot();
   void settings();
   void showKontextMenu();
   void showKontextVorschrMenu();
   void slotSendQuoted();
   void slotSendUnquoted();
   void slotInsertQuoted();
   void slotSaveText();
   void slotSendPW();
   void slotAway();
   void activateCheckWin();
   void slotHufComp();
   void slotYAPP();
   void slotBtnFileSend();
	void slotWhatsThis();
	void slotShowSendQueue();
	void slotSendGPG();
	void slotBtnKeySend();

	void slotToolbarMoved();

   void newConnect();
   void discStation();

	void slotSetLinemode( bool lm );
   void showStatus( FileTransfer *tr, const QString & shortname, long size, long startvalue, int type );
   void unshowStatus();
   void statusRxBytes( long bytes );

   void slotFilesendAutoBIN();
   void slotFilesendDIDADIT();
   void slotFilesendTextfile();

signals:
	void receivedString( const char *, int );
   void sendFileTXData();

protected:
   void closeEvent( QCloseEvent *e );
   void dragEnterEvent( QDragEnterEvent *e );
   void dropEvent( QDropEvent *e );
};
//---------------------------------------------------------------------------
#endif /* CHANNEL_H */
//---------------------------------------------------------------------------

