set -e

. vars.sh

ZIPSPEAK_ROOT=`pwd`
ZIPSPEAK_BUILD_ROOT=${ZIPSPEAK_ROOT}/build
ZIPSPEAK_DOSFS_IMAGE=${ZIPSPEAK_BUILD_ROOT}/dosfs.img
ZIPSPEAK_DOSFS_ROOT=${ZIPSPEAK_BUILD_ROOT}/dosfs
ZIPSPEAK_STAGE_ROOT=${ZIPSPEAK_DOSFS_ROOT}/linux
ZIPSPEAK_STD_DIST_DIR=${ZIPSPEAK_ROOT}/dist

if [ "${ZIPSPEAK_CUSTOM}" = "" ]
then
  ZIPSPEAK_DIST_DIR=${ZIPSPEAK_STD_DIST_DIR}
else
  ZIPSPEAK_DIST_DIR=${ZIPSPEAK_ROOT}/custom-${ZIPSPEAK_CUSTOM}
fi

ZIPSPEAK_SYNTH_FILE=${ZIPSPEAK_ROOT}/synths
ZIPSPEAK_PACKAGE_DIR=${ZIPSPEAK_ROOT}/packages
ZIPSPEAK_SOURCE_DIR=${ZIPSPEAK_ROOT}/src
SPEAKUP_ROOT=${ZIPSPEAK_BUILD_ROOT}/speakup-${SPEAKUP_VERSION}
KERNEL_MAJOR=`echo ${KERNEL_VERSION} | cut -d. -f1`
KERNEL_MINOR=`echo ${KERNEL_VERSION} | cut -d. -f2`
KERNEL_PATCHLEVEL=`echo ${KERNEL_VERSION} | cut -d. -f3`
SLACK_KERNEL_VERSION=${KERNEL_MAJOR}${KERNEL_MINOR}${KERNEL_PATCHLEVEL}
KERNEL_ROOT=${ZIPSPEAK_BUILD_ROOT}/linux-${KERNEL_VERSION}
