/* symbols_apolo.h - header file for speakups Apolo driver. */
#define VERSION_APOLO 01
#define NUM_STATIC_APOLO 7
#define NUM_XTEND_APOLO 1	/* ZILCH counts as one entry, so */
#define NUM_ALIAS_APOLO 1	/* things line up ok... */

/* note the trailing comma */
#define DEFAULT_STATIC_APOLO \
	"\x18", "@F8", "@W5", "@V1", \
	"@AA", "cap ", "",

	  /* so no trailing comma... */
#define DEFAULT_XTEND_APOLO \
"@=1,",

/* required settings and functionality */
#define STATIC_STR_APOLO \
	{ "#flush", "\x18", "_", (BUILDER | HARD_DIRECT | NO_USER), { -1 } },\
	{ "pitch", "8", "@F_", (NUMERIC | HARD_DIRECT), { "0123456789ABCDEF\xff" } }, \
	{ "rate", "5", "@W_", (NUMERIC | HARD_DIRECT | USE_RANGE), "1,9" }, \
	{ "voice", "1", "@V_", (NUMERIC | HARD_DIRECT | USE_RANGE), "1,6" }, \
	{ "volume", "A", "@A_", (NUMERIC | HARD_DIRECT), { "0123456789ABCDEF\xff" } }, \
	{ "caps_start", "cap ", "_", 0, { -1 } }, \
	{ "caps_stop", "", "_", 0, { -1 } }

/* additional settings and functionality */
#define XTEND_STR_APOLO \
	{ "language", "1", "@=_,", (NUMERIC | HARD_DIRECT | USE_RANGE), "1,4" }

#define ALIAS_STR_APOLO ZILCH

