/* ============================================================================
 *
 * File:	o_FileListbox.c
 * Project:	TkDesk
 * Started:	14.02.95
 * Changed:	14.02.95
 *
 * Description:	Contains optimizations of tcl code from the file
 *              ../tcldesk/FileListbox.tcl. These are implemented as
 *              tcl commands.
 *
 * Copyright (C) 1996  Christian Bolik
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * See the file "COPYING" in the base directory of this distribution
 * for more.
 *
 * ----------------------------------------------------------------------------
 *
 * Functions:
 *
 *
 * ========================================================================= */

#include <string.h>
#include "libdesk.h"


/* the ignore list */
static int  iargc;
static char **iargv = NULL;

/* the tag list */
static int  targc;
static char **targv = NULL;

/* the pattern list */
static int  pargc;
static char **pargv = NULL;


/* ============================================================================
 * Name   : dsk_init_ftags_Cmd (tcl: dskC_init_ftags)
 * In     : ... (opt: argv[1]: dsk_FileListbox::taglist,
 *                    argv[2]: dsk_FileListbox::patlist,
 *                    argv[3]: dsk_FileListbox::ignorelist)
 * Out    : ...
 * Desc   : Initializes internal file tags structures.
 * ------------------------------------------------------------------------- */
int dsk_init_ftags_Cmd (clientData, interp, argc, argv)
     ClientData clientData;
     Tcl_Interp *interp;
     int argc;
     char *argv[];
{
    char *taglist, *ilist, *plist;

    /* get and split the taglist */
    if (targv != NULL)
	free ((char *)targv);
    if (argc > 1) {
	if (Tcl_SplitList (interp, argv[1], &targc, &targv) == TCL_ERROR)
	    return TCL_ERROR;
    } else {
	tcl_getvar ("taglist", taglist);
	if (Tcl_SplitList (interp, taglist, &targc, &targv) == TCL_ERROR)
	    return TCL_ERROR;
    }

    /* get and split tag masks */
    if (pargv != NULL)
	free ((char *)pargv);
    if (argc > 2) {
	if (Tcl_SplitList (interp, argv[2], &pargc, &pargv) == TCL_ERROR)
	    return TCL_ERROR;
    } else {
	tcl_getvar ("patlist", plist);
	if (Tcl_SplitList (interp, plist, &pargc, &pargv) == TCL_ERROR)
	    return TCL_ERROR;
    }
    
    /* get and split ignore masks */
    if (iargv != NULL)
	free ((char *)iargv);
    if (argc > 3) {
	if (Tcl_SplitList (interp, argv[3], &iargc, &iargv) == TCL_ERROR)
	    return TCL_ERROR;
    } else {
	tcl_getvar ("ignorelist", ilist);
	if (Tcl_SplitList (interp, ilist, &iargc, &iargv) == TCL_ERROR)
	    return TCL_ERROR;
    }
    
    return TCL_OK;
} /* dsk_init_ftags_Cmd */



/* ============================================================================
 * Name   : dsk_ppflist_Cmd (tcl: dskC_ppflist)
 * In     : ...
 * Out    : ...
 * Desc   : Postprocesses the file list read by dsk_ls. Does such things as
 *          tagging and file masking.
 * Side-FX: none
 * ------------------------------------------------------------------------- */

int dsk_ppflist_Cmd (clientData, interp, argc, argv)
     ClientData clientData;
     Tcl_Interp *interp;
     int argc;
     char *argv[];
{
    int i = 0, fargc, j, k, typechar, largc = 0,
	mtags = 0, mtargc, ntd, l, add_images, notmatch, notmatch_set = 0,
        showall, mask_matches_all;
    char **fargv, *flist, fnametc[256], fname[256], cmd[256],
	*mask, maskbuf[64], buf[256], *this,
	*list, **mtargv, *bufp, bigbuf[1024], typec = '\0',
	escbuf[1024];
    Tcl_DString dbigcmd;
    
    tcl_getvar ("this", this);

    tcl_getvar ("mask", mask);
    /*sprintf (maskbuf, "%s?", mask);*/
    strcpy (maskbuf, mask);
    if (strcmp (maskbuf, "*") == 0)
       mask_matches_all = 1;
    else
       mask_matches_all = 0;
    ot_getboolean ("typechar", NULL, &typechar);
    ot_getboolean ("notrivialdirs", NULL, &ntd);
    ot_getboolean ("add_icons", NULL, &add_images);
    ot_getboolean ("showall", NULL, &showall);
    
    /* flist has been read by dsk_ls */
    tcl_getvar ("flist", flist);
    if (Tcl_SplitList (interp, flist, &fargc, &fargv) == TCL_ERROR)
      return TCL_ERROR;

#ifdef LISTTEXT
    sprintf (buf, "%s.dlb.text delete 1.0 end", this);
    tcl_invoke (buf);
    Tcl_DStringInit (&dbigcmd);
    Tcl_DStringAppend (&dbigcmd, this, -1);
    Tcl_DStringAppend (&dbigcmd, ".dlb.text insert end {", -1);
#endif
    
    /*
     *  Loop through the file list. Skip files that don't match $mask.
     *  Append the index of each file to the tag list it matches.
     */
    for (j = 0; j < fargc; j++) {
	
	/* Split the file entry ($flist may be a long listing) */
	/*if (Tcl_SplitList (interp, fargv[j], &feargc, &feargv) == TCL_ERROR)
	  return TCL_ERROR;*/

	/* fnametc points to the filename with trailing type character */
	/*fnametc = feargv[feargc - 1];*/
	for (l = 0; fargv[j][l] && fargv[j][l] != '\\'; l++) {
	    fnametc[l] = fargv[j][l];
	    typec = fnametc[l];
	}
	fnametc[l] = 0;

	/* remove type character from long file string */
	if (typec == '_' || !typechar)
	    fargv[j][l-1] = ' ';

	/* strip the type character from the filename */
	strcpy (fname, fnametc);
	fname[strlen(fname)-1] = '\0';
	
	if (typec != '/' && typec != '-') {
	   /* skip the file entry if it doesn't match $mask
	      and is not a directory name */
	   if (!mask_matches_all)
	      if (!Tcl_StringMatch (fname, maskbuf))
		 continue;

	   /* check ignore list to see if this file is to be ignored */
	   if (!showall && iargc > 0) {
	      int toign = 0;
	      
	      for (k = 0; k < iargc; k++) {
		 if (Tcl_StringMatch (fname, iargv[k])) {
		    toign = 1;
		    break;
		 }
	      }
	      if (toign)
		 continue;
	   }
	}

	/* loop through $taglist until a matching tag is found */
	notmatch = 1;
	for (k = 0; k < targc; k++) {
#ifdef foo
	    strcpy (buf, targv[k]);
	    strcat (buf, ",match");
	    tcl_getvar2 ("tags", buf, tagmatch);
#endif

	    /* if the filename matches this tag append its index */
	    if (Tcl_StringMatch (fnametc, pargv[k])) {
		strcpy (buf, itoa(i));
		if (!(Tcl_SetVar2 (interp, "mt", targv[k], buf,
		     TCL_LIST_ELEMENT | TCL_APPEND_VALUE | TCL_LEAVE_ERR_MSG)))
		  return TCL_ERROR;
		mtags = 1;
		notmatch = 0;
		break;
	    }
	}
	/* add_images: need also line-nr.s of "normal" files */
	if (notmatch && add_images) {
	    notmatch_set = 1;
	    strcpy (buf, itoa(i));
	    if (!(Tcl_SetVar (interp, "mt_notmatch", buf,
		    TCL_LIST_ELEMENT | TCL_APPEND_VALUE | TCL_LEAVE_ERR_MSG)))
		return TCL_ERROR;
	}

	/* append the file entry to the file list */
	unescape_chars (fargv[j], escbuf);

#ifdef LISTTEXT
	Tcl_DStringAppend (&dbigcmd, escbuf, -1);
	Tcl_DStringAppend (&dbigcmd, "\n", 1);
#else
	if (!(Tcl_SetVar (interp, "list", escbuf,
		   TCL_LIST_ELEMENT | TCL_APPEND_VALUE | TCL_LEAVE_ERR_MSG)))
	    return TCL_ERROR;
#endif

	/*free (feargv);*/
	largc++;
	i++;
    }

    /* set the label of the menu button of this FileListbox */
    strcpy (bigbuf, "$this.mb config -state normal -text \"[$this _mb_label]\"");
    if (Tcl_Eval (interp, bigbuf) == TCL_ERROR)
      return TCL_ERROR;

    /* repack the menu button (it may not be mapped) */
    sprintf (cmd, "pack %s.mb -in %s.fMb -before %s.lFiles -fill x -side left -expand yes", this, this, this);
    tcl_invoke (cmd);

    if (!ntd && !strcmp(mask, "*"))
	largc -= 2;

    /* fill the list box with the filelist */
#ifndef LISTTEXT
    tcl_getvar ("list", list);
    Tcl_DStringInit (&dbigcmd);
    Tcl_DStringAppend (&dbigcmd, this, -1);
    Tcl_DStringAppend (&dbigcmd, ".dlb config -list {", -1);
    Tcl_DStringAppend (&dbigcmd, list, -1);
#endif
    Tcl_DStringAppend (&dbigcmd, "}", -1);
    /*tcl_invoke (dbigcmd.string);*/
    if (Tcl_Eval (interp, dbigcmd.string) == TCL_ERROR) {
	return TCL_ERROR;
    }
    Tcl_DStringFree (&dbigcmd);

    if (largc == 1) {
	sprintf (cmd, "%s.lFiles config -text \" 1 Item\"", this);
	tcl_invoke (cmd);
    } else {
	sprintf (cmd, "%s.lFiles config -text \" %d Items\"", this, largc);
	tcl_invoke (cmd);
    }

    /* now the tagging: */

    if (mtags) {
	tcl_invoke ("array names mt");
	strcpy (buf, interp->result);
	if (Tcl_SplitList (interp, buf, &mtargc, &mtargv) == TCL_ERROR)
	  return TCL_ERROR;

	Tcl_DStringInit (&dbigcmd);
	for (k = 0; k < mtargc; k++) {
	    tcl_getvar2 ("mt", mtargv[k], bufp);
	    Tcl_DStringAppend (&dbigcmd, this, -1);
	    Tcl_DStringAppend (&dbigcmd, ".dlb tag add ", -1);
	    Tcl_DStringAppend (&dbigcmd, mtargv[k], -1);
	    Tcl_DStringAppend (&dbigcmd, " {", -1);
	    Tcl_DStringAppend (&dbigcmd, bufp, -1);
	    Tcl_DStringAppend (&dbigcmd, "} ; ", -1);	    

	    if (add_images) {
		Tcl_DStringAppend (&dbigcmd, this, -1);
		Tcl_DStringAppend (&dbigcmd, " imginsert ", -1);
		Tcl_DStringAppend (&dbigcmd, mtargv[k], -1);
		Tcl_DStringAppend (&dbigcmd, " {", -1);
		Tcl_DStringAppend (&dbigcmd, bufp, -1);
		Tcl_DStringAppend (&dbigcmd, "} ; ", -1);	    
	    }
	}
	Tcl_Eval (interp, dbigcmd.string);
	Tcl_DStringFree (&dbigcmd);

	free (mtargv);
    }
    
    if (add_images && notmatch_set) {
	tcl_getvar ("mt_notmatch", bufp);
	Tcl_DStringInit (&dbigcmd);
	Tcl_DStringAppend (&dbigcmd, this, -1);
	Tcl_DStringAppend (&dbigcmd, " imginsert {} {", -1);
	Tcl_DStringAppend (&dbigcmd, bufp, -1);
	Tcl_DStringAppend (&dbigcmd, "}", -1);	    
	tcl_invoke (dbigcmd.string);
	Tcl_DStringFree (&dbigcmd);
    }
	
    free (fargv);
    /*free (targv);*/

    Tcl_ResetResult (interp);
    return TCL_OK;
} /* dsk_ppflist */

/* ============================================================================
 * Name   : dsk_ls_and_tag_Cmd (tcl: dskC_ls_and_tag)
 * In     : argv[1]: directory to read and tag
 * Out    : ...
 * Desc   : Reads file list by calling functions from dsk_ls.c, plus does
 *          additional processing like tagging and file masking.
 * Side-FX: none
 * ------------------------------------------------------------------------- */

int dsk_ls_and_tag_Cmd (clientData, interp, argc, argv)
     ClientData clientData;
     Tcl_Interp *interp;
     int argc;
     char *argv[];
{
    int i = 0, fargc, k, typechar, largc = 0,
	mtags = 0, mtargc, ntd, add_images, notmatch, notmatch_set = 0,
        showall, mask_matches_all, lsargc, maskc = 0, invert_mask;
    char fnametc[256], **maskv, *mask, maskbuf[64], buf[256], *this, **lsargv,
	**mtargv, *bufp, filebuf[1024], *lscmd, escbuf[1024], annobuf[1024];
    Tcl_DString dbigcmd;

    if (argc != 2) {
	strcpy (interp->result, "usage: dskC_ls_and_tag path");
	return TCL_ERROR;
    }

    /*
     * get values of required class variables
     */
    tcl_getvar ("this", this);
    ot_getboolean ("invert_mask", NULL, &invert_mask);
    tcl_getvar ("mask", mask);
    if (strcmp (mask, "*") == 0 && !invert_mask)
       mask_matches_all = 1;
    else {
       mask_matches_all = 0;
       if (Tcl_SplitList (interp, mask, &maskc, &maskv) == TCL_ERROR)
	   return TCL_ERROR;
       /*printf ("%s: %d elements\n", mask, maskc);*/
    }
    ot_getboolean ("typechar", NULL, &typechar);
    ot_getboolean ("notrivialdirs", NULL, &ntd);
    ot_getboolean ("add_icons", NULL, &add_images);
    ot_getboolean ("showall", NULL, &showall);

    /* intialize dsk_ls */
    tcl_getvar ("ls_cmd", lscmd);
    if (Tcl_SplitList (interp, lscmd, &lsargc, &lsargv) == TCL_ERROR)
	return TCL_ERROR;
    dsk_ls_init_and_parse_options (lsargc, lsargv, argv[1]);

    /* now read and sort the file list */
    fargc = dsk_ls_read_and_sort (iargc, (showall ? NULL : iargv),
				  maskc, (mask_matches_all ? NULL : maskv),
				  invert_mask);
    
    /* prepare for filling the list box with the filelist */
    Tcl_DStringInit (&dbigcmd);
    Tcl_DStringAppend (&dbigcmd, this, -1);
    Tcl_DStringAppend (&dbigcmd, ".dlb config -list {", -1);
    
    /*
     *  Loop through the file list.
     *  Append the index of each file to the tag list it matches.
     */
    i = 0;
    strcpy (annobuf, argv[1]);
    while (dsk_ls_next_file (filebuf, fnametc)) {
	
	/* loop through $taglist until a matching tag is found */
	notmatch = 1;
	strcpy (buf, itoa(i));
	for (k = 0; k < targc; k++) {
	    /* if the filename matches this tag append its index */
	    if (Tcl_StringMatch (fnametc, pargv[k])) {
		if (!(Tcl_SetVar2 (interp, "mt", targv[k], buf,
		     TCL_LIST_ELEMENT | TCL_APPEND_VALUE | TCL_LEAVE_ERR_MSG)))
		  return TCL_ERROR;
		mtags = 1;
		notmatch = 0;
		break;
	    }
	}
	/* add_images: need also line-nr.s of "normal" files */
	if (notmatch && add_images) {
	    notmatch_set = 1;
	    if (!(Tcl_SetVar (interp, "mt_notmatch", buf,
		    TCL_LIST_ELEMENT | TCL_APPEND_VALUE | TCL_LEAVE_ERR_MSG)))
		return TCL_ERROR;
	}

	/* check whether there's an annotation for this file */
	strcpy (annobuf+strlen(argv[1]), fnametc);
	annobuf[strlen(annobuf) - 1] = '\0';
	if (Tcl_GetVar2 (interp, "tkdesk_anno", annobuf, TCL_GLOBAL_ONLY)
	    != NULL)
	{
	    if (!(Tcl_SetVar2 (interp, "mt", "annotag", buf,
		    TCL_LIST_ELEMENT | TCL_APPEND_VALUE | TCL_LEAVE_ERR_MSG)))
		return TCL_ERROR;
	    mtags = 1;
	}

	/* append the file entry to the file list */
	unescape_chars (filebuf, escbuf);
	Tcl_DStringAppendElement (&dbigcmd, escbuf);

	i++;
    }

    Tcl_DStringAppend (&dbigcmd, "} ; ", -1);
    
    /* set the label of the menu button of this FileListbox */
    Tcl_DStringAppend (&dbigcmd, this, -1);
    Tcl_DStringAppend (&dbigcmd, ".mb config -state normal -text \"[", -1);
    Tcl_DStringAppend (&dbigcmd, this, -1);
    Tcl_DStringAppend (&dbigcmd, " _mb_label]\" ; ", -1);

    /* repack the menu button (it may not be mapped) */
    Tcl_DStringAppend (&dbigcmd, "pack ", -1);
    Tcl_DStringAppend (&dbigcmd, this, -1);
    Tcl_DStringAppend (&dbigcmd, ".mb -in ", -1);
    Tcl_DStringAppend (&dbigcmd, this, -1);
    Tcl_DStringAppend (&dbigcmd, ".fMb -before ", -1);
    Tcl_DStringAppend (&dbigcmd, this, -1);
    Tcl_DStringAppend (&dbigcmd, ".lFiles -fill x -side left -expand yes ; ", -1);
    /* update the listbox label */
    largc = (!ntd && mask_matches_all) ? fargc - 2 : fargc;
    if (largc == 1) {
	Tcl_DStringAppend (&dbigcmd, this, -1);
	Tcl_DStringAppend (&dbigcmd, ".lFiles config -text \" 1 Item\"", -1);
    } else {
	Tcl_DStringAppend (&dbigcmd, this, -1);
	Tcl_DStringAppend (&dbigcmd, ".lFiles config -text \" ", -1);
	Tcl_DStringAppend (&dbigcmd, itoa(largc), -1);
	Tcl_DStringAppend (&dbigcmd, " Items\"", -1);
    }

    if (Tcl_Eval (interp, dbigcmd.string) == TCL_ERROR) {
	return TCL_ERROR;
    }
    Tcl_DStringFree (&dbigcmd);

    /* free memory allocated by dsk_ls */
    dsk_ls_cleanup();

    /*
     * And now the tagging:
     */
    if (mtags) {
	tcl_invoke ("array names mt");
	strcpy (buf, interp->result);
	if (Tcl_SplitList (interp, buf, &mtargc, &mtargv) == TCL_ERROR)
	  return TCL_ERROR;

	Tcl_DStringInit (&dbigcmd);
	for (k = 0; k < mtargc; k++) {
	    tcl_getvar2 ("mt", mtargv[k], bufp);
	    Tcl_DStringAppend (&dbigcmd, this, -1);
	    Tcl_DStringAppend (&dbigcmd, ".dlb tag add ", -1);
	    Tcl_DStringAppend (&dbigcmd, mtargv[k], -1);
	    Tcl_DStringAppend (&dbigcmd, " {", -1);
	    Tcl_DStringAppend (&dbigcmd, bufp, -1);
	    Tcl_DStringAppend (&dbigcmd, "} ; ", -1);	    

	    if (mtargv[k][0] == 'a')
		if (strcmp (mtargv[k], "annotag") == 0)
		    continue;
	    
	    if (add_images) {
		Tcl_DStringAppend (&dbigcmd, this, -1);
		Tcl_DStringAppend (&dbigcmd, " imginsert ", -1);
		Tcl_DStringAppend (&dbigcmd, mtargv[k], -1);
		Tcl_DStringAppend (&dbigcmd, " {", -1);
		Tcl_DStringAppend (&dbigcmd, bufp, -1);
		Tcl_DStringAppend (&dbigcmd, "} ; ", -1);	    
	    }
	}
	Tcl_Eval (interp, dbigcmd.string);
	Tcl_DStringFree (&dbigcmd);

	free (mtargv);
    }
    
    if (add_images && notmatch_set) {
	tcl_getvar ("mt_notmatch", bufp);
	Tcl_DStringInit (&dbigcmd);
	Tcl_DStringAppend (&dbigcmd, this, -1);
	Tcl_DStringAppend (&dbigcmd, " imginsert {} {", -1);
	Tcl_DStringAppend (&dbigcmd, bufp, -1);
	Tcl_DStringAppend (&dbigcmd, "}", -1);	    
	tcl_invoke (dbigcmd.string);
	Tcl_DStringFree (&dbigcmd);
    }
	
    Tcl_ResetResult (interp);
    return TCL_OK;
} /* dsk_ppflist */

