# Makefile for GLU for VMS
# contributed by Jouk Jansen  joukj@crys.chem.uva.nl

.first
	define gl [-.include.gl]

.include [-]mms-config.

##### MACROS #####

VPATH = RCS

INCDIR = $disk2:[-.include]
LIBDIR = [-.lib]
CFLAGS = /include=$(INCDIR)/define=(FBIND=1)

SOURCES = glu.c mipmap.c nurbs.c nurbscrv.c nurbssrf.c nurbsutl.c \
	project.c quadric.c tess.c tess_fist.c tess_hash.c tess_heap.c \
	tess_winding.c tess_clip.c

OBJECTS =glu.obj,mipmap.obj,nurbs.obj,nurbscrv.obj,nurbssrf.obj,nurbsutl.obj,\
	project.obj,quadric.obj,tess.obj,tess_fist.obj,tess_hash.obj,\
	tess_heap.obj,tess_winding.obj,tess_clip.obj



##### RULES #####

VERSION=MesaGlu V3.1

##### TARGETS #####

# Make the library:
$(LIBDIR)$(GLU_LIB) : $(OBJECTS)
.ifdef SHARE
  @ WRITE_ SYS$OUTPUT "  generating mesagl1.opt"
  @ OPEN_/WRITE FILE  mesagl1.opt
  @ WRITE_ FILE "!"
  @ WRITE_ FILE "! mesagl1.opt generated by DESCRIP.$(MMS_EXT)" 
  @ WRITE_ FILE "!"
  @ WRITE_ FILE "IDENTIFICATION=""$(VERSION)"""
  @ WRITE_ FILE "GSMATCH=LEQUAL,3,1
  @ WRITE_ FILE "$(OBJECTS)"
  @ WRITE_ FILE "[-.lib]libmesagl.exe/SHARE"
  @ WRITE_ FILE "SYS$SHARE:DECW$XEXTLIBSHR/SHARE"
  @ WRITE_ FILE "SYS$SHARE:DECW$XLIBSHR/SHARE"
  @ CLOSE_ FILE
  @ WRITE_ SYS$OUTPUT "  generating mesagl.map ..."
  @ LINK_/NODEB/NOSHARE/NOEXE/MAP=mesagl.map/FULL mesagl1.opt/OPT
  @ WRITE_ SYS$OUTPUT "  analyzing mesagl.map ..."
  @ @[-.vms]ANALYZE_MAP.COM mesagl.map mesagl.opt
  @ WRITE_ SYS$OUTPUT "  linking $(GLU_LIB) ..."
  @ LINK_/noinform/NODEB/SHARE=$(GLU_LIB)/MAP=mesagl.map/FULL mesagl1.opt/opt,mesagl.opt/opt
.else
  @ $(MAKELIB) $(GLU_LIB) $(OBJECTS)
.endif
  @ rename $(GLU_LIB)* $(LIBDIR)

clean :
	delete *.obj;*
	purge

include mms_depend.

