/* $Id: gdict-applet.c,v 1.11 2000/05/19 15:01:03 hovinen Exp $ */

/*
 *  Papadimitriou Spiros <spapadim+@cs.cmu.edu>
 *
 *  This code released under the GNU GPL.
 *  Read the file COPYING for more information.
 *
 *  GDict panel applet
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#else
#  define PACKAGE "gdict"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include <gnome.h>
#include <applet-widget.h>

#include "gdict-app.h"
#include "gdict-about.h"
#include "gdict-pref.h"
#include "gdict-applet.h"
#include "gdict-pref-dialog.h"

gboolean gdict_applet_toggle = TRUE;
GtkWidget *gdict_applet = NULL;

#define APPLET_WIDTH 74

static GtkWidget *applet_entry;
static GtkWidget *applet_handlebox = NULL;

static gint
applet_attach_cb (AppletWidget *widget, gpointer data)
{
    gtk_widget_set_usize(applet_handlebox, APPLET_WIDTH, 44);
    return FALSE;
}

static gint
applet_detach_cb (AppletWidget *widget, gpointer data)
{
    gtk_widget_set_usize(applet_handlebox, 14, 44);
    return FALSE;
}

static void
applet_show_hide_defbox_cb (AppletWidget *widget, gpointer data) 
{
    if (!GTK_WIDGET_VISIBLE (gdict_app))
        gtk_widget_show (gdict_app);
    else
        gtk_widget_hide (gdict_app);
}

static void
applet_spell_cb (AppletWidget *widget, gpointer data) 
{
    gchar *text;

    text = gtk_entry_get_text (GTK_ENTRY (applet_entry));
    gdict_spell (text, FALSE);
    gtk_entry_set_text (GTK_ENTRY (applet_entry), "");
}

static void
applet_clicked_cb (GtkWidget *widget, GdkEventButton *ev, gpointer data)
{
    if ((ev == NULL) || (ev->button != 1) || (ev->type != GDK_2BUTTON_PRESS ))
        return;

    applet_show_hide_defbox_cb (APPLET_WIDGET (widget), data);
}

static void
applet_about_cb (AppletWidget *widget, gpointer data)
{
    gdict_about();
}

static void
applet_pref_cb (AppletWidget *widget, gpointer data) 
{
    gdict_app_show_preferences ();
}

static void
applet_lookup_cb (GtkWidget *widget, gpointer data)
{
    gchar *text = gtk_entry_get_text(GTK_ENTRY(applet_entry));
    if (*text == 0)
        return;
    g_strdown (text);
    if (!GTK_WIDGET_VISIBLE (gdict_app))
        gtk_widget_show (gdict_app);
    gtk_entry_set_text (GTK_ENTRY (applet_entry), "");
    gtk_entry_set_text (GTK_ENTRY (word_entry), text);
    gtk_editable_select_region (GTK_EDITABLE (word_entry), 0, strlen (text));
    gdict_app_do_lookup (text);
}

void gdict_applet_create (void)
{
    GtkWidget *button;
    GtkWidget *vbox;
#if 0
    GtkWidget *frame_in, *frame_out;
#endif

    g_return_if_fail(gdict_applet_toggle);

    if ((gdict_applet = applet_widget_new(PACKAGE)) == NULL)
        g_error(_("Cannot create applet!\n"));

    gtk_widget_set_events (gdict_applet, 
			   gtk_widget_get_events(gdict_applet) |
                           GDK_BUTTON_PRESS_MASK | GDK_EXPOSURE_MASK );
    gtk_signal_connect (GTK_OBJECT(gdict_applet), "button_press_event",
                        GTK_SIGNAL_FUNC(applet_clicked_cb), NULL);

    applet_widget_register_stock_callback 
	(APPLET_WIDGET (gdict_applet), "about",
	 GNOME_STOCK_MENU_ABOUT, _("About..."),
	 applet_about_cb, NULL);
    applet_widget_register_stock_callback 
	(APPLET_WIDGET (gdict_applet), "preferences",
	 GNOME_STOCK_MENU_PREF, _("Preferences..."),
	 applet_pref_cb, NULL);
    applet_widget_register_callback
	(APPLET_WIDGET (gdict_applet), "show_hide_window", 
	 _("Show/Hide Definition Window..."), applet_show_hide_defbox_cb,
	 NULL);
    applet_widget_register_callback
	(APPLET_WIDGET (gdict_applet), "spell_check", 
	 _("Spell Check..."), applet_spell_cb, NULL);

    gtk_signal_connect (GTK_OBJECT(gdict_applet), "destroy",
                        GTK_SIGNAL_FUNC(gtk_main_quit), NULL);

    vbox = gtk_vbox_new(FALSE, 2);
    gtk_container_set_border_width (GTK_CONTAINER(vbox), 2);
    gtk_widget_show(vbox);

    applet_entry = gtk_entry_new();
    gtk_widget_show(applet_entry);
    button = gtk_button_new_with_label(_("Lookup"));
    gtk_widget_show(button);
    gtk_box_pack_end(GTK_BOX(vbox), button, TRUE, TRUE, 0);
    gtk_signal_connect (GTK_OBJECT(applet_entry), "activate",
                        GTK_SIGNAL_FUNC(applet_lookup_cb), NULL);
    gtk_signal_connect (GTK_OBJECT(button), "clicked",
                        GTK_SIGNAL_FUNC(applet_lookup_cb), NULL);


    if (gdict_pref.applet_handle) {
        applet_handlebox = gtk_handle_box_new();
        gtk_handle_box_set_shadow_type(GTK_HANDLE_BOX(applet_handlebox), GTK_SHADOW_IN);
        gtk_widget_set_usize(applet_handlebox, APPLET_WIDTH, 44);
        gtk_container_add (GTK_CONTAINER(applet_handlebox), vbox);
        gtk_widget_show(applet_handlebox);

        gtk_signal_connect (GTK_OBJECT(applet_handlebox), "child_detached",
                            GTK_SIGNAL_FUNC(applet_detach_cb), NULL);
        gtk_signal_connect (GTK_OBJECT(applet_handlebox), "child_attached",
                            GTK_SIGNAL_FUNC(applet_attach_cb), NULL);

        applet_widget_add(APPLET_WIDGET(gdict_applet), applet_handlebox);
    } else {
        gtk_widget_set_usize(vbox, APPLET_WIDTH, 44);
        applet_widget_add(APPLET_WIDGET(gdict_applet), vbox);
    }

    /* We want to allow pasting into the input box so we pack it after */
    /* applet_widdget_add has bound the middle button -- thanks to webcontrol applet! :-) */
    gtk_box_pack_end(GTK_BOX(vbox), applet_entry, TRUE, TRUE, 0);

    gtk_widget_show (gdict_applet);
}

