/********************************
 Add messages to histories
 (c) 1999 Jeremy Wise 
 GnomeICU 
*********************************/

/*** GnomeICU header files ***/
#include "common.h"

/*** Toplevel header files ***/
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include <gtk/gtk.h>

/*** Global functions ***/
void add_incoming_to_history( int uin, char *statement, time_t *timedate )
{
#if 0
	time_t timedate;
#endif

	gchar *filename;
#ifdef HAVE_ICUDB
	DB_FILE db_file;
	datum kdat, vdat;
#else
	int file;
	struct tm *my_tm;
	gchar *pdate = NULL;
	int cx, cy, cz;
	char *halves[] = { "AM", "PM" };
	int half = 0;
#endif

#ifdef TRACE_FUNCTION
	g_print( "add_incoming_to_history\n" );
#endif

#if 0
	time( &timedate );
#endif

	if( timedate == NULL )
	{
		timedate = g_new0( time_t, 1 );
		time( timedate );
	}

#ifdef HAVE_ICUDB

	filename = g_strdup_printf( "/%s/.icq/history/%d.db", getenv( "HOME" ), uin);
	if( ( db_file = icudb_open( filename, DB_WRITE ) ) == NULL )
	  {
	    g_warning("gnomeicu:open:%s:%s\n", filename, g_strerror(errno));
	    return;
	  }
	g_free( filename );

	/* Set up a key by which this message is referenced */
	kdat.dptr = (char*)timedate;
	kdat.dsize = sizeof( time_t );

	/* Set up the data to store the message, with two bytes at the beginning
	 * for flags. */
	vdat.dptr = g_strdup_printf("  %s", statement);
	vdat.dsize = strlen( vdat.dptr );
	memset(vdat.dptr, 0, 2);

	/* This message was received */
	MESG_SETRECV(vdat.dptr);
	/* Until we read messages from the file, mark all incoming messages as read */
	MESG_SETREAD(vdat.dptr);

	if( icudb_store( db_file, kdat, vdat, DB_INSERT ) )
	  g_warning("gnomeicu:icudb_store:%s:%s:%s\n", kdat.dptr, vdat.dptr + 2, g_strerror(errno));

	g_free(vdat.dptr);

	icudb_close(db_file);
	
#else
	my_tm = localtime( timedate );

	if( my_tm->tm_hour > 12 )
	{
		my_tm->tm_hour -= 12 ;
		half ++;
	}

	filename = g_strdup_printf( "/%s/.icq/history/%d", getenv( "HOME" ), uin);
	if( ( file = open( filename, O_WRONLY | O_CREAT | O_APPEND, S_IRUSR | S_IWUSR ) ) == -1 )
	  {
	    g_warning("gnomeicu:open:%s:%s\n", filename, g_strerror(errno));
	    return;
	  }

	g_free( filename );

	pdate = g_strdup_printf( "\n*** %02d/%02d/%d %02d:%02d:%02d %s [ Received ] ***\n",
				 my_tm->tm_mon + 1, 
				 my_tm->tm_mday,
				 my_tm->tm_year + 1900,
				 my_tm->tm_hour,
				 my_tm->tm_min,
				 my_tm->tm_sec,
				 halves[ half ] );

	write( file, pdate, strlen( pdate ) );

	g_free( pdate );

	cy = cz = 0;
	for( cx = 0; cx < strlen( statement ); cx ++ )
	{
		cy ++;
		if( statement[cx] == '\n' || cy == 70 ||
		    ( cy >= 60 && statement[cx] == ' ' ) )
		{
			write( file, ( statement + cz ), cy );
			if( cy >= 60 && cy != 70 )
			{
				write( file, "\n", 1 );
			}
			if( cy == 70 )
			{
				write( file, "-\n", 2 );
			}
			cz += cy;
			cy = 0;
		}
	}			

	if( cz != strlen( statement ) )
	{
		write( file, ( statement + cz ), strlen( statement ) - cz );
	}

	write( file, "\n", 1 );

	close( file );
#endif /* HAVE_ICUDB */
}

void add_outgoing_to_history( int uin, char *statement )
{
	time_t timedate;

	gchar *filename;
#ifdef HAVE_ICUDB
	DB_FILE db_file;
	datum kdat, vdat;
#else
	int file;
	struct tm *my_tm;
	gchar *pdate = NULL;
	int cx, cy, cz;
	char *halves[] = { "AM", "PM" };
	int half = 0;
#endif

#ifdef TRACE_FUNCTION
	g_print( "add_outgoing_to_history\n" );
#endif

	time( &timedate );

#ifdef HAVE_ICUDB

	filename = g_strdup_printf( "/%s/.icq/history/%d.db", getenv( "HOME" ), uin);
	if( ( db_file = icudb_open( filename, DB_WRITE ) ) == NULL )
	  {
	    g_warning("gnomeicu:open:%s:%s\n", filename, g_strerror(errno));
	    return;
	  }
	g_free( filename );

	/* Set up a key by which this message is referenced */
	kdat.dptr = (char*)&timedate;
	kdat.dsize = sizeof( time_t );

	/* Set up the data to store the message, with two bytes at the beginning
	 * for flags. */
	vdat.dptr = g_strdup_printf("  %s", statement);
	vdat.dsize = strlen( vdat.dptr );
	memset(vdat.dptr, 0, 2);

	/* Mark this message as read, since we wrote it. */
	MESG_SETREAD(vdat.dptr);

	if( icudb_store( db_file, kdat, vdat, DB_INSERT ) )
	  g_warning("gnomeicu:icudb_store:%s:%s:%s\n", kdat.dptr, vdat.dptr + 2, g_strerror(errno));

	g_free(vdat.dptr);

	icudb_close(db_file);
	
#else
	my_tm = localtime( &timedate );

	if( my_tm->tm_hour > 12 )
	{
		my_tm->tm_hour -= 12 ;
		half ++;
	}

	filename = g_strdup_printf( "/%s/.icq/history/%d", getenv( "HOME" ), uin);

	if( ( file = open( filename, O_WRONLY | O_CREAT | O_APPEND, S_IRUSR | S_IWUSR ) ) == -1 )
	  {
	    g_warning("gnomeicu:open:%s:%s\n", filename, g_strerror(errno));
	    return;
	  }

	g_free( filename );

	pdate = g_strdup_printf( "\n*** %02d/%02d/%d %02d:%02d:%02d %s [ Sent ] ***\n",
				 my_tm->tm_mon + 1,
				 my_tm->tm_mday,
				 my_tm->tm_year + 1900,
				 my_tm->tm_hour,
				 my_tm->tm_min,
				 my_tm->tm_sec,
				 halves[ half ] );

	write( file, pdate, strlen( pdate ) );

	g_free( pdate );

	cy = cz = 0;
	for( cx = 0; cx < strlen( statement ); cx ++ )
	{
		cy ++;
		if( statement[cx] == '\n' || cy == 70 ||
		    ( cy >= 60 && statement[cx] == ' ' ) )
		{
			write( file, ( statement + cz ), cy );
			if( cy >= 60 && cy != 70 )
			{
				write( file, "\n", 1 );
			}
			if( cy == 70 )
			{
				write( file, "-\n", 2 );
			}
			cz += cy;
			cy = 0;
		}
	}			

	if( cz != strlen( statement ) )
	{
		write( file, ( statement + cz ), strlen( statement ) - cz );
	}
	
	write( file, "\n", 1 );

	close( file );
#endif /* HAVE_ICUDB */
}
