/**********************************
 Configuration window (Options)
 (c) 1999 Jeremy Wise
 GnomeICU
***********************************/

/*** GnomeICU header files ***/
#include "common.h"

/*** Toplevel header files ***/
#include <stdio.h>
#include <stdlib.h>

/*** Local function declarations ***/
void apply_changes( GnomePropertyBox *box, gint page );
static void color_set_online(GnomeColorPicker *cp, guint pr, guint pg, guint pb );
static void color_set_offline(GnomeColorPicker *cp, guint pr, guint pg, guint pb );
static void color_set_away(GnomeColorPicker *cp, guint pr, guint pg, guint pb );
static void color_set_na(GnomeColorPicker *cp, guint pr, guint pg, guint pb );
static void color_set_ffc(GnomeColorPicker *cp, guint pr, guint pg, guint pb );
static void color_set_occ(GnomeColorPicker *cp, guint pr, guint pg, guint pb );
static void color_set_dnd(GnomeColorPicker *cp, guint pr, guint pg, guint pb );
static void color_set_inv(GnomeColorPicker *cp, guint pr, guint pg, guint pb );
static void toggle_switch(GtkWidget *widget, gboolean *toggle_me);
static void save_changes(GtkWidget *widget, gpointer data );
static void activate_changes( GtkWidget *widget, gpointer data );
static void entry_changed( GtkWidget *widget, gpointer data );
static gint Build_Main_Window( void );

/* Away Msg List */
static void do_away_msgs(GtkWidget* main_window, GtkWidget*
		  away_frame, GtkWidget *away_msg_table, const int
			 num);
static void get_away_msg(GtkWidget *away_msg, gpointer data);
static gchar **temp_away_msgs = NULL; /* Local */
/* End Away Msg List */

/* Temporary values so changes are NOT saved unless "Save" is pressed */
_toggles *temp_toggles;

gint temp_autohide_time = 0;
gint temp_min_tcp_port = 0;
gint temp_max_tcp_port = 0;

GdkColor temp_color_online;
GdkColor temp_color_offline;
GdkColor temp_color_away;
GdkColor temp_color_na;
GdkColor temp_color_ffc;
GdkColor temp_color_occ;
GdkColor temp_color_dnd;
GdkColor temp_color_inv;

GdkColor color_online, color_offline, color_away, color_na, color_ffc, color_occ, color_dnd, color_inv;
int color_online_set = 0, color_offline_set = 0, color_away_set = 0, color_na_set = 0, color_ffc_set = 0, color_occ_set = 0, color_dnd_set = 0, color_inv_set = 0;

GtkWidget *GnomeICU_Options;
GtkWidget *icqserver, *portnumber, *uin, *nick, *pass, *filesel;

GtkWidget *ext_prog_receive_message, *ext_prog_chat_request;
GtkWidget *ext_prog_receive_url, *ext_prog_file_request;
GtkWidget *ext_prog_user_online, *ext_prog_user_offline;
GtkWidget *ext_prog_auth, *ext_prog_auth_request;
GtkWidget *ext_prog_list_add, *ext_prog_contact_list;

/*** Global functions ***/
void init_colors( void )
{
#ifdef TRACE_FUNCTION
	g_print( "init_colors\n" );
#endif

	/* Online is blue */
	if( color_online_set == FALSE )
	{
		color_online.red = 0;
		color_online.green = 0;
		color_online.blue = 30000;
		color_online.pixel = (gulong)(255);
	}
	
	/* Offline is dark gray */
	if( color_offline_set == FALSE )
	{
		color_offline.red = 30000;
		color_offline.green = 30000;
		color_offline.blue = 30000;
		color_offline.pixel = (gulong)(255*50000);
	}

	/* Away is green */
	if( color_away_set == FALSE )
	{
		color_away.red = 0;
		color_away.green = 30000;
		color_away.blue = 0;
		color_away.pixel = (gulong)255*256;
	}
	
	/* Not available is green also */
	if( color_na_set == FALSE )
	{
		color_na.red = 0;
		color_na.green = 30000;
		color_na.blue = 0;
		color_na.pixel = (gulong)255*256;
	}

	/* Free for chat is blue */
	if( color_ffc_set == FALSE )
	{
		color_ffc.red = 0;
		color_ffc.green = 0;
		color_ffc.blue = 30000;
		color_ffc.pixel = (gulong)(255);
	}

	/* Occupied is green */
	if( color_occ_set == FALSE )
	{
		color_occ.red = 0;
		color_occ.green = 30000;
		color_occ.blue = 0;
		color_occ.pixel = (gulong)255*256;
	}

	/* Do not disturb is green also */
	if( color_dnd_set == FALSE )
	{
		color_dnd.red = 0;
		color_dnd.green = 30000;
		color_dnd.blue = 0;
		color_dnd.pixel = (gulong)255*256;
	}

	/* Invisible is blue */
	if( color_inv_set == FALSE )
	{
		color_inv.red = 0;
		color_inv.green = 0;
		color_inv.blue = 30000;
		color_inv.pixel = (gulong)(255);
	}

	gdk_color_alloc( gtk_widget_get_colormap( MainData->lb_userwin ), &color_online );
	gdk_color_alloc( gtk_widget_get_colormap( MainData->lb_userwin ), &color_offline );
	gdk_color_alloc( gtk_widget_get_colormap( MainData->lb_userwin ), &color_away );
	gdk_color_alloc( gtk_widget_get_colormap( MainData->lb_userwin ), &color_na );
	gdk_color_alloc( gtk_widget_get_colormap( MainData->lb_userwin ), &color_ffc );
	gdk_color_alloc( gtk_widget_get_colormap( MainData->lb_userwin ), &color_occ );
	gdk_color_alloc( gtk_widget_get_colormap( MainData->lb_userwin ), &color_dnd );
	gdk_color_alloc( gtk_widget_get_colormap( MainData->lb_userwin ), &color_inv );
}

void configure_window( GtkWidget *widget, gpointer data )
{
	GtkWidget *notebook1;
	GtkWidget *vbox4;
	GtkWidget *frame2;
	GtkWidget *hbox1;
	GtkWidget *table1;
	GtkWidget *label;
	GtkWidget *alignment1;
	GtkWidget *alignment2;
	GtkWidget *alignment3;
	GtkWidget *alignment4;
	GtkWidget *alignment5;
	GtkWidget *alignment6;
	GtkWidget *alignment7;
	GtkWidget *alignment8;
	GtkWidget *picker_online;
	GtkWidget *picker_away;
	GtkWidget *picker_ffc;
	GtkWidget *picker_na;
	GtkWidget *table2;
	GtkWidget *picker_occ;
	GtkWidget *picker_dnd;
	GtkWidget *picker_inv;
	GtkWidget *picker_offline;
	GtkWidget *frame1;
	GtkWidget *vbox5;
	GtkWidget *sound_button;
	GtkWidget *beep_button;
	GtkWidget *frame3;
	GtkWidget *vbox29;
	GtkWidget *showmain_button;
	GtkWidget *fullreply_button;
	GtkWidget *vbox6;
	GtkWidget *frame4;
	GtkWidget *vbox7;
	GtkWidget *russian_button;
	GtkWidget *dumpudp_button;
	GtkWidget *dumptcp_button;
	GtkWidget *frame5;
	GtkWidget *vbox8;
	GtkWidget *table3;
	GtkWidget *alignment9;
	GtkObject *portnumber_adj;
	GtkWidget *frame28;
	GtkWidget *vbox30;
	GtkWidget *hbox11;
	GtkObject *spinbutton4_adj;
	GtkWidget *spinbutton4;
	GtkObject *spinbutton5_adj;
	GtkWidget *spinbutton5;
	GtkWidget *force_button;
	GtkWidget *vbox9;
	GtkWidget *frame6;
	GtkWidget *vbox10;
	GtkWidget *webpresence_button;
	GtkWidget *popup_button;
	GtkWidget *hbox2;
	GtkWidget *autohide_button;
	GtkObject *spin_button_adj;
	GtkWidget *spin_button;
	GtkWidget *frame29;
	GtkWidget *table25;
	GtkWidget *table4;
	GtkWidget *frame7;
	GtkWidget *toggle1;
	GtkWidget *entry1;
	GtkWidget *vbox12;
   	GtkWidget *tooltip_button;

	/* The following is for the Away Messages */
	int temp;
	GtkWidget *away_frame, *away_msg_table, *away_vbox;
	/* End Away Message Stuff */
	   
	temp_toggles = g_new0( _toggles, 1 );
	memcpy( temp_toggles, toggles, sizeof( _toggles ));

	memcpy( &temp_color_online, &color_online, sizeof( GdkColor ) );
	memcpy( &temp_color_offline, &color_offline, sizeof( GdkColor ) );
	memcpy( &temp_color_away, &color_away, sizeof( GdkColor ) );
	memcpy( &temp_color_na, &color_na, sizeof( GdkColor ) );
	memcpy( &temp_color_ffc, &color_ffc, sizeof( GdkColor ) );
	memcpy( &temp_color_occ, &color_occ, sizeof( GdkColor ) );
	memcpy( &temp_color_dnd, &color_dnd, sizeof( GdkColor ) );
	memcpy( &temp_color_inv, &color_inv, sizeof( GdkColor ) );

	temp_autohide_time = autohide_time;
	temp_min_tcp_port = min_tcp_port;
	temp_max_tcp_port = max_tcp_port;

	GnomeICU_Options = gnome_property_box_new ();
	gtk_widget_set_name (GnomeICU_Options, "GnomeICU_Options");
	gtk_object_set_data (GTK_OBJECT (GnomeICU_Options), "GnomeICU_Options", GnomeICU_Options);
	gtk_window_set_title( GTK_WINDOW( GnomeICU_Options ), _("GnomeICU: Options") );

	notebook1 = GNOME_PROPERTY_BOX (GnomeICU_Options)->notebook;
	gtk_widget_set_name (notebook1, "notebook1");
	gtk_object_set_data (GTK_OBJECT (GnomeICU_Options), "notebook1", notebook1);
	gtk_widget_show (notebook1);

	vbox4 = gtk_vbox_new (FALSE, 8);
	gtk_widget_set_name (vbox4, "vbox4");
	gtk_widget_ref (vbox4);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "vbox4", vbox4,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox4);
	gtk_container_add (GTK_CONTAINER (notebook1), vbox4);
	gtk_container_set_border_width (GTK_CONTAINER (vbox4), 6);

	frame2 = gtk_frame_new (_("Colors"));
	gtk_widget_set_name (frame2, "frame2");
	gtk_widget_ref (frame2);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "frame2", frame2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame2);
	gtk_box_pack_start (GTK_BOX (vbox4), frame2, TRUE, TRUE, 0);

	hbox1 = gtk_hbox_new (TRUE, 8);
	gtk_widget_set_name (hbox1, "hbox1");
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "hbox1", hbox1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_container_add (GTK_CONTAINER (frame2), hbox1);
	gtk_container_set_border_width (GTK_CONTAINER (hbox1), 6);

	table1 = gtk_table_new (4, 2, TRUE);
	gtk_widget_set_name (table1, "table1");
	gtk_widget_ref (table1);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "table1", table1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table1);
	gtk_box_pack_start (GTK_BOX (hbox1), table1, FALSE, TRUE, 0);
	gtk_table_set_row_spacings (GTK_TABLE (table1), 4);
	gtk_table_set_col_spacings (GTK_TABLE (table1), 4);

	label = gtk_label_new (_("Away"));
	gtk_widget_set_name (label, "label");
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "label", label,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table1), label, 0, 1, 1, 2,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

	label = gtk_label_new (_("Free For Chat"));
	gtk_widget_set_name (label, "label");
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "label", label,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table1), label, 0, 1, 2, 3,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

	label = gtk_label_new (_("Not Available"));
	gtk_widget_set_name (label, "label");
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "label", label,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table1), label, 0, 1, 3, 4,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

	label = gtk_label_new (_("Online"));
	gtk_widget_set_name (label, "label");
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "label", label,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table1), label, 0, 1, 0, 1,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

	alignment1 = gtk_alignment_new (0, 0.5, 0, 1);
	gtk_widget_set_name (alignment1, "alignment1");
	gtk_widget_ref (alignment1);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "alignment1", alignment1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alignment1);
	gtk_table_attach (GTK_TABLE (table1), alignment1, 1, 2, 0, 1,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);

	picker_online = gnome_color_picker_new ();

	gnome_color_picker_set_i16(GNOME_COLOR_PICKER( picker_online ),
	           temp_color_online.red,
	           temp_color_online.green,
	           temp_color_online.blue,
	           0 );

	gtk_widget_set_name (picker_online, "picker_online");
	gtk_widget_ref (picker_online);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "picker_online", picker_online,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (picker_online);
	gtk_container_add (GTK_CONTAINER (alignment1), picker_online);
	gnome_color_picker_set_title (GNOME_COLOR_PICKER (picker_online), _("GnomeICU: Online Color"));

	alignment2 = gtk_alignment_new (0, 0.5, 0, 1);
	gtk_widget_set_name (alignment2, "alignment2");
	gtk_widget_ref (alignment2);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "alignment2", alignment2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alignment2);
	gtk_table_attach (GTK_TABLE (table1), alignment2, 1, 2, 1, 2,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);

	picker_away = gnome_color_picker_new ();

	gnome_color_picker_set_i16(GNOME_COLOR_PICKER( picker_away ),
	           temp_color_away.red,
	           temp_color_away.green,
	           temp_color_away.blue,
	           0 );

	gtk_widget_set_name (picker_away, "picker_away");
	gtk_widget_ref (picker_away);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "picker_away", picker_away,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (picker_away);
	gtk_container_add (GTK_CONTAINER (alignment2), picker_away);
	gnome_color_picker_set_title (GNOME_COLOR_PICKER (picker_away), _("GnomeICU: Away Color"));

	alignment3 = gtk_alignment_new (0, 0.5, 0, 1);
	gtk_widget_set_name (alignment3, "alignment3");
	gtk_widget_ref (alignment3);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "alignment3", alignment3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alignment3);
	gtk_table_attach (GTK_TABLE (table1), alignment3, 1, 2, 2, 3,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);

	picker_ffc = gnome_color_picker_new ();

	gnome_color_picker_set_i16(GNOME_COLOR_PICKER( picker_ffc ),
	           temp_color_ffc.red,
	           temp_color_ffc.green,
	           temp_color_ffc.blue,
	           0 );

	gtk_widget_set_name (picker_ffc, "picker_ffc");
	gtk_widget_ref (picker_ffc);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "picker_ffc", picker_ffc,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (picker_ffc);
	gtk_container_add (GTK_CONTAINER (alignment3), picker_ffc);
	gnome_color_picker_set_title (GNOME_COLOR_PICKER (picker_ffc), _("GnomeICU: Free for Chat Color"));

	alignment4 = gtk_alignment_new (0, 0.5, 0, 1);
	gtk_widget_set_name (alignment4, "alignment4");
	gtk_widget_ref (alignment4);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "alignment4", alignment4,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alignment4);
	gtk_table_attach (GTK_TABLE (table1), alignment4, 1, 2, 3, 4,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);

	picker_na = gnome_color_picker_new ();

	gnome_color_picker_set_i16(GNOME_COLOR_PICKER( picker_na ),
	           temp_color_na.red,
	           temp_color_na.green,
	           temp_color_na.blue,
	           0 );

	gtk_widget_set_name (picker_na, "picker_na");
	gtk_widget_ref (picker_na);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "picker_na", picker_na,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (picker_na);
	gtk_container_add (GTK_CONTAINER (alignment4), picker_na);
	gnome_color_picker_set_title (GNOME_COLOR_PICKER (picker_na), _("GnomeICU: Not Available Color"));

	table2 = gtk_table_new (4, 2, TRUE);
	gtk_widget_set_name (table2, "table2");
	gtk_widget_ref (table2);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "table2", table2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table2);
	gtk_box_pack_start (GTK_BOX (hbox1), table2, FALSE, TRUE, 0);
	gtk_table_set_row_spacings (GTK_TABLE (table2), 4);
	gtk_table_set_col_spacings (GTK_TABLE (table2), 4);

	label = gtk_label_new (_("Occupied"));
	gtk_widget_set_name (label, "label");
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "label", label,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table2), label, 0, 1, 0, 1,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

	label = gtk_label_new (_("Do not Disturb"));
	gtk_widget_set_name (label, "label");
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "label", label,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table2), label, 0, 1, 1, 2,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

	label = gtk_label_new (_("Invisible"));
	gtk_widget_set_name (label, "label");
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "label", label,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table2), label, 0, 1, 2, 3,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

	label = gtk_label_new (_("Offline"));
	gtk_widget_set_name (label, "label");
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "label", label,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table2), label, 0, 1, 3, 4,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

	alignment5 = gtk_alignment_new (0, 0.5, 0, 1);
	gtk_widget_set_name (alignment5, "alignment5");
	gtk_widget_ref (alignment5);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "alignment5", alignment5,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alignment5);
	gtk_table_attach (GTK_TABLE (table2), alignment5, 1, 2, 0, 1,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);

	picker_occ = gnome_color_picker_new ();

	gnome_color_picker_set_i16(GNOME_COLOR_PICKER( picker_occ ),
	           temp_color_occ.red,
	           temp_color_occ.green,
	           temp_color_occ.blue,
	           0 );

	gtk_widget_set_name (picker_occ, "picker_occ");
	gtk_widget_ref (picker_occ);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "picker_occ", picker_occ,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (picker_occ);
	gtk_container_add (GTK_CONTAINER (alignment5), picker_occ);
	gnome_color_picker_set_title (GNOME_COLOR_PICKER (picker_occ), _("GnomeICU: Occupied Color"));

	alignment6 = gtk_alignment_new (0, 0.5, 0, 1);
	gtk_widget_set_name (alignment6, "alignment6");
	gtk_widget_ref (alignment6);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "alignment6", alignment6,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alignment6);
	gtk_table_attach (GTK_TABLE (table2), alignment6, 1, 2, 1, 2,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);

	picker_dnd = gnome_color_picker_new ();

	gnome_color_picker_set_i16(GNOME_COLOR_PICKER( picker_dnd ),
	           temp_color_dnd.red,
	           temp_color_dnd.green,
	           temp_color_dnd.blue,
	           0 );

	gtk_widget_set_name (picker_dnd, "picker_dnd");
	gtk_widget_ref (picker_dnd);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "picker_dnd", picker_dnd,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (picker_dnd);
	gtk_container_add (GTK_CONTAINER (alignment6), picker_dnd);
	gnome_color_picker_set_title (GNOME_COLOR_PICKER (picker_dnd), _("GnomeICU: Do not Disturb Color"));

	alignment7 = gtk_alignment_new (0, 0.5, 0, 1);
	gtk_widget_set_name (alignment7, "alignment7");
	gtk_widget_ref (alignment7);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "alignment7", alignment7,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alignment7);
	gtk_table_attach (GTK_TABLE (table2), alignment7, 1, 2, 2, 3,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);

	picker_inv = gnome_color_picker_new ();

	gnome_color_picker_set_i16(GNOME_COLOR_PICKER( picker_inv ),
	           temp_color_inv.red,
	           temp_color_inv.green,
	           temp_color_inv.blue,
	           0 );

	gtk_widget_set_name (picker_inv, "picker_inv");
	gtk_widget_ref (picker_inv);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "picker_inv", picker_inv,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (picker_inv);
	gtk_container_add (GTK_CONTAINER (alignment7), picker_inv);
	gnome_color_picker_set_title (GNOME_COLOR_PICKER (picker_inv), _("GnomeICU: Invisible Color"));

	alignment8 = gtk_alignment_new (0, 0.5, 0, 1);
	gtk_widget_set_name (alignment8, "alignment8");
	gtk_widget_ref (alignment8);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "alignment8", alignment8,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alignment8);
	gtk_table_attach (GTK_TABLE (table2), alignment8, 1, 2, 3, 4,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);

	picker_offline = gnome_color_picker_new ();

	gnome_color_picker_set_i16(GNOME_COLOR_PICKER( picker_offline ),
	           temp_color_offline.red,
	           temp_color_offline.green,
	           temp_color_offline.blue,
	           0 );

	gtk_widget_set_name (picker_offline, "picker_offline");
	gtk_widget_ref (picker_offline);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "picker_offline", picker_offline,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (picker_offline);
	gtk_container_add (GTK_CONTAINER (alignment8), picker_offline);
	gnome_color_picker_set_title (GNOME_COLOR_PICKER (picker_offline), _("GnomeICU: Offline Color"));

	frame1 = gtk_frame_new (_("Sounds"));
	gtk_widget_set_name (frame1, "frame1");
	gtk_widget_ref (frame1);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "frame1", frame1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame1);
	gtk_box_pack_start (GTK_BOX (vbox4), frame1, TRUE, TRUE, 0);

	vbox5 = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox5, "vbox5");
	gtk_widget_ref (vbox5);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "vbox5", vbox5,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox5);
	gtk_container_add (GTK_CONTAINER (frame1), vbox5);
	gtk_container_set_border_width (GTK_CONTAINER (vbox5), 6);

	sound_button = gtk_check_button_new_with_label (_("Enable sounds"));
	gtk_widget_set_name (sound_button, "sound_button");
	gtk_widget_ref (sound_button);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "sound_button", sound_button,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( sound_button ), temp_toggles->sound );
	gtk_widget_show (sound_button);
	gtk_box_pack_start (GTK_BOX (vbox5), sound_button, FALSE, FALSE, 0);

	beep_button = gtk_check_button_new_with_label (_("Enable beeps"));
	gtk_widget_set_name (beep_button, "beep_button");
	gtk_widget_ref (beep_button);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "beep_button", beep_button,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( beep_button ), temp_toggles->beep );
	gtk_widget_show (beep_button);
	gtk_box_pack_start (GTK_BOX (vbox5), beep_button, FALSE, FALSE, 0);

	frame3 = gtk_frame_new (_("Miscellaneous"));
	gtk_widget_set_name (frame3, "frame3");
	gtk_widget_ref (frame3);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "frame3", frame3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame3);
	gtk_box_pack_start (GTK_BOX (vbox4), frame3, TRUE, TRUE, 0);

	vbox29 = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox29, "vbox29");
	gtk_widget_ref (vbox29);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "vbox29", vbox29,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox29);
	gtk_container_add (GTK_CONTAINER (frame3), vbox29);
	gtk_container_set_border_width (GTK_CONTAINER (vbox29), 6);

	showmain_button = gtk_check_button_new_with_label (_("Show Main Window on Startup"));
	gtk_widget_set_name (showmain_button, "showmain_button");
	gtk_widget_ref (showmain_button);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "showmain_button", showmain_button,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( showmain_button ), temp_toggles->show_window );
	gtk_widget_show (showmain_button);
	gtk_box_pack_start (GTK_BOX (vbox29), showmain_button, FALSE, FALSE, 0);

	fullreply_button = gtk_check_button_new_with_label (_("Automatically Show Entire Reply Dialog"));
	gtk_widget_set_name (fullreply_button, "fullreply_button");
	gtk_widget_ref (fullreply_button);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "fullreply_button", fullreply_button,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( fullreply_button ), temp_toggles->full_reply );
	gtk_widget_show (fullreply_button);
	gtk_box_pack_start (GTK_BOX (vbox29), fullreply_button, FALSE, FALSE, 0);

	popup_button = gtk_check_button_new_with_label (_("Automatically Popup Message Windows"));
	gtk_widget_set_name (popup_button, "popup_button");
	gtk_widget_ref (popup_button);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "popup_button", popup_button,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( popup_button ), temp_toggles->auto_popup );
	gtk_widget_show (popup_button);
	gtk_box_pack_start (GTK_BOX (vbox29), popup_button, FALSE, FALSE, 0);

   	tooltip_button = gtk_check_button_new_with_label(_("Hide tool-tips"));
   	gtk_widget_set_name(tooltip_button, "tooltip_button");
   	gtk_widget_ref(tooltip_button);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "tooltip_button", tooltip_button,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( tooltip_button ), temp_toggles->hidetooltip );
	gtk_widget_show (tooltip_button);
	gtk_box_pack_end (GTK_BOX (vbox29), tooltip_button, FALSE, FALSE, 0);
   	
	label = gtk_label_new ("");
	gtk_label_parse_uline (GTK_LABEL (label),
	                       _("_Interface"));
	gtk_widget_set_name (label, "label");
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "label", label,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 0), label);

	vbox6 = gtk_vbox_new (FALSE, 8);
	gtk_widget_set_name (vbox6, "vbox6");
	gtk_widget_ref (vbox6);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "vbox6", vbox6,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox6);
	gtk_container_add (GTK_CONTAINER (notebook1), vbox6);
	gtk_container_set_border_width (GTK_CONTAINER (vbox6), 6);

	frame4 = gtk_frame_new (_("Packets"));
	gtk_widget_set_name (frame4, "frame4");
	gtk_widget_ref (frame4);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "frame4", frame4,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame4);
	gtk_box_pack_start (GTK_BOX (vbox6), frame4, FALSE, TRUE, 0);

	vbox7 = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox7, "vbox7");
	gtk_widget_ref (vbox7);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "vbox7", vbox7,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox7);
	gtk_container_add (GTK_CONTAINER (frame4), vbox7);
	gtk_container_set_border_width (GTK_CONTAINER (vbox7), 6);
 	
 	/* Russian reencoding toggle button*/
 	
 	russian_button = gtk_check_button_new_with_label( _("Russian Win1251<->Koi8-r translation") );
	gtk_widget_set_name (russian_button, "russian_button");
	gtk_widget_ref (russian_button);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "russian_button", russian_button,
	                          (GtkDestroyNotify) gtk_widget_unref);
 	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( russian_button ), temp_toggles->russian );
 	gtk_widget_show( russian_button );
 	gtk_box_pack_start( GTK_BOX( vbox7 ), russian_button, FALSE, FALSE, 0 );


	dumpudp_button = gtk_check_button_new_with_label (_("Dump UDP Packets"));
	gtk_widget_set_name (dumpudp_button, "dumpudp_button");
	gtk_widget_ref (dumpudp_button);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "dumpudp_button", dumpudp_button,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( dumpudp_button ), temp_toggles->packet_udp );
	gtk_widget_show (dumpudp_button);
	gtk_box_pack_start (GTK_BOX (vbox7), dumpudp_button, FALSE, FALSE, 0);

	dumptcp_button = gtk_check_button_new_with_label (_("Dump TCP Packets"));
	gtk_widget_set_name (dumptcp_button, "dumptcp_button");
	gtk_widget_ref (dumptcp_button);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "dumptcp_button", dumptcp_button,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( dumptcp_button ), temp_toggles->packet_tcp );
	gtk_widget_show (dumptcp_button);
	gtk_box_pack_start (GTK_BOX (vbox7), dumptcp_button, FALSE, FALSE, 0);

	frame5 = gtk_frame_new (_("Server"));
	gtk_widget_set_name (frame5, "frame5");
	gtk_widget_ref (frame5);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "frame5", frame5,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame5);
	gtk_box_pack_start (GTK_BOX (vbox6), frame5, FALSE, TRUE, 0);

	vbox8 = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox8, "vbox8");
	gtk_widget_ref (vbox8);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "vbox8", vbox8,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox8);
	gtk_container_add (GTK_CONTAINER (frame5), vbox8);
	gtk_container_set_border_width (GTK_CONTAINER (vbox8), 6);

	table3 = gtk_table_new (2, 2, FALSE);
	gtk_widget_set_name (table3, "table3");
	gtk_widget_ref (table3);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "table3", table3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table3);
	gtk_box_pack_start (GTK_BOX (vbox8), table3, TRUE, TRUE, 0);
	gtk_table_set_row_spacings (GTK_TABLE (table3), 4);
	gtk_table_set_col_spacings (GTK_TABLE (table3), 4);

	label = gtk_label_new (_("ICQ Server:"));
	gtk_widget_set_name (label, "label");
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "label", label,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table3), label, 0, 1, 0, 1,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

	label = gtk_label_new (_("Port Number:"));
	gtk_widget_set_name (label, "label");
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "label", label,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table3), label, 0, 1, 1, 2,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

	icqserver = gtk_entry_new();
	gtk_widget_set_name (icqserver, "icqserver");
	gtk_widget_ref (icqserver);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "icqserver", icqserver,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_entry_set_text( GTK_ENTRY( icqserver ), server );
	gtk_widget_show (icqserver);
	gtk_table_attach (GTK_TABLE (table3), icqserver, 1, 2, 0, 1,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (0), 0, 0);
	gtk_signal_connect( GTK_OBJECT( icqserver ), "changed",
	                    GTK_SIGNAL_FUNC( entry_changed ), NULL );

	alignment9 = gtk_alignment_new (0, 0.5, 0.1, 1);
	gtk_widget_set_name (alignment9, "alignment9");
	gtk_widget_ref (alignment9);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "alignment9", alignment9,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alignment9);
	gtk_table_attach (GTK_TABLE (table3), alignment9, 1, 2, 1, 2,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (0), 0, 0);

	portnumber_adj = gtk_adjustment_new (remote_port, 1024, 65536, 1, 10, 10);
	portnumber = gtk_spin_button_new (GTK_ADJUSTMENT (portnumber_adj), 1, 0);
	gtk_widget_set_name (portnumber, "portnumber");
	gtk_widget_ref (portnumber);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "portnumber", portnumber,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (portnumber);
	gtk_container_add (GTK_CONTAINER (alignment9), portnumber);

	frame28 = gtk_frame_new (_("TCP Port Range"));
	gtk_widget_set_name (frame28, "frame28");
	gtk_widget_ref (frame28);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "frame28", frame28,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame28);
	gtk_box_pack_start (GTK_BOX (vbox6), frame28, TRUE, TRUE, 0);

	vbox30 = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox30, "vbox30");
	gtk_widget_ref (vbox30);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "vbox30", vbox30,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox30);
	gtk_container_add (GTK_CONTAINER (frame28), vbox30);
	gtk_container_set_border_width (GTK_CONTAINER (vbox30), 6);

/*	radiobutton1 = gtk_radio_button_new_with_label (tcp_port_range_group, _("Random Port"));
	tcp_port_range_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton1));
	gtk_widget_set_name (radiobutton1, "radiobutton1");
	gtk_widget_ref (radiobutton1);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "radiobutton1", radiobutton1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (radiobutton1);
	gtk_box_pack_start (GTK_BOX (vbox30), radiobutton1, FALSE, FALSE, 0);
*/
	hbox11 = gtk_hbox_new (FALSE, 0);
	gtk_widget_set_name (hbox11, "hbox11");
	gtk_widget_ref (hbox11);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "hbox11", hbox11,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox11);
	gtk_box_pack_start (GTK_BOX (vbox30), hbox11, FALSE, FALSE, 0);

	label = gtk_label_new (_("Range: From "));
	gtk_widget_set_name (label, "label");
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "label", label,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);
	gtk_box_pack_start (GTK_BOX (hbox11), label, FALSE, FALSE, 0);

	spinbutton4_adj = gtk_adjustment_new (temp_min_tcp_port, 1024, 65535, 1, 10, 10);
	spinbutton4 = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton4_adj), 1, 0);
	gtk_widget_set_name (spinbutton4, "spinbutton4");
	gtk_widget_ref (spinbutton4);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "spinbutton4", spinbutton4,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (spinbutton4);
	gtk_box_pack_start (GTK_BOX (hbox11), spinbutton4, FALSE, TRUE, 0);
	gtk_widget_set_usize (spinbutton4, 75, -2);

	label = gtk_label_new (_("   to   "));
	gtk_widget_set_name (label, "label");
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "label", label,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX (hbox11), label, FALSE, FALSE, 0);

	spinbutton5_adj = gtk_adjustment_new (temp_max_tcp_port, 1024, 65535, 1, 10, 10);
	spinbutton5 = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton5_adj), 1, 0);
	gtk_widget_set_name (spinbutton5, "spinbutton5");
	gtk_widget_ref (spinbutton5);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "spinbutton5", spinbutton5,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (spinbutton5);
	gtk_box_pack_start (GTK_BOX (hbox11), spinbutton5, FALSE, TRUE, 0);
	gtk_widget_set_usize (spinbutton5, 75, -2);

	force_button = gtk_check_button_new_with_label (_("Force messaging through server"));
	gtk_widget_set_name (force_button, "force_button");
	gtk_widget_ref (force_button);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "force_button", force_button,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( force_button ), temp_toggles->force );
	gtk_widget_show (force_button);
	gtk_box_pack_start (GTK_BOX (vbox30), force_button, FALSE, FALSE, 0);

	label = gtk_label_new ("");
	gtk_label_parse_uline (GTK_LABEL (label),
	                       _("_Networking"));
	gtk_widget_set_name (label, "label");
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "label", label,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 1), label);

	vbox12 = gtk_vbox_new ( FALSE, 8 );
	gtk_widget_set_name (vbox12, "vbox12");
	gtk_widget_ref (vbox12);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "vbox12", vbox12, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(vbox12);
	gtk_container_add ( GTK_CONTAINER (notebook1), vbox12 );
	gtk_container_set_border_width ( GTK_CONTAINER (vbox12), 6 );
	frame7 = gtk_frame_new (_("Run Program On Event"));
	gtk_widget_set_name (frame7, "frame7");
	gtk_widget_ref (frame7);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "frame7", frame7,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame7);
	gtk_box_pack_start (GTK_BOX (vbox12), frame7, FALSE, TRUE, 0);

	table4 = gtk_table_new( 11, 2, FALSE );
	gtk_widget_set_name (table4, "table4");
	gtk_widget_ref (table4);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "table4", table4,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table4);
	gtk_container_add (GTK_CONTAINER (frame7), table4);
	gtk_container_set_border_width (GTK_CONTAINER (table4), 6);

	toggle1 = gtk_check_button_new_with_label (_("Receive Message"));
	gtk_widget_set_name (toggle1, "prog_receive_message_button");
	gtk_widget_ref (toggle1);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), 
				  "prog_receive_message_button", toggle1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( toggle1 ), 
				     temp_toggles->program_on_receive_message );
	gtk_widget_show ( toggle1 );
	gtk_signal_connect (GTK_OBJECT (toggle1), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->program_on_receive_message );
	gtk_table_attach_defaults( GTK_TABLE(table4), toggle1, 0, 1, 0, 1);

	entry1 = gtk_entry_new ();
	ext_prog_receive_message = entry1;
	gtk_widget_set_name (entry1, "prog_receive_message_entry");
	gtk_widget_ref (entry1);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), 
				  "prog_receive_message_entry", 
				  entry1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	if ( programs->receive_message )
		gtk_entry_set_text( GTK_ENTRY( entry1 ), 
				    programs->receive_message);
	gtk_widget_show (entry1);
	gtk_table_attach_defaults ( GTK_TABLE(table4), 
				    entry1, 
				    1, 2, 0, 1);
	gtk_signal_connect( GTK_OBJECT( entry1 ), "changed",
	                    GTK_SIGNAL_FUNC( entry_changed ), NULL );

	toggle1 = gtk_check_button_new_with_label (_("Chat Request"));
	gtk_widget_set_name (toggle1, "prog_chat_request_button");
	gtk_widget_ref (toggle1);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), 
				  "prog_chat_request_button", toggle1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( toggle1 ), 
				     temp_toggles->program_on_chat_request );
	gtk_widget_show ( toggle1 );
	gtk_signal_connect (GTK_OBJECT (toggle1), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->program_on_chat_request );
	gtk_table_attach_defaults ( GTK_TABLE (table4), toggle1, 0, 1, 1, 2);

	entry1 = gtk_entry_new ();
	ext_prog_chat_request = entry1;
	gtk_widget_set_name (entry1, "prog_chat_request_entry");
	gtk_widget_ref (entry1);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), 
				  "prog_chat_request_entry", entry1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	if ( programs->chat_request )
		gtk_entry_set_text( GTK_ENTRY( entry1 ), 
				    programs->chat_request);
	gtk_widget_show (entry1);
	gtk_table_attach_defaults ( GTK_TABLE(table4), entry1, 
				    1, 2, 1, 2 );
	gtk_signal_connect( GTK_OBJECT( entry1 ), "changed",
	                    GTK_SIGNAL_FUNC( entry_changed ), NULL );

	toggle1 = gtk_check_button_new_with_label (_("Receive URL"));
	gtk_widget_set_name (toggle1, "prog_chat_receive_url");
	gtk_widget_ref (toggle1);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), 
				  "prog_chat_receive_url", toggle1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( toggle1 ), 
				     temp_toggles->program_on_receive_url );
	gtk_widget_show ( toggle1 );
	gtk_signal_connect (GTK_OBJECT (toggle1), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->program_on_receive_url );
	gtk_table_attach_defaults ( GTK_TABLE (table4), toggle1, 0, 1, 2, 3);

	entry1 = gtk_entry_new ();
	ext_prog_receive_url = entry1;
	gtk_widget_set_name (entry1, "prog_receive_url");
	gtk_widget_ref (entry1);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), 
				  "prog_receive_url",
				  entry1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	if ( programs->receive_url )
		gtk_entry_set_text( GTK_ENTRY( entry1 ), 
				    programs->receive_url);
	gtk_widget_show (entry1);
	gtk_table_attach_defaults ( GTK_TABLE(table4), entry1, 
				    1, 2, 2, 3 );
	gtk_signal_connect( GTK_OBJECT( entry1 ), "changed",
	                    GTK_SIGNAL_FUNC( entry_changed ), NULL );

	toggle1 = gtk_check_button_new_with_label (_("File Request"));
	gtk_widget_set_name (toggle1, "prog_file_request_button");
	gtk_widget_ref (toggle1);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), 
				  "prog_file_request_button", toggle1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( toggle1 ), 
				     temp_toggles->program_on_file_request );
	gtk_widget_show ( toggle1 );
	gtk_signal_connect (GTK_OBJECT (toggle1), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->program_on_file_request );
	gtk_table_attach_defaults( GTK_TABLE(table4), toggle1, 0, 1, 3, 4);

	entry1 = gtk_entry_new ();
	ext_prog_file_request = entry1;
	gtk_widget_set_name (entry1, "prog_file_request_entry");
	gtk_widget_ref (entry1);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), 
				  "prog_file_request_entry", 
				  entry1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	if ( programs->file_request )
		gtk_entry_set_text( GTK_ENTRY( entry1 ), 
				    programs->file_request);
	gtk_widget_show (entry1);
	gtk_table_attach_defaults ( GTK_TABLE(table4), 
				    entry1, 
				    1, 2, 3, 4);
	gtk_signal_connect( GTK_OBJECT( entry1 ), "changed",
	                    GTK_SIGNAL_FUNC( entry_changed ), NULL );

	toggle1 = gtk_check_button_new_with_label (_("User Online"));
	gtk_widget_set_name (toggle1, "prog_user_online_button");
	gtk_widget_ref (toggle1);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), 
				  "prog_user_online_button", toggle1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( toggle1 ), 
				     temp_toggles->program_on_user_online );
	gtk_widget_show ( toggle1 );
	gtk_signal_connect (GTK_OBJECT (toggle1), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->program_on_user_online );
	gtk_table_attach_defaults( GTK_TABLE(table4), toggle1, 0, 1, 4, 5);

	entry1 = gtk_entry_new ();
	ext_prog_user_online = entry1;
	gtk_widget_set_name (entry1, "prog_user_online_entry");
	gtk_widget_ref (entry1);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), 
				  "prog_user_online_entry", 
				  entry1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	if ( programs->user_online )
		gtk_entry_set_text( GTK_ENTRY( entry1 ), 
				    programs->user_online);
	gtk_widget_show (entry1);
	gtk_table_attach_defaults ( GTK_TABLE(table4), 
				    entry1, 
				    1, 2, 4, 5);
	gtk_signal_connect( GTK_OBJECT( entry1 ), "changed",
	                    GTK_SIGNAL_FUNC( entry_changed ), NULL );

	toggle1 = gtk_check_button_new_with_label (_("User Offline"));
	gtk_widget_set_name (toggle1, "prog_user_offline_button");
	gtk_widget_ref (toggle1);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), 
				  "prog_user_offline_button", toggle1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( toggle1 ), 
				     temp_toggles->program_on_user_offline );
	gtk_widget_show ( toggle1 );
	gtk_signal_connect (GTK_OBJECT (toggle1), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->program_on_user_offline );
	gtk_table_attach_defaults( GTK_TABLE(table4), toggle1, 0, 1, 5, 6);

	entry1 = gtk_entry_new ();
	ext_prog_user_offline = entry1;
	gtk_widget_set_name (entry1, "prog_user_offline_entry");
	gtk_widget_ref (entry1);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), 
				  "prog_user_offline_entry", 
				  entry1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	if ( programs->user_offline )
		gtk_entry_set_text( GTK_ENTRY( entry1 ), 
				    programs->user_offline);
	gtk_widget_show (entry1);
	gtk_table_attach_defaults ( GTK_TABLE(table4), 
				    entry1, 
				    1, 2, 5, 6);
	gtk_signal_connect( GTK_OBJECT( entry1 ), "changed",
	                    GTK_SIGNAL_FUNC( entry_changed ), NULL );

	toggle1 = gtk_check_button_new_with_label (_("Authorized By User"));
	gtk_widget_set_name (toggle1, "prog_auth_button");
	gtk_widget_ref (toggle1);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), 
				  "prog_auth_button", toggle1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( toggle1 ), 
				     temp_toggles->program_on_auth );
	gtk_widget_show ( toggle1 );
	gtk_signal_connect (GTK_OBJECT (toggle1), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->program_on_auth );
	gtk_table_attach_defaults( GTK_TABLE(table4), toggle1, 0, 1, 6, 7);

	entry1 = gtk_entry_new ();
	ext_prog_auth = entry1;
	gtk_widget_set_name (entry1, "prog_auth_entry");
	gtk_widget_ref (entry1);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), 
				  "prog_auth_entry", 
				  entry1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	if ( programs->auth )
		gtk_entry_set_text( GTK_ENTRY( entry1 ), 
				    programs->auth);
	gtk_widget_show (entry1);
	gtk_table_attach_defaults ( GTK_TABLE(table4), 
				    entry1, 
				    1, 2, 6, 7);
	gtk_signal_connect( GTK_OBJECT( entry1 ), "changed",
	                    GTK_SIGNAL_FUNC( entry_changed ), NULL );

	toggle1 = gtk_check_button_new_with_label (_("Authorization Request"));
	gtk_widget_set_name (toggle1, "prog_auth_request_button");
	gtk_widget_ref (toggle1);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), 
				  "prog_auth_request_button", toggle1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( toggle1 ), 
				     temp_toggles->program_on_auth_request );
	gtk_widget_show ( toggle1 );
	gtk_signal_connect (GTK_OBJECT (toggle1), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->program_on_auth_request );
	gtk_table_attach_defaults( GTK_TABLE(table4), toggle1, 0, 1, 7, 8);

	entry1 = gtk_entry_new ();
	ext_prog_auth_request = entry1;
	gtk_widget_set_name (entry1, "prog_auth_request_entry");
	gtk_widget_ref (entry1);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), 
				  "prog_auth_request_entry", 
				  entry1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	if ( programs->auth_request )
		gtk_entry_set_text( GTK_ENTRY( entry1 ), 
				    programs->auth_request);
	gtk_widget_show (entry1);
	gtk_table_attach_defaults ( GTK_TABLE(table4), 
				    entry1, 
				    1, 2, 7, 8);
	gtk_signal_connect( GTK_OBJECT( entry1 ), "changed",
	                    GTK_SIGNAL_FUNC( entry_changed ), NULL );

	toggle1 = gtk_check_button_new_with_label (_("Added to Users List"));
	gtk_widget_set_name (toggle1, "prog_list_add_button");
	gtk_widget_ref (toggle1);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), 
				  "prog_list_add_button", toggle1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( toggle1 ), 
				     temp_toggles->program_on_list_add );
	gtk_widget_show ( toggle1 );
	gtk_signal_connect (GTK_OBJECT (toggle1), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->program_on_list_add );
	gtk_table_attach_defaults( GTK_TABLE(table4), toggle1, 0, 1, 8, 9);

	entry1 = gtk_entry_new ();
	ext_prog_list_add = entry1;
	gtk_widget_set_name (entry1, "prog_list_add_entry");
	gtk_widget_ref (entry1);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), 
				  "prog_list_add_entry", 
				  entry1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	if ( programs->list_add )
		gtk_entry_set_text( GTK_ENTRY( entry1 ), 
				    programs->list_add);
	gtk_widget_show (entry1);
	gtk_table_attach_defaults ( GTK_TABLE(table4), 
				    entry1, 
				    1, 2, 8, 9);
	gtk_signal_connect( GTK_OBJECT( entry1 ), "changed",
	                    GTK_SIGNAL_FUNC( entry_changed ), NULL );

	toggle1 = gtk_check_button_new_with_label (_("Contact List"));
	gtk_widget_set_name (toggle1, "prog_contact_list_button");
	gtk_widget_ref (toggle1);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), 
				  "prog_contact_list_button", toggle1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( toggle1 ), 
				     temp_toggles->program_on_contact_list );
	gtk_widget_show ( toggle1 );
	gtk_signal_connect (GTK_OBJECT (toggle1), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->program_on_contact_list );
	gtk_table_attach_defaults( GTK_TABLE(table4), toggle1, 0, 1, 9, 10);

	entry1 = gtk_entry_new ();
	ext_prog_contact_list = entry1;
	gtk_widget_set_name (entry1, "prog_contact_list_entry");
	gtk_widget_ref (entry1);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), 
				  "prog_contact_list_entry", 
				  entry1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	if ( programs->contact_list )
		gtk_entry_set_text( GTK_ENTRY( entry1 ), 
				    programs->contact_list);
	gtk_widget_show (entry1);
	gtk_table_attach_defaults ( GTK_TABLE(table4), 
				    entry1, 
				    1, 2, 9, 10);
	gtk_signal_connect( GTK_OBJECT( entry1 ), "changed",
	                    GTK_SIGNAL_FUNC( entry_changed ), NULL );

   	label = gtk_label_new(_("Legend: %u: Uin, %n: Nick, %%: %"));
   	gtk_table_attach_defaults ( GTK_TABLE(table4),
				    label,
				    0, 2, 10, 11);
   	gtk_widget_show(label);


	/* Begin Away Message Page for Storing up to 10 Away Messages
	 */
	away_vbox = gtk_vbox_new(FALSE, 8);
	gtk_widget_set_name(away_vbox, "away_vbox");
	gtk_widget_ref(away_vbox);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options),
				  "away_vbox", away_vbox,
				  (GtkDestroyNotify)
				  gtk_widget_unref);
	gtk_widget_show(away_vbox);
	gtk_container_add ( GTK_CONTAINER (notebook1), away_vbox );
	gtk_container_set_border_width ( GTK_CONTAINER (away_vbox), 6 );
	away_frame = gtk_frame_new (_("Away Messages"));
	gtk_widget_set_name(away_frame, "away_frame");
	gtk_widget_ref(away_frame);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "away_frame", away_frame,
	                          (GtkDestroyNotify)
				  gtk_widget_unref);
	gtk_widget_show(away_frame);
	gtk_box_pack_start(GTK_BOX(away_vbox), away_frame, FALSE,
			   TRUE, 0);
	away_msg_table = gtk_table_new(10, 2, FALSE);
	gtk_widget_set_name(away_msg_table, "away_msg_table");
	gtk_widget_ref(away_msg_table);
	gtk_object_set_data_full(GTK_OBJECT(GnomeICU_Options),
				 "away_msg_table", away_msg_table,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(away_msg_table);
	gtk_container_add(GTK_CONTAINER(away_frame), away_msg_table);
	gtk_container_set_border_width(GTK_CONTAINER(away_msg_table),
				       6);
	/* If it's the first time, we have to set up our copy of the
	   away message list for the whole "change but don't apply
	   changes" fun */
	if (temp_away_msgs == NULL) { /* It's the 1st time */
	  temp_away_msgs = g_new(gchar*, AWAY_MSGS_NUM);
	  for (temp = 0; temp < AWAY_MSGS_NUM; temp++)
	    temp_away_msgs[temp] = NULL;
	}
	/* Now, we set up each away message (10 total) */
	for (temp = 0; temp < AWAY_MSGS_NUM; temp++) {
	  do_away_msgs(GnomeICU_Options, away_frame, away_msg_table,
		       temp);
	  g_free(temp_away_msgs[temp]);
	  temp_away_msgs[temp] = g_strdup(get_away_msg_from_list(temp));
	}
	/* End of Away Message Stuff */

	vbox9 = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox9, "vbox9");
	gtk_widget_ref (vbox9);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "vbox9", vbox9,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox9);
	gtk_container_add (GTK_CONTAINER (notebook1), vbox9);
	gtk_container_set_border_width (GTK_CONTAINER (vbox9), 6);	
	frame6 = gtk_frame_new (_("Miscellaneous"));
	gtk_widget_set_name (frame6, "frame6");
	gtk_widget_ref (frame6);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "frame6", frame6,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame6);
	gtk_box_pack_start (GTK_BOX (vbox9), frame6, FALSE, TRUE, 0);

	vbox10 = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (vbox10, "vbox10");
	gtk_widget_ref (vbox10);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "vbox10", vbox10,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox10);
	gtk_container_add (GTK_CONTAINER (frame6), vbox10);
	gtk_container_set_border_width (GTK_CONTAINER (vbox10), 6);

	webpresence_button = gtk_check_button_new_with_label (_("Allow others to see me on websites"));
	gtk_widget_set_name (webpresence_button, "webpresence_button");
	gtk_widget_ref (webpresence_button);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "webpresence_button", webpresence_button,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( webpresence_button ), temp_toggles->webpresence );
	gtk_widget_show (webpresence_button);
	gtk_box_pack_start (GTK_BOX (vbox10), webpresence_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (webpresence_button), TRUE);

	hbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_set_name (hbox2, "hbox2");
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "hbox2", hbox2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox10), hbox2, FALSE, FALSE, 0);

	autohide_button = gtk_check_button_new_with_label (_("Automatically hide main window after "));
	gtk_widget_set_name (autohide_button, "autohide_button");
	gtk_widget_ref (autohide_button);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "autohide_button", autohide_button,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( autohide_button ), temp_toggles->autohide );
	gtk_widget_show (autohide_button);
	gtk_box_pack_start (GTK_BOX (hbox2), autohide_button, FALSE, FALSE, 0);

	spin_button_adj = gtk_adjustment_new (temp_autohide_time, 0, 3600, 1, 10, 10);
	spin_button = gtk_spin_button_new (GTK_ADJUSTMENT (spin_button_adj), 1, 0);
	gtk_widget_set_name (spin_button, "spin_button");
	gtk_widget_ref (spin_button);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "spin_button", spin_button,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_set_sensitive ( spin_button, GTK_TOGGLE_BUTTON (autohide_button)->active);
	gtk_widget_show (spin_button);
	gtk_box_pack_start (GTK_BOX (hbox2), spin_button, FALSE, TRUE, 0);
	gtk_spin_button_set_update_policy (GTK_SPIN_BUTTON (spin_button), GTK_UPDATE_IF_VALID);

	label = gtk_label_new (_("secs"));
	gtk_widget_set_name (label, "label");
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "label", label,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX (hbox2), label, FALSE, FALSE, 0);

	frame29 = gtk_frame_new (_("User Information"));
	gtk_widget_set_name (frame29, "frame29");
	gtk_widget_ref (frame29);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "frame29", frame29,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame29);
	gtk_box_pack_start (GTK_BOX (vbox9), frame29, TRUE, TRUE, 0);

	table25 = gtk_table_new (3, 2, FALSE);
	gtk_widget_set_name (table25, "table25");
	gtk_widget_ref (table25);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "table25", table25,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table25);
	gtk_container_add (GTK_CONTAINER (frame29), table25);
	gtk_container_set_border_width (GTK_CONTAINER (table25), 6);
	gtk_table_set_row_spacings (GTK_TABLE (table25), 4);
	gtk_table_set_col_spacings (GTK_TABLE (table25), 4);

	uin = gtk_entry_new ();
	gtk_widget_set_name (uin, "uin");
	gtk_widget_ref (uin);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "uin", uin,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_entry_set_text( GTK_ENTRY( uin ), g_strdup_printf( "%u", our_info->uin ) );
	gtk_widget_show (uin);
	gtk_table_attach (GTK_TABLE (table25), uin, 1, 2, 0, 1,
	                  (GtkAttachOptions) (0),
	                  (GtkAttachOptions) (0), 0, 0);

	gtk_signal_connect( GTK_OBJECT( uin ), "changed",
	                    GTK_SIGNAL_FUNC( entry_changed ), NULL );

	nick = gtk_entry_new ();
	gtk_widget_set_name (nick, "nick");
	gtk_widget_ref (nick);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "nick", nick,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_entry_set_text( GTK_ENTRY( nick ), our_info->nick );
	gtk_widget_show (nick);
	gtk_table_attach (GTK_TABLE (table25), nick, 1, 2, 1, 2,
	                  (GtkAttachOptions) (0),
	                  (GtkAttachOptions) (0), 0, 0);

	gtk_signal_connect( GTK_OBJECT( nick ), "changed",
	                    GTK_SIGNAL_FUNC( entry_changed ), NULL );

	pass = gtk_entry_new ();
	gtk_widget_set_name (pass, "pass");
	gtk_widget_ref (pass);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "pass", pass,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_entry_set_text( GTK_ENTRY( pass ), passwd );
	gtk_entry_set_visibility( GTK_ENTRY( pass ), FALSE );
	gtk_widget_show (pass);
	gtk_table_attach (GTK_TABLE (table25), pass, 1, 2, 2, 3,
	                  (GtkAttachOptions) (0),
	                  (GtkAttachOptions) (0), 0, 0);

	gtk_signal_connect( GTK_OBJECT( pass ), "changed",
	                    GTK_SIGNAL_FUNC( entry_changed ), NULL );

	label = gtk_label_new (_("UIN:"));
	gtk_widget_set_name (label, "label");
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "label", label,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table25), label, 0, 1, 0, 1,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

	label = gtk_label_new (_("Nickname:"));
	gtk_widget_set_name (label, "label");
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "label", label,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table25), label, 0, 1, 1, 2,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

	label = gtk_label_new (_("Password:"));
	gtk_widget_set_name (label, "label");
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "label", label,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table25), label, 0, 1, 2, 3,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

	label = gtk_label_new ("");
	gtk_label_parse_uline (GTK_LABEL (label),
			       _("_External Programs"));
	gtk_widget_set_name (label, "label");
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "label", label,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 2), label);

	/* Add the Away Messages Label */
	label = gtk_label_new("");
	gtk_label_parse_uline(GTK_LABEL(label), _("_Away Messages"));
	gtk_widget_set_name(label, "label");
	gtk_widget_ref(label);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "label", label,
	                          (GtkDestroyNotify)
				  gtk_widget_unref);
	gtk_widget_show(label);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1),
				    gtk_notebook_get_nth_page
				    (GTK_NOTEBOOK (notebook1), 3),
				    label);
	/* End of the Away Messages Label */
	
	label = gtk_label_new ("");
	gtk_label_parse_uline (GTK_LABEL (label),
	                       _("_Miscellaneous"));
	gtk_widget_set_name (label, "label");
	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "label", label,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 4), label);

	gtk_signal_connect (GTK_OBJECT (GnomeICU_Options), "apply",
	                    GTK_SIGNAL_FUNC (apply_changes),
	                    NULL);
	gtk_signal_connect (GTK_OBJECT (picker_online), "color_set",
	                    GTK_SIGNAL_FUNC (color_set_online),
	                    NULL);
	gtk_signal_connect (GTK_OBJECT (picker_away), "color_set",
	                    GTK_SIGNAL_FUNC (color_set_away),
	                    NULL);
	gtk_signal_connect (GTK_OBJECT (picker_ffc), "color_set",
	                    GTK_SIGNAL_FUNC (color_set_ffc),
	                    NULL);
	gtk_signal_connect (GTK_OBJECT (picker_na), "color_set",
	                    GTK_SIGNAL_FUNC (color_set_na),
	                    NULL);
	gtk_signal_connect (GTK_OBJECT (picker_occ), "color_set",
	                    GTK_SIGNAL_FUNC (color_set_occ),
	                    NULL);
	gtk_signal_connect (GTK_OBJECT (picker_dnd), "color_set",
	                    GTK_SIGNAL_FUNC (color_set_dnd),
	                    NULL);
	gtk_signal_connect (GTK_OBJECT (picker_inv), "color_set",
	                    GTK_SIGNAL_FUNC (color_set_inv),
	                    NULL);
	gtk_signal_connect (GTK_OBJECT (picker_offline), "color_set",
	                    GTK_SIGNAL_FUNC (color_set_offline),
	                    NULL);
	gtk_signal_connect (GTK_OBJECT (sound_button), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->sound);
	gtk_signal_connect (GTK_OBJECT (beep_button), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->beep);
	gtk_signal_connect (GTK_OBJECT (showmain_button), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->show_window);
   	gtk_signal_connect (GTK_OBJECT(tooltip_button), "toggled",
			    GTK_SIGNAL_FUNC (toggle_switch),
			    &temp_toggles->hidetooltip);
	gtk_signal_connect (GTK_OBJECT( russian_button ), "toggled",
	                    GTK_SIGNAL_FUNC( toggle_switch ),
	                    &temp_toggles->russian);
	gtk_signal_connect (GTK_OBJECT (fullreply_button), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->full_reply);
	gtk_signal_connect (GTK_OBJECT (popup_button), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->auto_popup);
	gtk_signal_connect (GTK_OBJECT (dumpudp_button), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->packet_udp);
	gtk_signal_connect (GTK_OBJECT (dumptcp_button), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->packet_tcp);
	gtk_signal_connect (GTK_OBJECT (force_button), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->force);
	gtk_signal_connect (GTK_OBJECT (webpresence_button), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->webpresence);
	gtk_signal_connect (GTK_OBJECT (autohide_button), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->autohide);
	gtk_signal_connect (GTK_OBJECT (autohide_button), "toggled",
	                    GTK_SIGNAL_FUNC (set_sensitive),
	                    spin_button);
	gtk_signal_connect (GTK_OBJECT (spin_button_adj), "value_changed",
	                    GTK_SIGNAL_FUNC (spin_button_changed_cb),
	                    spin_button);
	gtk_signal_connect (GTK_OBJECT (spinbutton4_adj), "value_changed",
	                    GTK_SIGNAL_FUNC (spin_button4_changed_cb),
	                    spinbutton4);
	gtk_signal_connect (GTK_OBJECT (spinbutton5_adj), "value_changed",
	                    GTK_SIGNAL_FUNC (spin_button5_changed_cb),
	                    spinbutton5);

	gtk_widget_show_all( GnomeICU_Options );

	return;
}

/*** Local functions ***/
void apply_changes( GnomePropertyBox *box, gint page )
{
	if( page != -1 )
		return;

	save_changes( NULL, NULL );
	activate_changes( NULL, NULL );
}

void color_set_online(GnomeColorPicker *cp, guint pr, guint pg, guint pb ) 
{
	temp_color_online.red = pr;
	temp_color_online.green = pg;
	temp_color_online.blue = pb;
	gnome_property_box_changed( GNOME_PROPERTY_BOX( GnomeICU_Options ) );
}

void color_set_offline(GnomeColorPicker *cp, guint pr, guint pg, guint pb ) 
{
	temp_color_offline.red = pr;
	temp_color_offline.green = pg;
	temp_color_offline.blue = pb;
	gnome_property_box_changed( GNOME_PROPERTY_BOX( GnomeICU_Options ) );
}

void color_set_away(GnomeColorPicker *cp, guint pr, guint pg, guint pb ) 
{
	temp_color_away.red = pr;
	temp_color_away.green = pg;
	temp_color_away.blue = pb;
	gnome_property_box_changed( GNOME_PROPERTY_BOX( GnomeICU_Options ) );
}

void color_set_na(GnomeColorPicker *cp, guint pr, guint pg, guint pb ) 
{
	temp_color_na.red = pr;
	temp_color_na.green = pg;
	temp_color_na.blue = pb;
	gnome_property_box_changed( GNOME_PROPERTY_BOX( GnomeICU_Options ) );
}

void color_set_ffc(GnomeColorPicker *cp, guint pr, guint pg, guint pb ) 
{
	temp_color_ffc.red = pr;
	temp_color_ffc.green = pg;
	temp_color_ffc.blue = pb;
	gnome_property_box_changed( GNOME_PROPERTY_BOX( GnomeICU_Options ) );
}

void color_set_occ(GnomeColorPicker *cp, guint pr, guint pg, guint pb ) 
{
	temp_color_occ.red = pr;
	temp_color_occ.green = pg;
	temp_color_occ.blue = pb;
	gnome_property_box_changed( GNOME_PROPERTY_BOX( GnomeICU_Options ) );
}

void color_set_dnd(GnomeColorPicker *cp, guint pr, guint pg, guint pb ) 
{
	temp_color_dnd.red = pr;
	temp_color_dnd.green = pg;
	temp_color_dnd.blue = pb;
	gnome_property_box_changed( GNOME_PROPERTY_BOX( GnomeICU_Options ) );
}

void color_set_inv(GnomeColorPicker *cp, guint pr, guint pg, guint pb ) 
{
	temp_color_inv.red = pr;
	temp_color_inv.green = pg;
	temp_color_inv.blue = pb;
	gnome_property_box_changed( GNOME_PROPERTY_BOX( GnomeICU_Options ) );
}

void toggle_switch(GtkWidget *widget, gboolean *toggle_me)
{

#ifdef TRACE_FUNCTION
	g_print( "toggle_switch\n" );
#endif

	*toggle_me = !*toggle_me;
   
	gnome_property_box_changed( GNOME_PROPERTY_BOX( GnomeICU_Options ) );
}

void save_changes(GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "save_changes\n" );
#endif
	
	/* these will be written to file when the user exits gnomeicu
	 * since the rcfile is rewritten every time. Don't ask me why... */

	server = g_strdup(gtk_entry_get_text(GTK_ENTRY(icqserver)));
	remote_port = atoi(gtk_entry_get_text(GTK_ENTRY(portnumber)));

	our_info->uin = atoi(gtk_entry_get_text(GTK_ENTRY(uin)));

	g_free( our_info->nick );
	our_info->nick = g_strdup(gtk_entry_get_text(GTK_ENTRY(nick)));

	g_free(passwd);
	passwd = g_strdup(gtk_entry_get_text(GTK_ENTRY(pass)));

	/* external programs */
	g_free(programs->receive_message);
	programs->receive_message = g_strdup(gtk_entry_get_text(GTK_ENTRY(ext_prog_receive_message)));
	g_free(programs->chat_request);
	programs->chat_request = g_strdup(gtk_entry_get_text(GTK_ENTRY(ext_prog_chat_request)));
	g_free(programs->receive_url);
	programs->receive_url = g_strdup(gtk_entry_get_text(GTK_ENTRY(ext_prog_receive_url)));
	g_free(programs->file_request);
	programs->file_request = g_strdup(gtk_entry_get_text(GTK_ENTRY(ext_prog_file_request)));
	g_free(programs->user_online);
	programs->user_online = g_strdup(gtk_entry_get_text(GTK_ENTRY(ext_prog_user_online)));
	g_free(programs->user_offline);
	programs->user_offline = g_strdup(gtk_entry_get_text(GTK_ENTRY(ext_prog_user_offline)));
	g_free(programs->auth);
	programs->auth = g_strdup(gtk_entry_get_text(GTK_ENTRY(ext_prog_auth)));
	g_free(programs->auth_request);
	programs->auth_request = g_strdup(gtk_entry_get_text(GTK_ENTRY(ext_prog_auth_request)));
	g_free(programs->list_add);
	programs->list_add = g_strdup(gtk_entry_get_text(GTK_ENTRY(ext_prog_list_add)));
	g_free(programs->contact_list);
	programs->contact_list = g_strdup(gtk_entry_get_text(GTK_ENTRY(ext_prog_contact_list)));

	autohide_time = temp_autohide_time;
	min_tcp_port = temp_min_tcp_port;
	max_tcp_port = temp_max_tcp_port;

	if( toggles->webpresence != temp_toggles->webpresence )
	{
		icq_sendwebpresence();
		icq_change_status( Current_Status );
	}
	memcpy( toggles, temp_toggles, sizeof( _toggles ));

	memcpy( &color_online, &temp_color_online, sizeof( GdkColor ) );
	memcpy( &color_offline, &temp_color_offline, sizeof( GdkColor ) );
	memcpy( &color_away, &temp_color_away, sizeof( GdkColor ) );
	memcpy( &color_na, &temp_color_na, sizeof( GdkColor ) );
	memcpy( &color_ffc, &temp_color_ffc, sizeof( GdkColor ) );
	memcpy( &color_occ, &temp_color_occ, sizeof( GdkColor ) );
	memcpy( &color_dnd, &temp_color_dnd, sizeof( GdkColor ) );
	memcpy( &color_inv, &temp_color_inv, sizeof( GdkColor ) );

	/* This should apply the away messages and save them */
	apply_away_msgs_change(temp_away_msgs, AWAY_MSGS_NUM);
	/* End of apply away messages stuff */
	
   	if( toggles->applet ) applet_update( Current_Status, NULL );
   
	Build_Main_Window();
/*	Save_RC();*/
}

void activate_changes( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "activate_changes\n" );
#endif
	/* if the timeout is running, stop it */
	if ( autohide_timeout_tag ) {
		gtk_timeout_remove( autohide_timeout_tag );
		autohide_timeout_tag = 0;
	}

	if ( autohide_cbs_are_connected ) {
		gtk_signal_disconnect_by_func( GTK_OBJECT (app),
					       GTK_SIGNAL_FUNC (stop_autohide_timeout_cb), NULL);
		gtk_signal_disconnect_by_func( GTK_OBJECT (app),
					       GTK_SIGNAL_FUNC (start_autohide_timeout_cb), NULL);
		autohide_cbs_are_connected = FALSE;
	}

	if ( toggles->autohide ) {
		gtk_signal_connect( GTK_OBJECT (app), "focus_in_event",
				    GTK_SIGNAL_FUNC (stop_autohide_timeout_cb), NULL );
		gtk_signal_connect( GTK_OBJECT (app), "focus_out_event",
				    GTK_SIGNAL_FUNC (start_autohide_timeout_cb), NULL );
		gtk_signal_connect( GTK_OBJECT (app), "expose_event",
				    GTK_SIGNAL_FUNC (start_autohide_timeout_cb), NULL );
		gtk_signal_connect( GTK_OBJECT (app), "delete_event",
				    GTK_SIGNAL_FUNC (stop_autohide_timeout_cb), NULL );		
		autohide_cbs_are_connected = TRUE;
	} 
}

void set_sensitive (GtkWidget *master, GtkWidget *slave)
{
#ifdef TRACE_FUNCTION
	g_print( "set_sensitive\n" );
#endif
	gtk_widget_set_sensitive (slave, GTK_TOGGLE_BUTTON (master)->active);
}

void spin_button_changed_cb (GtkWidget *widget, GtkSpinButton *spinbutton)
{
#ifdef TRACE_FUNCTION
	g_print( "spin_button_changed_cb\n" );
#endif
	temp_autohide_time = gtk_spin_button_get_value_as_int (spinbutton);
	gnome_property_box_changed( GNOME_PROPERTY_BOX( GnomeICU_Options ) );
}

void spin_button4_changed_cb (GtkWidget *widget, GtkSpinButton *spinbutton)
{
#ifdef TRACE_FUNCTION
	g_print( "spin_button_changed_cb\n" );
#endif
	temp_min_tcp_port = gtk_spin_button_get_value_as_int (spinbutton);
	gnome_property_box_changed( GNOME_PROPERTY_BOX( GnomeICU_Options ) );
}

void spin_button5_changed_cb (GtkWidget *widget, GtkSpinButton *spinbutton)
{
#ifdef TRACE_FUNCTION
	g_print( "spin_button_changed_cb\n" );
#endif
	temp_max_tcp_port = gtk_spin_button_get_value_as_int (spinbutton);
	gnome_property_box_changed( GNOME_PROPERTY_BOX( GnomeICU_Options ) );
}

void entry_changed( GtkWidget *widget, gpointer data )
{
	gnome_property_box_changed( GNOME_PROPERTY_BOX( GnomeICU_Options ) );
}

gint Build_Main_Window( void )
{
	char statusbuf_editable[2][32];
	char *statusbuf[2];

	static GdkColor *black;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "Build_Main_Window\n" );
#endif

	statusbuf[0] = statusbuf_editable[0];
	statusbuf[1] = statusbuf_editable[1];

	gdk_color_alloc( gtk_widget_get_colormap( MainData->lb_userwin ), &color_online );
	gdk_color_alloc( gtk_widget_get_colormap( MainData->lb_userwin ), &color_offline );
	gdk_color_alloc( gtk_widget_get_colormap( MainData->lb_userwin ), &color_away );
	gdk_color_alloc( gtk_widget_get_colormap( MainData->lb_userwin ), &color_na );
	gdk_color_alloc( gtk_widget_get_colormap( MainData->lb_userwin ), &color_ffc );
	gdk_color_alloc( gtk_widget_get_colormap( MainData->lb_userwin ), &color_occ );
	gdk_color_alloc( gtk_widget_get_colormap( MainData->lb_userwin ), &color_dnd );
	gdk_color_alloc( gtk_widget_get_colormap( MainData->lb_userwin ), &color_inv );

	gtk_clist_freeze( GTK_CLIST( MainData->lb_userwin ) );

	contact = Contacts;

	while( contact != NULL )
	{
		if( ( ((CONTACT_PTR)contact->data)->status & 0xffff ) == STATUS_ONLINE )
		{
			gtk_clist_set_foreground( GTK_CLIST( MainData->lb_userwin_online ),
			                          ((CONTACT_PTR)contact->data)->lb_index, &color_online );
		}
		else if( ( ((CONTACT_PTR)contact->data)->status & 0xffff ) == STATUS_FREE_CHAT )
		{
			gtk_clist_set_foreground( GTK_CLIST( MainData->lb_userwin_online ),
			                          ((CONTACT_PTR)contact->data)->lb_index, &color_ffc );
		}
		else if( ( ((CONTACT_PTR)contact->data)->status & 0xffff ) == STATUS_AWAY )
		{
			gtk_clist_set_foreground( GTK_CLIST( MainData->lb_userwin_online ),
			                          ((CONTACT_PTR)contact->data)->lb_index, &color_away );
		}
		else if( ( ((CONTACT_PTR)contact->data)->status & 0xffff ) == STATUS_NA )
		{
			gtk_clist_set_foreground( GTK_CLIST( MainData->lb_userwin_online ),
						                 ((CONTACT_PTR)contact->data)->lb_index, &color_na );
		}
		else if( ( ((CONTACT_PTR)contact->data)->status & 0xffff ) == STATUS_OCCUPIED )
		{
			gtk_clist_set_foreground( GTK_CLIST( MainData->lb_userwin_online ),
						                 ((CONTACT_PTR)contact->data)->lb_index, &color_occ );
		}
		else if( ( ((CONTACT_PTR)contact->data)->status & 0xffff ) == STATUS_DND )
		{
			gtk_clist_set_foreground( GTK_CLIST( MainData->lb_userwin_online ),
						                 ((CONTACT_PTR)contact->data)->lb_index, &color_dnd );
		}
		else if( ( ((CONTACT_PTR)contact->data)->status & 0xffff ) == STATUS_INVISIBLE )
		{
			gtk_clist_set_foreground( GTK_CLIST( MainData->lb_userwin_online ),
						                 ((CONTACT_PTR)contact->data)->lb_index, &color_inv );
		}
		else
		{
			gtk_clist_set_foreground( GTK_CLIST( MainData->lb_userwin_offline ),
						                 ((CONTACT_PTR)contact->data)->lb_index, &color_offline );
		}
		contact = contact->next;
	}

	gtk_clist_thaw( GTK_CLIST( MainData->lb_userwin ) );

	g_free(black);

	return FALSE;
}

/* Part of awaymsglist.c
   David A. Hepkin
   do_away_msgs():
   Description: Creates a text entry box for the away message
   associated with num.
*/
void do_away_msgs(GtkWidget* main_window, GtkWidget*
		  away_frame, GtkWidget *away_msg_table, const int
		  num) {
      const gulong buf_len = 20;	/* Buffer length */
      GtkWidget* away_label; /* Numbers the Away messages */
      GtkWidget* away_msg;	/* Text field for the away msg */
      gchar label[buf_len];
  
      g_snprintf(label, buf_len, _("Away Message %d"), num+1);
      away_label = gtk_label_new(label);

  
      gtk_widget_ref(away_label);
      gtk_object_set_data_full(GTK_OBJECT(main_window),
			   "away_label", away_label,
			   (GtkDestroyNotify) gtk_widget_unref);
      gtk_widget_show(away_label);
      gtk_table_attach_defaults(GTK_TABLE(away_msg_table),
			    away_label, 0, 1, num, num+1);
  
  
      away_msg = gtk_entry_new();
      gtk_widget_set_name(away_msg, "away_msg");
      gtk_widget_ref(away_msg);
      gtk_object_set_data_full(GTK_OBJECT(main_window),
			   "away_msg", away_msg,
			   (GtkDestroyNotify) gtk_widget_unref);

		if( get_away_msg_from_list( num ) != NULL )
			gtk_entry_set_text(GTK_ENTRY(away_msg), get_away_msg_from_list(num));
  
      gtk_widget_show(away_msg);
      gtk_table_attach_defaults(GTK_TABLE(away_msg_table), away_msg, 1,
			    2, num, num+1);
      gtk_signal_connect(GTK_OBJECT(away_msg), "changed",
		     GTK_SIGNAL_FUNC(get_away_msg),
		     GINT_TO_POINTER(num)); 
      gtk_signal_connect(GTK_OBJECT(away_msg), "changed",
		     GTK_SIGNAL_FUNC(entry_changed), NULL); 
}

/* Part of awaymsglist.c
   David A. Hepkin
   get_away_msg():
   Description: Gets a changed/new away message from the associated
   text entry.  Saves the away message in the temp_away_msgs temporary
   list, so the changes can be "applied" later.
*/
void get_away_msg(GtkWidget *away_msg, gpointer data) {
      gint index;
      index = GPOINTER_TO_INT(data);
      if (index >= AWAY_MSGS_NUM || index < 0)
              return;
      g_free(temp_away_msgs[index]);
      temp_away_msgs[index] =
         g_strdup(gtk_entry_get_text(GTK_ENTRY(away_msg)));
}
