/* $Id: gnomeicu-client.c,v 1.6 2000/05/01 02:19:27 jwise Exp $ */

#include "common.h"
#include <fcntl.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <stdarg.h>
#include <errno.h>
#include <unistd.h>
#include <netinet/in.h>
#include <pwd.h>


int socket_fd;

int connectme( gchar *uinstr );
void usage( void );

int main(int ac,char **av)
{
	gchar c = 1;
	unsigned long u;
	gchar *buffer;
	gint i;
	gchar *uinstr = NULL;
	gint readv = 0;

	if( ac <= 1 || !strcmp( av[1], "-h" ) || !strcmp( av[1], "--help" ) )
		usage();

	buffer = g_malloc0( 8192 );

	for(i=1;i<ac;i++) {
		if(!strcmp(av[i],"-u"))
		{
			i++;
			if(i == ac)
				usage();
			uinstr = av[i++];
			if(i == ac)
				break;
		}
		if(!strcmp(av[i], "readmsg"))
		{
			readv = i;
			c = 0;
		}
		strcat(buffer,av[i]);
		strcat(buffer," ");
	}

	buffer[strlen(buffer)-1]=0;

	if ( uinstr != NULL && atol(uinstr)==0 )
	{
		printf("UIN must be a number.\n");
		return(1);
	}

	if (connectme(uinstr)) {
		printf("Unable to connect to running GnomeICU client.\n");
		return(1);
	}

	u=htonl(strlen(buffer)+1);

	write(socket_fd,&c,1);
	write(socket_fd,&u,sizeof(unsigned long));
	write(socket_fd,buffer,strlen(buffer)+1);

	g_free( buffer );

	if( readv && !strcmp(av[readv], "readmsg" ) )
	{
		read(socket_fd,&u,sizeof(unsigned long));
		u = g_ntohl( u );
		if( u < 16384 )
		{
			buffer = g_malloc0( u );
			read(socket_fd,buffer,u);
			g_print( buffer );
			g_print( "\n\n" );
			g_free( buffer );
		}
	}

	close(socket_fd);
	return(0);
}

int connectme( gchar *uinstr )
{
	struct sockaddr_un addr;
	gchar *user;
	struct passwd *pw;

	pw = getpwuid(getuid());

	if (!pw) {
		fprintf(stderr,"Unable to get current login name, naming service down?\n");
		return(-1);
	}

	user = g_strdup( pw->pw_name );

	if (!user) {
	  fprintf(stderr,"No memory to duplicate username.\n");
	  return(-1);
	}

	sprintf(addr.sun_path, "/tmp/.gnomeicu-%s/ctl%s%s",
	        user,
	        (uinstr == NULL) ? "" : "-",
	        (uinstr == NULL) ? "" : uinstr );

	addr.sun_family = AF_UNIX;

	if(access(addr.sun_path, R_OK) != 0)
		return 1;

	socket_fd = socket(AF_UNIX, SOCK_STREAM, 0);

	if(socket_fd >= 0) {

		if(connect(socket_fd, (struct sockaddr *)&addr,
				 sizeof(addr.sun_family) + strlen(addr.sun_path) + 1) == 0)
			{
	return 0;
			}
		else
			return 1;
	}
	else
		perror ("socket");
	return -1;
}

void usage( void )
{
	g_print( "Usage: gnomeicu-client [-u YourUIN] command [DestinationUIN] [Data]\n\n" );
	g_print( "Commands are as follows:\n" );
	g_print( "quit\t\t\tClose GnomeICU\n" );
	g_print( "away \"Away String\"\tSet Away message string\n" );
	g_print( "useradd 4664755\tAdd user with uin 12345 to list\n" );
	g_print( "msg 4664755 \"message\"\tSend message to uin 12345\n" );
	g_print( "status [sts]\t\tSet status as specified\n" );
	g_print( "   where [sts] is one of:  online offline away na invisible\n" );
	g_print( "                           freechat occupied dnd\n" );
	exit(1);
}
