
/*********************************************************************
 *	full_duplex.c - exercises interface of an OSS sound driver
 *			in full duplex mode. 
 *	Copyright (C) 2000 Rui Sousa 
 ********************************************************************* 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 ********************************************************************* 
*/

#include<stdio.h>
#include<math.h>
#include<unistd.h>
#include "common.h"

int main()
{
	int audio_fd;
	unsigned char indevbuf[BUF_SIZE];
	unsigned char outdevbuf[BUF_SIZE];
	struct wave lwave, rwave;
	int ret, val;
	mode_t mode;
	fd_set set;

	mode = O_RDWR | O_NONBLOCK;
	audio_fd = setup("/dev/dsp", mode);

	lwave.w = 2.0 * M_PI * FREQL / SPEED;
	rwave.w = 2.0 * M_PI * FREQR / SPEED;

	lwave.t0 = 0.0;
	rwave.t0 = 0.0;

	FD_ZERO(&set);
	FD_SET(audio_fd, &set);

	fill_devbuf(&rwave, &lwave, outdevbuf);

	while (1) {

		if (DEBUG)
			print_info(audio_fd, mode);

		select(FD_SETSIZE, &set, &set, NULL, NULL);

		val = BUF_SIZE;

		if ((ret = write(audio_fd, outdevbuf, val)) == -1)
			perror("audio write");

		if (DEBUG)
			printf("(write)\ncount: %d ret: %d\n\n", val, ret);

		fill_devbuf(&rwave, &lwave, outdevbuf);

		val = BUF_SIZE;

		if ((ret = read(audio_fd, indevbuf, val)) == -1)
			perror("audio read");

		if (DEBUG)
			printf("(read)\ncount: %d ret: %d\n\n", val, ret);

	}

	close(audio_fd);

	return 0;
}
