/* Copyright (C) 1991, 1992 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <ibcs/unistd.h>

	.text
	.globl	_getegid
	.align	4
/*
 * Fetch the effective group ID
 */
_getegid:
	pushl	%ebx
/*
 * Fetch the effective group from the kernel
 */
	movl	$ __IBCS_getegid , %eax
	.byte	0x9a, 0, 0, 0, 0, 7, 0
/*
 * The effective group ID is in the EDX register.
 */
	movl	%edx,%eax
	popl	%ebx
	ret


#ifdef ELF_LIBRARY
	.type _getegid,@function
	.weak getegid
	getegid = _getegid
#endif
