#ifndef __TRACE_H_DEFINED
#define __TRACE_H_DEFINED

#ifdef __TRACE_LIB
void func_entry (char *file, int line, char *func_name);
void func_exit  (char *file, int line, char *func_name);
void trace_hex  (char *file, int line, char *symbol, unsigned long ulValue);

#define FUNC_ENTRY(name)      func_entry (__FILE__, __LINE__, name)
#define FUNC_EXIT(name)       func_exit  (__FILE__, __LINE__, name)
#define TRACE_HEX(sym)        trace_hex  (__FILE__, __LINE__, #sym, (unsigned long) sym)
#else
#define FUNC_ENTRY(name)
#define FUNC_EXIT(name)
#define TRACE_HEX(sym)
#endif
#endif
