#ifdef linux
#include <getopt.h>
#else
#include <stdlib.h>
#endif

#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>

#include "linuxelf.h"

#define ELF32_R_SYM(x) ((x) >> 8)
#define ELF32_R_TYPE(x) ((x) & 0xff)
char *header=NULL;
int header_size=0;
unsigned int dynamic_addr;
unsigned int dynamic_size;
char * pint = "";

int dynamic_info[24];

unsigned int rel_size;
int loadaddr = -1;

unsigned int rela_addr;
unsigned int rela_size;

struct dynamic * dpnt;
struct Elf32_Rel * rpnt;

struct Elf32_Sym * symtab;
char * strtab;
int symtab_index;

FILE * infile;

struct elf_shdr * elf_sections;

#define SECTION_NAME(X) (&header[lastmapped+(X)->sh_name])

char dump_sects[100] = {0,};

struct Elf32_Syms * readsyms(char * filename){
  int section;
  struct elfhdr * epnt;
  struct elf_phdr * ppnt;
  struct elf_shdr * spnt, *symsec;
  int lastmapped;
  char * cp;
  int i, j;
  char c;
  int symbol_index;
  struct stat statbuf;
  struct Elf32_Sym * symbol_table;

  printf("Reading symbol table for image %s...\n", filename );
  infile = fopen(filename, "r");
  if (!infile){
    printf("Input file %s not found.\n",filename);
    exit(1);
  };
  fstat(fileno(infile),&statbuf);
  if (statbuf.st_size > header_size) {
    header = (char*)realloc(header, statbuf.st_size);
    header_size = statbuf.st_size;
  }
  memset(header,0,4096);
  fread(header, statbuf.st_size, 1, infile);
  epnt = (struct elfhdr *) header;
  if (epnt->e_ident[0] != 0x7f || strncmp(&epnt->e_ident[1], "ELF",3)){
    printf("%s is not an ELF file\n",filename);
    exit(1);
  };
  dynamic_addr = 0;
  
  ppnt = (struct elf_phdr *) &header[epnt->e_phoff];
  for(i=0;i < epnt->e_phnum; i++){
    if(loadaddr == -1 && ppnt->p_vaddr != 0) 
      loadaddr = (ppnt->p_vaddr & 0xfffff000) - (ppnt->p_offset & 0xfffff000);      
    if(ppnt->p_type == 2) {
      if(dynamic_addr) fprintf(stderr,"Error - more than one dynamic section");
      dynamic_addr = ppnt->p_offset;
      dynamic_size = ppnt->p_filesz;
    };
    ppnt++;
  };
    
    dpnt = (struct dynamic *) &header[dynamic_addr];
    dynamic_size = dynamic_size / sizeof(struct dynamic);
    for(i=0; i< dynamic_size; i++){
      if(dpnt->d_tag < 0 || dpnt->d_tag > 24) {
	      fprintf(stderr, "Invalid dynamic tag 0x%x 0x%x\n", dpnt->d_tag, dpnt->d_un.d_ptr);
      } else {
	      dynamic_info[dpnt->d_tag] = dpnt->d_un.d_val;
      }
      dpnt++;
    };
    
    if(dynamic_info[DT_SYMTAB]) {
      symtab =  (struct Elf32_Sym *) (header - loadaddr + dynamic_info[DT_SYMTAB]);
      strtab = (char *) (header - loadaddr + dynamic_info[DT_STRTAB]);
    }

    elf_sections = spnt = (struct elf_shdr *) &header[epnt->e_shoff];
    spnt += epnt->e_shstrndx;
    lastmapped = spnt->sh_offset;
  
    /* Now dump the symbol table */
      if (dynamic_info[DT_HASH])  {
	int nbucket, nchain, *elf_buckets, *chains;
	int hn, si;
	char * pnt;
	int * hash_addr = (unsigned int *) (dynamic_info[DT_HASH] + header - loadaddr);
	nbucket = *hash_addr++;
	nchain = *hash_addr++;
	symbol_table = (struct Elf32_Sym *) malloc(sizeof(struct Elf32_Sym) * (nchain + 1));
	memset(symbol_table, 0, sizeof(struct Elf32_Sym) * (nchain+1));
	symbol_index = 0;
	elf_buckets = hash_addr;
	hash_addr += nbucket;
	chains = hash_addr;
	for(hn = 0; hn < nbucket; hn++) {
	  if(!elf_buckets[hn]) continue;
	  for(si = elf_buckets[hn]; si; si = chains[si]) {
	    symbol_table[symbol_index] = symtab[si];
	    symbol_table[symbol_index].st_name = strdup(strtab + symtab[si].st_name);
	    symbol_index++;
	  }
	}
      }
  fclose(infile);
  return symbol_table;
}
