/*********************************************************************
 *      compiler.h - some defines for dsp registers
 *      Copyright (C) 2000 Rui Sousa 
 ********************************************************************* 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 ********************************************************************* 
*/

#ifndef _COMPILER_H
#define COMPILER_H

#define DSP_CODE_SIZE 1024

int dsp_code[DSP_CODE_SIZE];

//int ip=0;

/* nicer names */

#define SPDIF_L IN_L(1)
#define SPDIF_R IN_R(1)

#define REAR_L OUT_L(4)
#define REAR_R OUT_R(4)

/* constants */

#define C_0     0x040
#define C_1     0x041
#define C_2     0x042
#define C_4     0x043
#define C_8     0x044
#define C_16    0x045
#define C_32    0x046

/* accumulator */

#define ACCUM    0x056

#endif
void OP(int op, int y,int x,int w,int z);
void RESET(void);
void illegal(const char *message);
