/*
    libparted - a library for manipulating disk partitions
    Copyright (C) 1998-2000  Andrew Clausen, Lennert Buytenhek and Red Hat Inc.

	Andrew Clausen			<clausen@alphalink.com.au>
	Lennert Buytenhek		<buytenh@scotty.dsv.nl>
	Matt Wilson, Red Hat Inc.	<msw@redhat.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef PED_DEBUG_H_INCLUDED
#define PED_DEBUG_H_INCLUDED

#ifdef DEBUG

#ifdef __GNUC__

#define PED_ASSERT(cond, action)				\
	if (!ped_assert (cond,					\
			 #cond,					\
			 __FILE__,				\
			 __LINE__,				\
			 __PRETTY_FUNCTION__))			\
	{							\
		action;						\
	}

#else /* !__GNUC__ */

#define PED_ASSERT(cond, action)				\
	if (!ped_assert (cond,					\
			 #cond,					\
			 "unknown",				\
			 0,					\
			 "unknown"))				\
	{							\
		action;						\
	}


#endif /* __GNUC__ */

#else /* !DEBUG */

#define PED_ASSERT(cond, action)

#endif /* DEBUG */

extern int
ped_assert (int cond, char* cond_text, char* file, int line, char* function);

#endif /* PED_DEBUG_H_INCLUDED */

