/* this file was generated by the MCOP idl compiler - DO NOT EDIT */

#ifndef ARTSFLOW_H
#define ARTSFLOW_H

#include "common.h"

enum PortDirection {input = 0, output = 1};
enum PortDataType {audio_data = 0, string_data = 1};
enum PortConnType {conn_stream = 0, conn_event = 1, conn_property = 2};
enum AutoSuspendState {asNoSuspend = 0, asSuspend = 1, asSuspendStop = 2};
class PortType : public Type {
public:
	PortType();
	PortType(PortDirection Direction, PortDataType DataType, PortConnType ConnType, bool isMultiPort);
	PortType(Buffer& stream);
	PortType(const PortType& copyType);
	PortType& operator=(const PortType& assignType);
	virtual ~PortType();

	PortDirection Direction;
	PortDataType DataType;
	PortConnType ConnType;
	bool isMultiPort;

// marshalling functions
	void readType(Buffer& stream);
	void writeType(Buffer& stream) const;
};

class PortDesc : public Type {
public:
	PortDesc();
	PortDesc(long ID, const std::string& Name, const PortType& Type, bool isConnected, bool hasValue, const std::vector<long>& ConnectedIDs, float FloatValue, const std::string& StringValue);
	PortDesc(Buffer& stream);
	PortDesc(const PortDesc& copyType);
	PortDesc& operator=(const PortDesc& assignType);
	virtual ~PortDesc();

	long ID;
	std::string Name;
	PortType Type;
	bool isConnected;
	bool hasValue;
	std::vector<long> ConnectedIDs;
	float FloatValue;
	std::string StringValue;

// marshalling functions
	void readType(Buffer& stream);
	void writeType(Buffer& stream) const;
};

class ModuleDesc : public Type {
public:
	ModuleDesc();
	ModuleDesc(long ID, const std::string& Name, const std::vector<PortDesc *>& Ports, long X, long Y, long Width, long Height, bool isInterface, bool isStructure);
	ModuleDesc(Buffer& stream);
	ModuleDesc(const ModuleDesc& copyType);
	ModuleDesc& operator=(const ModuleDesc& assignType);
	virtual ~ModuleDesc();

	long ID;
	std::string Name;
	std::vector<PortDesc *> Ports;
	long X;
	long Y;
	long Width;
	long Height;
	bool isInterface;
	bool isStructure;

// marshalling functions
	void readType(Buffer& stream);
	void writeType(Buffer& stream) const;
};

class StructureDesc : public Type {
public:
	StructureDesc();
	StructureDesc(long Width, long Height, const std::vector<ModuleDesc *>& Modules, const std::string& Name, bool containsStructures);
	StructureDesc(Buffer& stream);
	StructureDesc(const StructureDesc& copyType);
	StructureDesc& operator=(const StructureDesc& assignType);
	virtual ~StructureDesc();

	long Width;
	long Height;
	std::vector<ModuleDesc *> Modules;
	std::string Name;
	bool containsStructures;

// marshalling functions
	void readType(Buffer& stream);
	void writeType(Buffer& stream) const;
};

class ArtsServer;
class ExecutionManager;
class SynthModule;
class Synth_PLAY;
class Synth_FREQUENCY;
class Synth_WAVE_SIN;
class Synth_MULTI_ADD;
class Synth_ADD;
class Synth_MUL;
class Synth_PLAY_WAV;
class ByteStreamToAudio;
class StereoEffect;
class StereoVolumeControl;
class StereoFFTScope;
class StereoEffectStack;

class ArtsServer_base : virtual public Object_base {
public:
	static unsigned long _IID; // interface ID

	static ArtsServer_base *_create(const std::string& subClass = "ArtsServer");
	static ArtsServer_base *_fromString(std::string objectref);
	static ArtsServer_base *_fromReference(ObjectReference ref, bool needcopy);

	inline ArtsServer_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual vector<std::string> _defaultPortsIn() const;
	virtual vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long createModules() = 0;
	virtual bool createModule(long mid, const ModuleDesc& desc) = 0;
	virtual bool localConnectModules(long mid) = 0;
	virtual bool finalizeModules(long mid) = 0;
	virtual void startModules(long mid) = 0;
	virtual void deleteModules(long mid) = 0;
};

class ArtsServer_stub : virtual public ArtsServer_base, virtual public Object_stub {
protected:
	ArtsServer_stub();

public:
	ArtsServer_stub(Connection *connection, long objectID);

	long createModules();
	bool createModule(long mid, const ModuleDesc& desc);
	bool localConnectModules(long mid);
	bool finalizeModules(long mid);
	void startModules(long mid);
	void deleteModules(long mid);
};

class ArtsServer_skel : virtual public ArtsServer_base, virtual public Object_skel {
public:
	ArtsServer_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	void _buildMethodTable();
	void dispatch(Buffer *request, Buffer *result,long methodID);
};

#include "reference.h"

class ArtsServer : public SmartWrapper {
private:
	static Object_base* _Creator();
	ArtsServer_base *_cache;
	inline ArtsServer_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(ArtsServer_base *)_pool->base->_cast(ArtsServer_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

public:
	inline ArtsServer() : SmartWrapper(_Creator), _cache(0) {}
	inline ArtsServer(const SubClass& s) :
		SmartWrapper(ArtsServer_base::_create(s.string())), _cache(0) {}
	inline ArtsServer(const Reference &r) :
		SmartWrapper(r.isString()?(ArtsServer_base::_fromString(r.string())):(ArtsServer_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline ArtsServer(ArtsServer_base* b) : SmartWrapper(b), _cache(0) {}
	inline ArtsServer(const ArtsServer& target) : SmartWrapper(target._pool), _cache(target._cache) {}
	inline ArtsServer(SmartWrapper::Pool& p) : SmartWrapper(p), _cache(0) {}
	inline ArtsServer& operator=(const ArtsServer& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Object() const { return Object(*_pool); }
	inline ArtsServer_base* _base() {return _cache?_cache:_method_call();}

	inline long createModules() {return _cache?_cache->createModules():_method_call()->createModules();}
	inline bool createModule(long mid, const ModuleDesc& desc) {return _cache?_cache->createModule(mid, desc):_method_call()->createModule(mid, desc);}
	inline bool localConnectModules(long mid) {return _cache?_cache->localConnectModules(mid):_method_call()->localConnectModules(mid);}
	inline bool finalizeModules(long mid) {return _cache?_cache->finalizeModules(mid):_method_call()->finalizeModules(mid);}
	inline void startModules(long mid) {return _cache?_cache->startModules(mid):_method_call()->startModules(mid);}
	inline void deleteModules(long mid) {return _cache?_cache->deleteModules(mid):_method_call()->deleteModules(mid);}
};

class ExecutionManager_base : virtual public Object_base {
public:
	static unsigned long _IID; // interface ID

	static ExecutionManager_base *_create(const std::string& subClass = "ExecutionManager");
	static ExecutionManager_base *_fromString(std::string objectref);
	static ExecutionManager_base *_fromReference(ObjectReference ref, bool needcopy);

	inline ExecutionManager_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual vector<std::string> _defaultPortsIn() const;
	virtual vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual StructureDesc* expandStructureDesc(const StructureDesc& structuredesc) = 0;
	virtual long createStructure(const StructureDesc& structuredesc) = 0;
	virtual bool isExecuting(long id) = 0;
	virtual bool freeStructure(long id) = 0;
	virtual void forceTermination() = 0;
};

class ExecutionManager_stub : virtual public ExecutionManager_base, virtual public Object_stub {
protected:
	ExecutionManager_stub();

public:
	ExecutionManager_stub(Connection *connection, long objectID);

	StructureDesc* expandStructureDesc(const StructureDesc& structuredesc);
	long createStructure(const StructureDesc& structuredesc);
	bool isExecuting(long id);
	bool freeStructure(long id);
	void forceTermination();
};

class ExecutionManager_skel : virtual public ExecutionManager_base, virtual public Object_skel {
public:
	ExecutionManager_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	void _buildMethodTable();
	void dispatch(Buffer *request, Buffer *result,long methodID);
};

#include "reference.h"

class ExecutionManager : public SmartWrapper {
private:
	static Object_base* _Creator();
	ExecutionManager_base *_cache;
	inline ExecutionManager_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(ExecutionManager_base *)_pool->base->_cast(ExecutionManager_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

public:
	inline ExecutionManager() : SmartWrapper(_Creator), _cache(0) {}
	inline ExecutionManager(const SubClass& s) :
		SmartWrapper(ExecutionManager_base::_create(s.string())), _cache(0) {}
	inline ExecutionManager(const Reference &r) :
		SmartWrapper(r.isString()?(ExecutionManager_base::_fromString(r.string())):(ExecutionManager_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline ExecutionManager(ExecutionManager_base* b) : SmartWrapper(b), _cache(0) {}
	inline ExecutionManager(const ExecutionManager& target) : SmartWrapper(target._pool), _cache(target._cache) {}
	inline ExecutionManager(SmartWrapper::Pool& p) : SmartWrapper(p), _cache(0) {}
	inline ExecutionManager& operator=(const ExecutionManager& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Object() const { return Object(*_pool); }
	inline ExecutionManager_base* _base() {return _cache?_cache:_method_call();}

	inline StructureDesc* expandStructureDesc(const StructureDesc& structuredesc) {return _cache?_cache->expandStructureDesc(structuredesc):_method_call()->expandStructureDesc(structuredesc);}
	inline long createStructure(const StructureDesc& structuredesc) {return _cache?_cache->createStructure(structuredesc):_method_call()->createStructure(structuredesc);}
	inline bool isExecuting(long id) {return _cache?_cache->isExecuting(id):_method_call()->isExecuting(id);}
	inline bool freeStructure(long id) {return _cache?_cache->freeStructure(id):_method_call()->freeStructure(id);}
	inline void forceTermination() {return _cache?_cache->forceTermination():_method_call()->forceTermination();}
};

class SynthModule_base : virtual public Object_base {
public:
	static unsigned long _IID; // interface ID

	static SynthModule_base *_create(const std::string& subClass = "SynthModule");
	static SynthModule_base *_fromString(std::string objectref);
	static SynthModule_base *_fromReference(ObjectReference ref, bool needcopy);

	inline SynthModule_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual vector<std::string> _defaultPortsIn() const;
	virtual vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual AutoSuspendState autoSuspend() = 0;
	virtual void start() = 0;
	virtual void stop() = 0;
	virtual void streamInit() = 0;
	virtual void streamStart() = 0;
	virtual void streamEnd() = 0;
};

class SynthModule_stub : virtual public SynthModule_base, virtual public Object_stub {
protected:
	SynthModule_stub();

public:
	SynthModule_stub(Connection *connection, long objectID);

	AutoSuspendState autoSuspend();
	void start();
	void stop();
	void streamInit();
	void streamStart();
	void streamEnd();
};

class SynthModule_skel : virtual public SynthModule_base, virtual public Object_skel {
public:
	SynthModule_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	void _buildMethodTable();
	void dispatch(Buffer *request, Buffer *result,long methodID);
};

#include "reference.h"

class SynthModule : public SmartWrapper {
private:
	static Object_base* _Creator();
	SynthModule_base *_cache;
	inline SynthModule_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(SynthModule_base *)_pool->base->_cast(SynthModule_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

public:
	inline SynthModule() : SmartWrapper(_Creator), _cache(0) {}
	inline SynthModule(const SubClass& s) :
		SmartWrapper(SynthModule_base::_create(s.string())), _cache(0) {}
	inline SynthModule(const Reference &r) :
		SmartWrapper(r.isString()?(SynthModule_base::_fromString(r.string())):(SynthModule_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline SynthModule(SynthModule_base* b) : SmartWrapper(b), _cache(0) {}
	inline SynthModule(const SynthModule& target) : SmartWrapper(target._pool), _cache(target._cache) {}
	inline SynthModule(SmartWrapper::Pool& p) : SmartWrapper(p), _cache(0) {}
	inline SynthModule& operator=(const SynthModule& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Object() const { return Object(*_pool); }
	inline SynthModule_base* _base() {return _cache?_cache:_method_call();}

	inline AutoSuspendState autoSuspend() {return _cache?_cache->autoSuspend():_method_call()->autoSuspend();}
	inline void start() {return _cache?_cache->start():_method_call()->start();}
	inline void stop() {return _cache?_cache->stop():_method_call()->stop();}
	inline void streamInit() {return _cache?_cache->streamInit():_method_call()->streamInit();}
	inline void streamStart() {return _cache?_cache->streamStart():_method_call()->streamStart();}
	inline void streamEnd() {return _cache?_cache->streamEnd():_method_call()->streamEnd();}
};

class Synth_PLAY_base : virtual public SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_PLAY_base *_create(const std::string& subClass = "Synth_PLAY");
	static Synth_PLAY_base *_fromString(std::string objectref);
	static Synth_PLAY_base *_fromReference(ObjectReference ref, bool needcopy);

	inline Synth_PLAY_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual vector<std::string> _defaultPortsIn() const;
	virtual vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_PLAY_stub : virtual public Synth_PLAY_base, virtual public SynthModule_stub {
protected:
	Synth_PLAY_stub();

public:
	Synth_PLAY_stub(Connection *connection, long objectID);

};

class Synth_PLAY_skel : virtual public Synth_PLAY_base, virtual public SynthModule_skel {
protected:
	// variables for streams
	float *invalue_left;                      // incoming stream
	float *invalue_right;                     // incoming stream

public:
	Synth_PLAY_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	void _buildMethodTable();
	void dispatch(Buffer *request, Buffer *result,long methodID);
};

#include "reference.h"
#include "flowsystem.h"

class Synth_PLAY : public SmartWrapper {
private:
	static Object_base* _Creator();
	Synth_PLAY_base *_cache;
	inline Synth_PLAY_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_PLAY_base *)_pool->base->_cast(Synth_PLAY_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

public:
	inline Synth_PLAY() : SmartWrapper(_Creator), _cache(0) {}
	inline Synth_PLAY(const SubClass& s) :
		SmartWrapper(Synth_PLAY_base::_create(s.string())), _cache(0) {}
	inline Synth_PLAY(const Reference &r) :
		SmartWrapper(r.isString()?(Synth_PLAY_base::_fromString(r.string())):(Synth_PLAY_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_PLAY(Synth_PLAY_base* b) : SmartWrapper(b), _cache(0) {}
	inline Synth_PLAY(const Synth_PLAY& target) : SmartWrapper(target._pool), _cache(target._cache) {}
	inline Synth_PLAY(SmartWrapper::Pool& p) : SmartWrapper(p), _cache(0) {}
	inline Synth_PLAY& operator=(const Synth_PLAY& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator SynthModule() const { return SynthModule(*_pool); }
	inline operator Object() const { return Object(*_pool); }
	inline Synth_PLAY_base* _base() {return _cache?_cache:_method_call();}

	inline AutoSuspendState autoSuspend() {return _cache?_cache->autoSuspend():_method_call()->autoSuspend();}
	inline void start() {return _cache?_cache->start():_method_call()->start();}
	inline void stop() {return _cache?_cache->stop():_method_call()->stop();}
	inline void streamInit() {return _cache?_cache->streamInit():_method_call()->streamInit();}
	inline void streamStart() {return _cache?_cache->streamStart():_method_call()->streamStart();}
	inline void streamEnd() {return _cache?_cache->streamEnd():_method_call()->streamEnd();}
};

class Synth_FREQUENCY_base : virtual public SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_FREQUENCY_base *_create(const std::string& subClass = "Synth_FREQUENCY");
	static Synth_FREQUENCY_base *_fromString(std::string objectref);
	static Synth_FREQUENCY_base *_fromReference(ObjectReference ref, bool needcopy);

	inline Synth_FREQUENCY_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual vector<std::string> _defaultPortsIn() const;
	virtual vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_FREQUENCY_stub : virtual public Synth_FREQUENCY_base, virtual public SynthModule_stub {
protected:
	Synth_FREQUENCY_stub();

public:
	Synth_FREQUENCY_stub(Connection *connection, long objectID);

};

class Synth_FREQUENCY_skel : virtual public Synth_FREQUENCY_base, virtual public SynthModule_skel {
protected:
	// variables for streams
	float *frequency;                         // incoming stream
	float *pos;                               // outgoing stream

public:
	Synth_FREQUENCY_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	void _buildMethodTable();
	void dispatch(Buffer *request, Buffer *result,long methodID);
};

#include "reference.h"
#include "flowsystem.h"

class Synth_FREQUENCY : public SmartWrapper {
private:
	static Object_base* _Creator();
	Synth_FREQUENCY_base *_cache;
	inline Synth_FREQUENCY_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_FREQUENCY_base *)_pool->base->_cast(Synth_FREQUENCY_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

public:
	inline Synth_FREQUENCY() : SmartWrapper(_Creator), _cache(0) {}
	inline Synth_FREQUENCY(const SubClass& s) :
		SmartWrapper(Synth_FREQUENCY_base::_create(s.string())), _cache(0) {}
	inline Synth_FREQUENCY(const Reference &r) :
		SmartWrapper(r.isString()?(Synth_FREQUENCY_base::_fromString(r.string())):(Synth_FREQUENCY_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_FREQUENCY(Synth_FREQUENCY_base* b) : SmartWrapper(b), _cache(0) {}
	inline Synth_FREQUENCY(const Synth_FREQUENCY& target) : SmartWrapper(target._pool), _cache(target._cache) {}
	inline Synth_FREQUENCY(SmartWrapper::Pool& p) : SmartWrapper(p), _cache(0) {}
	inline Synth_FREQUENCY& operator=(const Synth_FREQUENCY& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator SynthModule() const { return SynthModule(*_pool); }
	inline operator Object() const { return Object(*_pool); }
	inline Synth_FREQUENCY_base* _base() {return _cache?_cache:_method_call();}

	inline AutoSuspendState autoSuspend() {return _cache?_cache->autoSuspend():_method_call()->autoSuspend();}
	inline void start() {return _cache?_cache->start():_method_call()->start();}
	inline void stop() {return _cache?_cache->stop():_method_call()->stop();}
	inline void streamInit() {return _cache?_cache->streamInit():_method_call()->streamInit();}
	inline void streamStart() {return _cache?_cache->streamStart():_method_call()->streamStart();}
	inline void streamEnd() {return _cache?_cache->streamEnd():_method_call()->streamEnd();}
};

class Synth_WAVE_SIN_base : virtual public SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_WAVE_SIN_base *_create(const std::string& subClass = "Synth_WAVE_SIN");
	static Synth_WAVE_SIN_base *_fromString(std::string objectref);
	static Synth_WAVE_SIN_base *_fromReference(ObjectReference ref, bool needcopy);

	inline Synth_WAVE_SIN_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual vector<std::string> _defaultPortsIn() const;
	virtual vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_WAVE_SIN_stub : virtual public Synth_WAVE_SIN_base, virtual public SynthModule_stub {
protected:
	Synth_WAVE_SIN_stub();

public:
	Synth_WAVE_SIN_stub(Connection *connection, long objectID);

};

class Synth_WAVE_SIN_skel : virtual public Synth_WAVE_SIN_base, virtual public SynthModule_skel {
protected:
	// variables for streams
	float *pos;                               // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_WAVE_SIN_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	void _buildMethodTable();
	void dispatch(Buffer *request, Buffer *result,long methodID);
};

#include "reference.h"
#include "flowsystem.h"

class Synth_WAVE_SIN : public SmartWrapper {
private:
	static Object_base* _Creator();
	Synth_WAVE_SIN_base *_cache;
	inline Synth_WAVE_SIN_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_WAVE_SIN_base *)_pool->base->_cast(Synth_WAVE_SIN_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

public:
	inline Synth_WAVE_SIN() : SmartWrapper(_Creator), _cache(0) {}
	inline Synth_WAVE_SIN(const SubClass& s) :
		SmartWrapper(Synth_WAVE_SIN_base::_create(s.string())), _cache(0) {}
	inline Synth_WAVE_SIN(const Reference &r) :
		SmartWrapper(r.isString()?(Synth_WAVE_SIN_base::_fromString(r.string())):(Synth_WAVE_SIN_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_WAVE_SIN(Synth_WAVE_SIN_base* b) : SmartWrapper(b), _cache(0) {}
	inline Synth_WAVE_SIN(const Synth_WAVE_SIN& target) : SmartWrapper(target._pool), _cache(target._cache) {}
	inline Synth_WAVE_SIN(SmartWrapper::Pool& p) : SmartWrapper(p), _cache(0) {}
	inline Synth_WAVE_SIN& operator=(const Synth_WAVE_SIN& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator SynthModule() const { return SynthModule(*_pool); }
	inline operator Object() const { return Object(*_pool); }
	inline Synth_WAVE_SIN_base* _base() {return _cache?_cache:_method_call();}

	inline AutoSuspendState autoSuspend() {return _cache?_cache->autoSuspend():_method_call()->autoSuspend();}
	inline void start() {return _cache?_cache->start():_method_call()->start();}
	inline void stop() {return _cache?_cache->stop():_method_call()->stop();}
	inline void streamInit() {return _cache?_cache->streamInit():_method_call()->streamInit();}
	inline void streamStart() {return _cache?_cache->streamStart():_method_call()->streamStart();}
	inline void streamEnd() {return _cache?_cache->streamEnd():_method_call()->streamEnd();}
};

class Synth_MULTI_ADD_base : virtual public SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_MULTI_ADD_base *_create(const std::string& subClass = "Synth_MULTI_ADD");
	static Synth_MULTI_ADD_base *_fromString(std::string objectref);
	static Synth_MULTI_ADD_base *_fromReference(ObjectReference ref, bool needcopy);

	inline Synth_MULTI_ADD_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual vector<std::string> _defaultPortsIn() const;
	virtual vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_MULTI_ADD_stub : virtual public Synth_MULTI_ADD_base, virtual public SynthModule_stub {
protected:
	Synth_MULTI_ADD_stub();

public:
	Synth_MULTI_ADD_stub(Connection *connection, long objectID);

};

class Synth_MULTI_ADD_skel : virtual public Synth_MULTI_ADD_base, virtual public SynthModule_skel {
protected:
	// variables for streams
	float **invalue;                          // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_MULTI_ADD_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	void _buildMethodTable();
	void dispatch(Buffer *request, Buffer *result,long methodID);
};

#include "reference.h"
#include "flowsystem.h"

class Synth_MULTI_ADD : public SmartWrapper {
private:
	static Object_base* _Creator();
	Synth_MULTI_ADD_base *_cache;
	inline Synth_MULTI_ADD_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_MULTI_ADD_base *)_pool->base->_cast(Synth_MULTI_ADD_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

public:
	inline Synth_MULTI_ADD() : SmartWrapper(_Creator), _cache(0) {}
	inline Synth_MULTI_ADD(const SubClass& s) :
		SmartWrapper(Synth_MULTI_ADD_base::_create(s.string())), _cache(0) {}
	inline Synth_MULTI_ADD(const Reference &r) :
		SmartWrapper(r.isString()?(Synth_MULTI_ADD_base::_fromString(r.string())):(Synth_MULTI_ADD_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_MULTI_ADD(Synth_MULTI_ADD_base* b) : SmartWrapper(b), _cache(0) {}
	inline Synth_MULTI_ADD(const Synth_MULTI_ADD& target) : SmartWrapper(target._pool), _cache(target._cache) {}
	inline Synth_MULTI_ADD(SmartWrapper::Pool& p) : SmartWrapper(p), _cache(0) {}
	inline Synth_MULTI_ADD& operator=(const Synth_MULTI_ADD& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator SynthModule() const { return SynthModule(*_pool); }
	inline operator Object() const { return Object(*_pool); }
	inline Synth_MULTI_ADD_base* _base() {return _cache?_cache:_method_call();}

	inline AutoSuspendState autoSuspend() {return _cache?_cache->autoSuspend():_method_call()->autoSuspend();}
	inline void start() {return _cache?_cache->start():_method_call()->start();}
	inline void stop() {return _cache?_cache->stop():_method_call()->stop();}
	inline void streamInit() {return _cache?_cache->streamInit():_method_call()->streamInit();}
	inline void streamStart() {return _cache?_cache->streamStart():_method_call()->streamStart();}
	inline void streamEnd() {return _cache?_cache->streamEnd():_method_call()->streamEnd();}
};

class Synth_ADD_base : virtual public SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_ADD_base *_create(const std::string& subClass = "Synth_ADD");
	static Synth_ADD_base *_fromString(std::string objectref);
	static Synth_ADD_base *_fromReference(ObjectReference ref, bool needcopy);

	inline Synth_ADD_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual vector<std::string> _defaultPortsIn() const;
	virtual vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_ADD_stub : virtual public Synth_ADD_base, virtual public SynthModule_stub {
protected:
	Synth_ADD_stub();

public:
	Synth_ADD_stub(Connection *connection, long objectID);

};

class Synth_ADD_skel : virtual public Synth_ADD_base, virtual public SynthModule_skel {
protected:
	// variables for streams
	float *invalue1;                          // incoming stream
	float *invalue2;                          // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_ADD_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	void _buildMethodTable();
	void dispatch(Buffer *request, Buffer *result,long methodID);
};

#include "reference.h"
#include "flowsystem.h"

class Synth_ADD : public SmartWrapper {
private:
	static Object_base* _Creator();
	Synth_ADD_base *_cache;
	inline Synth_ADD_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_ADD_base *)_pool->base->_cast(Synth_ADD_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

public:
	inline Synth_ADD() : SmartWrapper(_Creator), _cache(0) {}
	inline Synth_ADD(const SubClass& s) :
		SmartWrapper(Synth_ADD_base::_create(s.string())), _cache(0) {}
	inline Synth_ADD(const Reference &r) :
		SmartWrapper(r.isString()?(Synth_ADD_base::_fromString(r.string())):(Synth_ADD_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_ADD(Synth_ADD_base* b) : SmartWrapper(b), _cache(0) {}
	inline Synth_ADD(const Synth_ADD& target) : SmartWrapper(target._pool), _cache(target._cache) {}
	inline Synth_ADD(SmartWrapper::Pool& p) : SmartWrapper(p), _cache(0) {}
	inline Synth_ADD& operator=(const Synth_ADD& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator SynthModule() const { return SynthModule(*_pool); }
	inline operator Object() const { return Object(*_pool); }
	inline Synth_ADD_base* _base() {return _cache?_cache:_method_call();}

	inline AutoSuspendState autoSuspend() {return _cache?_cache->autoSuspend():_method_call()->autoSuspend();}
	inline void start() {return _cache?_cache->start():_method_call()->start();}
	inline void stop() {return _cache?_cache->stop():_method_call()->stop();}
	inline void streamInit() {return _cache?_cache->streamInit():_method_call()->streamInit();}
	inline void streamStart() {return _cache?_cache->streamStart():_method_call()->streamStart();}
	inline void streamEnd() {return _cache?_cache->streamEnd():_method_call()->streamEnd();}
};

class Synth_MUL_base : virtual public SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_MUL_base *_create(const std::string& subClass = "Synth_MUL");
	static Synth_MUL_base *_fromString(std::string objectref);
	static Synth_MUL_base *_fromReference(ObjectReference ref, bool needcopy);

	inline Synth_MUL_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual vector<std::string> _defaultPortsIn() const;
	virtual vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class Synth_MUL_stub : virtual public Synth_MUL_base, virtual public SynthModule_stub {
protected:
	Synth_MUL_stub();

public:
	Synth_MUL_stub(Connection *connection, long objectID);

};

class Synth_MUL_skel : virtual public Synth_MUL_base, virtual public SynthModule_skel {
protected:
	// variables for streams
	float *invalue1;                          // incoming stream
	float *invalue2;                          // incoming stream
	float *outvalue;                          // outgoing stream

public:
	Synth_MUL_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	void _buildMethodTable();
	void dispatch(Buffer *request, Buffer *result,long methodID);
};

#include "reference.h"
#include "flowsystem.h"

class Synth_MUL : public SmartWrapper {
private:
	static Object_base* _Creator();
	Synth_MUL_base *_cache;
	inline Synth_MUL_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_MUL_base *)_pool->base->_cast(Synth_MUL_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

public:
	inline Synth_MUL() : SmartWrapper(_Creator), _cache(0) {}
	inline Synth_MUL(const SubClass& s) :
		SmartWrapper(Synth_MUL_base::_create(s.string())), _cache(0) {}
	inline Synth_MUL(const Reference &r) :
		SmartWrapper(r.isString()?(Synth_MUL_base::_fromString(r.string())):(Synth_MUL_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_MUL(Synth_MUL_base* b) : SmartWrapper(b), _cache(0) {}
	inline Synth_MUL(const Synth_MUL& target) : SmartWrapper(target._pool), _cache(target._cache) {}
	inline Synth_MUL(SmartWrapper::Pool& p) : SmartWrapper(p), _cache(0) {}
	inline Synth_MUL& operator=(const Synth_MUL& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator SynthModule() const { return SynthModule(*_pool); }
	inline operator Object() const { return Object(*_pool); }
	inline Synth_MUL_base* _base() {return _cache?_cache:_method_call();}

	inline AutoSuspendState autoSuspend() {return _cache?_cache->autoSuspend():_method_call()->autoSuspend();}
	inline void start() {return _cache?_cache->start():_method_call()->start();}
	inline void stop() {return _cache?_cache->stop():_method_call()->stop();}
	inline void streamInit() {return _cache?_cache->streamInit():_method_call()->streamInit();}
	inline void streamStart() {return _cache?_cache->streamStart():_method_call()->streamStart();}
	inline void streamEnd() {return _cache?_cache->streamEnd():_method_call()->streamEnd();}
};

class Synth_PLAY_WAV_base : virtual public SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Synth_PLAY_WAV_base *_create(const std::string& subClass = "Synth_PLAY_WAV");
	static Synth_PLAY_WAV_base *_fromString(std::string objectref);
	static Synth_PLAY_WAV_base *_fromReference(ObjectReference ref, bool needcopy);

	inline Synth_PLAY_WAV_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual vector<std::string> _defaultPortsIn() const;
	virtual vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float speed() = 0;
	virtual void speed(float newValue) = 0;
	virtual std::string filename() = 0;
	virtual void filename(const std::string& newValue) = 0;
	virtual bool finished() = 0;
};

class Synth_PLAY_WAV_stub : virtual public Synth_PLAY_WAV_base, virtual public SynthModule_stub {
protected:
	Synth_PLAY_WAV_stub();

public:
	Synth_PLAY_WAV_stub(Connection *connection, long objectID);

	float speed();
	void speed(float newValue);
	std::string filename();
	void filename(const std::string& newValue);
	bool finished();
};

class Synth_PLAY_WAV_skel : virtual public Synth_PLAY_WAV_base, virtual public SynthModule_skel {
protected:
	// variables for streams
	float *left;                              // outgoing stream
	float *right;                             // outgoing stream

public:
	Synth_PLAY_WAV_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	void _buildMethodTable();
	void dispatch(Buffer *request, Buffer *result,long methodID);
};

#include "reference.h"
#include "flowsystem.h"

class Synth_PLAY_WAV : public SmartWrapper {
private:
	static Object_base* _Creator();
	Synth_PLAY_WAV_base *_cache;
	inline Synth_PLAY_WAV_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Synth_PLAY_WAV_base *)_pool->base->_cast(Synth_PLAY_WAV_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

public:
	inline Synth_PLAY_WAV() : SmartWrapper(_Creator), _cache(0) {}
	inline Synth_PLAY_WAV(const SubClass& s) :
		SmartWrapper(Synth_PLAY_WAV_base::_create(s.string())), _cache(0) {}
	inline Synth_PLAY_WAV(const Reference &r) :
		SmartWrapper(r.isString()?(Synth_PLAY_WAV_base::_fromString(r.string())):(Synth_PLAY_WAV_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Synth_PLAY_WAV(Synth_PLAY_WAV_base* b) : SmartWrapper(b), _cache(0) {}
	inline Synth_PLAY_WAV(const Synth_PLAY_WAV& target) : SmartWrapper(target._pool), _cache(target._cache) {}
	inline Synth_PLAY_WAV(SmartWrapper::Pool& p) : SmartWrapper(p), _cache(0) {}
	inline Synth_PLAY_WAV& operator=(const Synth_PLAY_WAV& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator SynthModule() const { return SynthModule(*_pool); }
	inline operator Object() const { return Object(*_pool); }
	inline Synth_PLAY_WAV_base* _base() {return _cache?_cache:_method_call();}

	inline float speed() {return _cache?_cache->speed():_method_call()->speed();}
	inline void speed(float newValue) {_cache?_cache->speed(newValue):_method_call()->speed(newValue);}
	inline std::string filename() {return _cache?_cache->filename():_method_call()->filename();}
	inline void filename(const std::string& newValue) {_cache?_cache->filename(newValue):_method_call()->filename(newValue);}
	inline bool finished() {return _cache?_cache->finished():_method_call()->finished();}
	inline AutoSuspendState autoSuspend() {return _cache?_cache->autoSuspend():_method_call()->autoSuspend();}
	inline void start() {return _cache?_cache->start():_method_call()->start();}
	inline void stop() {return _cache?_cache->stop():_method_call()->stop();}
	inline void streamInit() {return _cache?_cache->streamInit():_method_call()->streamInit();}
	inline void streamStart() {return _cache?_cache->streamStart():_method_call()->streamStart();}
	inline void streamEnd() {return _cache?_cache->streamEnd():_method_call()->streamEnd();}
};

class ByteStreamToAudio_base : virtual public SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static ByteStreamToAudio_base *_create(const std::string& subClass = "ByteStreamToAudio");
	static ByteStreamToAudio_base *_fromString(std::string objectref);
	static ByteStreamToAudio_base *_fromReference(ObjectReference ref, bool needcopy);

	inline ByteStreamToAudio_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual vector<std::string> _defaultPortsIn() const;
	virtual vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long samplingRate() = 0;
	virtual void samplingRate(long newValue) = 0;
	virtual long channels() = 0;
	virtual void channels(long newValue) = 0;
	virtual long bits() = 0;
	virtual void bits(long newValue) = 0;
	virtual bool running() = 0;
};

class ByteStreamToAudio_stub : virtual public ByteStreamToAudio_base, virtual public SynthModule_stub {
protected:
	ByteStreamToAudio_stub();

public:
	ByteStreamToAudio_stub(Connection *connection, long objectID);

	long samplingRate();
	void samplingRate(long newValue);
	long channels();
	void channels(long newValue);
	long bits();
	void bits(long newValue);
	bool running();
};

class ByteStreamToAudio_skel : virtual public ByteStreamToAudio_base, virtual public SynthModule_skel {
protected:
	// variables for streams
	ByteAsyncStream indata;                   // incoming stream
	float *left;                              // outgoing stream
	float *right;                             // outgoing stream

	// handler for asynchronous streams
	virtual void process_indata(DataPacket<mcopbyte> *) = 0;

public:
	ByteStreamToAudio_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	void _buildMethodTable();
	void dispatch(Buffer *request, Buffer *result,long methodID);
	void notify(const Notification& notification);
};

#include "reference.h"
#include "flowsystem.h"

class ByteStreamToAudio : public SmartWrapper {
private:
	static Object_base* _Creator();
	ByteStreamToAudio_base *_cache;
	inline ByteStreamToAudio_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(ByteStreamToAudio_base *)_pool->base->_cast(ByteStreamToAudio_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

public:
	inline ByteStreamToAudio() : SmartWrapper(_Creator), _cache(0) {}
	inline ByteStreamToAudio(const SubClass& s) :
		SmartWrapper(ByteStreamToAudio_base::_create(s.string())), _cache(0) {}
	inline ByteStreamToAudio(const Reference &r) :
		SmartWrapper(r.isString()?(ByteStreamToAudio_base::_fromString(r.string())):(ByteStreamToAudio_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline ByteStreamToAudio(ByteStreamToAudio_base* b) : SmartWrapper(b), _cache(0) {}
	inline ByteStreamToAudio(const ByteStreamToAudio& target) : SmartWrapper(target._pool), _cache(target._cache) {}
	inline ByteStreamToAudio(SmartWrapper::Pool& p) : SmartWrapper(p), _cache(0) {}
	inline ByteStreamToAudio& operator=(const ByteStreamToAudio& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator SynthModule() const { return SynthModule(*_pool); }
	inline operator Object() const { return Object(*_pool); }
	inline ByteStreamToAudio_base* _base() {return _cache?_cache:_method_call();}

	inline long samplingRate() {return _cache?_cache->samplingRate():_method_call()->samplingRate();}
	inline void samplingRate(long newValue) {_cache?_cache->samplingRate(newValue):_method_call()->samplingRate(newValue);}
	inline long channels() {return _cache?_cache->channels():_method_call()->channels();}
	inline void channels(long newValue) {_cache?_cache->channels(newValue):_method_call()->channels(newValue);}
	inline long bits() {return _cache?_cache->bits():_method_call()->bits();}
	inline void bits(long newValue) {_cache?_cache->bits(newValue):_method_call()->bits(newValue);}
	inline bool running() {return _cache?_cache->running():_method_call()->running();}
	inline AutoSuspendState autoSuspend() {return _cache?_cache->autoSuspend():_method_call()->autoSuspend();}
	inline void start() {return _cache?_cache->start():_method_call()->start();}
	inline void stop() {return _cache?_cache->stop():_method_call()->stop();}
	inline void streamInit() {return _cache?_cache->streamInit():_method_call()->streamInit();}
	inline void streamStart() {return _cache?_cache->streamStart():_method_call()->streamStart();}
	inline void streamEnd() {return _cache?_cache->streamEnd():_method_call()->streamEnd();}
};

class StereoEffect_base : virtual public SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static StereoEffect_base *_create(const std::string& subClass = "StereoEffect");
	static StereoEffect_base *_fromString(std::string objectref);
	static StereoEffect_base *_fromReference(ObjectReference ref, bool needcopy);

	inline StereoEffect_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual vector<std::string> _defaultPortsIn() const;
	virtual vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class StereoEffect_stub : virtual public StereoEffect_base, virtual public SynthModule_stub {
protected:
	StereoEffect_stub();

public:
	StereoEffect_stub(Connection *connection, long objectID);

};

class StereoEffect_skel : virtual public StereoEffect_base, virtual public SynthModule_skel {
protected:
	// variables for streams
	float *inleft;                            // incoming stream
	float *inright;                           // incoming stream
	float *outleft;                           // outgoing stream
	float *outright;                          // outgoing stream

public:
	StereoEffect_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	void _buildMethodTable();
	void dispatch(Buffer *request, Buffer *result,long methodID);
};

#include "reference.h"
#include "flowsystem.h"

class StereoEffect : public SmartWrapper {
private:
	static Object_base* _Creator();
	StereoEffect_base *_cache;
	inline StereoEffect_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(StereoEffect_base *)_pool->base->_cast(StereoEffect_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

public:
	inline StereoEffect() : SmartWrapper(_Creator), _cache(0) {}
	inline StereoEffect(const SubClass& s) :
		SmartWrapper(StereoEffect_base::_create(s.string())), _cache(0) {}
	inline StereoEffect(const Reference &r) :
		SmartWrapper(r.isString()?(StereoEffect_base::_fromString(r.string())):(StereoEffect_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline StereoEffect(StereoEffect_base* b) : SmartWrapper(b), _cache(0) {}
	inline StereoEffect(const StereoEffect& target) : SmartWrapper(target._pool), _cache(target._cache) {}
	inline StereoEffect(SmartWrapper::Pool& p) : SmartWrapper(p), _cache(0) {}
	inline StereoEffect& operator=(const StereoEffect& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator SynthModule() const { return SynthModule(*_pool); }
	inline operator Object() const { return Object(*_pool); }
	inline StereoEffect_base* _base() {return _cache?_cache:_method_call();}

	inline AutoSuspendState autoSuspend() {return _cache?_cache->autoSuspend():_method_call()->autoSuspend();}
	inline void start() {return _cache?_cache->start():_method_call()->start();}
	inline void stop() {return _cache?_cache->stop():_method_call()->stop();}
	inline void streamInit() {return _cache?_cache->streamInit():_method_call()->streamInit();}
	inline void streamStart() {return _cache?_cache->streamStart():_method_call()->streamStart();}
	inline void streamEnd() {return _cache?_cache->streamEnd():_method_call()->streamEnd();}
};

class StereoVolumeControl_base : virtual public StereoEffect_base {
public:
	static unsigned long _IID; // interface ID

	static StereoVolumeControl_base *_create(const std::string& subClass = "StereoVolumeControl");
	static StereoVolumeControl_base *_fromString(std::string objectref);
	static StereoVolumeControl_base *_fromReference(ObjectReference ref, bool needcopy);

	inline StereoVolumeControl_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual vector<std::string> _defaultPortsIn() const;
	virtual vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float scaleFactor() = 0;
	virtual void scaleFactor(float newValue) = 0;
	virtual float currentVolumeLeft() = 0;
	virtual float currentVolumeRight() = 0;
};

class StereoVolumeControl_stub : virtual public StereoVolumeControl_base, virtual public StereoEffect_stub {
protected:
	StereoVolumeControl_stub();

public:
	StereoVolumeControl_stub(Connection *connection, long objectID);

	float scaleFactor();
	void scaleFactor(float newValue);
	float currentVolumeLeft();
	float currentVolumeRight();
};

class StereoVolumeControl_skel : virtual public StereoVolumeControl_base, virtual public StereoEffect_skel {
public:
	StereoVolumeControl_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	void _buildMethodTable();
	void dispatch(Buffer *request, Buffer *result,long methodID);
};

#include "reference.h"

class StereoVolumeControl : public SmartWrapper {
private:
	static Object_base* _Creator();
	StereoVolumeControl_base *_cache;
	inline StereoVolumeControl_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(StereoVolumeControl_base *)_pool->base->_cast(StereoVolumeControl_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

public:
	inline StereoVolumeControl() : SmartWrapper(_Creator), _cache(0) {}
	inline StereoVolumeControl(const SubClass& s) :
		SmartWrapper(StereoVolumeControl_base::_create(s.string())), _cache(0) {}
	inline StereoVolumeControl(const Reference &r) :
		SmartWrapper(r.isString()?(StereoVolumeControl_base::_fromString(r.string())):(StereoVolumeControl_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline StereoVolumeControl(StereoVolumeControl_base* b) : SmartWrapper(b), _cache(0) {}
	inline StereoVolumeControl(const StereoVolumeControl& target) : SmartWrapper(target._pool), _cache(target._cache) {}
	inline StereoVolumeControl(SmartWrapper::Pool& p) : SmartWrapper(p), _cache(0) {}
	inline StereoVolumeControl& operator=(const StereoVolumeControl& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator StereoEffect() const { return StereoEffect(*_pool); }
	inline operator SynthModule() const { return SynthModule(*_pool); }
	inline operator Object() const { return Object(*_pool); }
	inline StereoVolumeControl_base* _base() {return _cache?_cache:_method_call();}

	inline float scaleFactor() {return _cache?_cache->scaleFactor():_method_call()->scaleFactor();}
	inline void scaleFactor(float newValue) {_cache?_cache->scaleFactor(newValue):_method_call()->scaleFactor(newValue);}
	inline float currentVolumeLeft() {return _cache?_cache->currentVolumeLeft():_method_call()->currentVolumeLeft();}
	inline float currentVolumeRight() {return _cache?_cache->currentVolumeRight():_method_call()->currentVolumeRight();}
	inline AutoSuspendState autoSuspend() {return _cache?_cache->autoSuspend():_method_call()->autoSuspend();}
	inline void start() {return _cache?_cache->start():_method_call()->start();}
	inline void stop() {return _cache?_cache->stop():_method_call()->stop();}
	inline void streamInit() {return _cache?_cache->streamInit():_method_call()->streamInit();}
	inline void streamStart() {return _cache?_cache->streamStart():_method_call()->streamStart();}
	inline void streamEnd() {return _cache?_cache->streamEnd():_method_call()->streamEnd();}
};

class StereoFFTScope_base : virtual public StereoEffect_base {
public:
	static unsigned long _IID; // interface ID

	static StereoFFTScope_base *_create(const std::string& subClass = "StereoFFTScope");
	static StereoFFTScope_base *_fromString(std::string objectref);
	static StereoFFTScope_base *_fromReference(ObjectReference ref, bool needcopy);

	inline StereoFFTScope_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual vector<std::string> _defaultPortsIn() const;
	virtual vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::vector<float> * scope() = 0;
};

class StereoFFTScope_stub : virtual public StereoFFTScope_base, virtual public StereoEffect_stub {
protected:
	StereoFFTScope_stub();

public:
	StereoFFTScope_stub(Connection *connection, long objectID);

	std::vector<float> * scope();
};

class StereoFFTScope_skel : virtual public StereoFFTScope_base, virtual public StereoEffect_skel {
public:
	StereoFFTScope_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	void _buildMethodTable();
	void dispatch(Buffer *request, Buffer *result,long methodID);
};

#include "reference.h"

class StereoFFTScope : public SmartWrapper {
private:
	static Object_base* _Creator();
	StereoFFTScope_base *_cache;
	inline StereoFFTScope_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(StereoFFTScope_base *)_pool->base->_cast(StereoFFTScope_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

public:
	inline StereoFFTScope() : SmartWrapper(_Creator), _cache(0) {}
	inline StereoFFTScope(const SubClass& s) :
		SmartWrapper(StereoFFTScope_base::_create(s.string())), _cache(0) {}
	inline StereoFFTScope(const Reference &r) :
		SmartWrapper(r.isString()?(StereoFFTScope_base::_fromString(r.string())):(StereoFFTScope_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline StereoFFTScope(StereoFFTScope_base* b) : SmartWrapper(b), _cache(0) {}
	inline StereoFFTScope(const StereoFFTScope& target) : SmartWrapper(target._pool), _cache(target._cache) {}
	inline StereoFFTScope(SmartWrapper::Pool& p) : SmartWrapper(p), _cache(0) {}
	inline StereoFFTScope& operator=(const StereoFFTScope& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator StereoEffect() const { return StereoEffect(*_pool); }
	inline operator SynthModule() const { return SynthModule(*_pool); }
	inline operator Object() const { return Object(*_pool); }
	inline StereoFFTScope_base* _base() {return _cache?_cache:_method_call();}

	inline std::vector<float> * scope() {return _cache?_cache->scope():_method_call()->scope();}
	inline AutoSuspendState autoSuspend() {return _cache?_cache->autoSuspend():_method_call()->autoSuspend();}
	inline void start() {return _cache?_cache->start():_method_call()->start();}
	inline void stop() {return _cache?_cache->stop():_method_call()->stop();}
	inline void streamInit() {return _cache?_cache->streamInit():_method_call()->streamInit();}
	inline void streamStart() {return _cache?_cache->streamStart():_method_call()->streamStart();}
	inline void streamEnd() {return _cache?_cache->streamEnd():_method_call()->streamEnd();}
};

class StereoEffectStack_base : virtual public StereoEffect_base {
public:
	static unsigned long _IID; // interface ID

	static StereoEffectStack_base *_create(const std::string& subClass = "StereoEffectStack");
	static StereoEffectStack_base *_fromString(std::string objectref);
	static StereoEffectStack_base *_fromReference(ObjectReference ref, bool needcopy);

	inline StereoEffectStack_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual vector<std::string> _defaultPortsIn() const;
	virtual vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long insertTop(StereoEffect effect, const std::string& name) = 0;
	virtual long insertBottom(StereoEffect effect, const std::string& name) = 0;
	virtual void remove(long ID) = 0;
};

class StereoEffectStack_stub : virtual public StereoEffectStack_base, virtual public StereoEffect_stub {
protected:
	StereoEffectStack_stub();

public:
	StereoEffectStack_stub(Connection *connection, long objectID);

	long insertTop(StereoEffect effect, const std::string& name);
	long insertBottom(StereoEffect effect, const std::string& name);
	void remove(long ID);
};

class StereoEffectStack_skel : virtual public StereoEffectStack_base, virtual public StereoEffect_skel {
public:
	StereoEffectStack_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	void _buildMethodTable();
	void dispatch(Buffer *request, Buffer *result,long methodID);
};

#include "reference.h"

class StereoEffectStack : public SmartWrapper {
private:
	static Object_base* _Creator();
	StereoEffectStack_base *_cache;
	inline StereoEffectStack_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(StereoEffectStack_base *)_pool->base->_cast(StereoEffectStack_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

public:
	inline StereoEffectStack() : SmartWrapper(_Creator), _cache(0) {}
	inline StereoEffectStack(const SubClass& s) :
		SmartWrapper(StereoEffectStack_base::_create(s.string())), _cache(0) {}
	inline StereoEffectStack(const Reference &r) :
		SmartWrapper(r.isString()?(StereoEffectStack_base::_fromString(r.string())):(StereoEffectStack_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline StereoEffectStack(StereoEffectStack_base* b) : SmartWrapper(b), _cache(0) {}
	inline StereoEffectStack(const StereoEffectStack& target) : SmartWrapper(target._pool), _cache(target._cache) {}
	inline StereoEffectStack(SmartWrapper::Pool& p) : SmartWrapper(p), _cache(0) {}
	inline StereoEffectStack& operator=(const StereoEffectStack& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator StereoEffect() const { return StereoEffect(*_pool); }
	inline operator SynthModule() const { return SynthModule(*_pool); }
	inline operator Object() const { return Object(*_pool); }
	inline StereoEffectStack_base* _base() {return _cache?_cache:_method_call();}

	inline AutoSuspendState autoSuspend() {return _cache?_cache->autoSuspend():_method_call()->autoSuspend();}
	inline long insertTop(StereoEffect effect, const std::string& name) {return _cache?_cache->insertTop(effect, name):_method_call()->insertTop(effect, name);}
	inline long insertBottom(StereoEffect effect, const std::string& name) {return _cache?_cache->insertBottom(effect, name):_method_call()->insertBottom(effect, name);}
	inline void remove(long ID) {return _cache?_cache->remove(ID):_method_call()->remove(ID);}
	inline void start() {return _cache?_cache->start():_method_call()->start();}
	inline void stop() {return _cache?_cache->stop():_method_call()->stop();}
	inline void streamInit() {return _cache?_cache->streamInit():_method_call()->streamInit();}
	inline void streamStart() {return _cache?_cache->streamStart():_method_call()->streamStart();}
	inline void streamEnd() {return _cache?_cache->streamEnd():_method_call()->streamEnd();}
};

#endif /* ARTSFLOW_H */
