/*
  This file is part of klpq (C) 1998 Christoph Neerfeld
*/
/**********************************************************************

	--- Qt Architect generated file ---

	File: SpoolerConfig.cpp
	Last generated: Sat Feb 7 11:59:44 1998

 *********************************************************************/

// 1999-12-14 Espen Sand
// Changed to KDialogBase. The translators have had problems
// to work with the previous fixed size version.


#include <qbuttongroup.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qradiobutton.h>

#include <kapp.h>
#include <kconfig.h>
#include <klocale.h>
#include <kseparator.h>

#include "SpoolerConfig.h"
#include "SpoolerConfig.moc"


SpoolerConfig::SpoolerConfig( QWidget *parent, const char *name, bool modal )
  : KDialogBase( parent, name, modal, i18n("Spooler"), Ok|Cancel, Ok )
{
  
  QWidget *page = new QWidget( this ); 
  setMainWidget(page);
  QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );

  QLabel *label = new QLabel( page, "label" );
  label->setText( i18n("Select your spooling system") );
  topLayout->addWidget( label );

  topLayout->addSpacing( spacingHint() );


  QHBoxLayout *hlay = new QHBoxLayout( topLayout );
  
  QButtonGroup *group = new QButtonGroup( page, "buttongroup" );
  group->setFrameStyle( QFrame::NoFrame );
  connect( group, SIGNAL(clicked(int)), this, SLOT(spoolerChanged(int)) );
  hlay->addWidget( group ); 

  QVBoxLayout *vlay = new QVBoxLayout( group, spacingHint(), spacingHint() );

  QString radioText[3] = 
  {
    "BSD",
    "PPR",
    "LPRNG"
  };
  for( int i=0; i<3; i++ )
  {
    mRadio[i] = new QRadioButton( group, "radio" );
    mRadio[i]->setText( radioText[i] );
    vlay->addWidget( mRadio[i] );
  }

  KSeparator *sep = new KSeparator( page, "sep" );
  sep->setOrientation( QFrame::VLine );
  hlay->addWidget( sep );

  QGridLayout *gridLayout = new QGridLayout( hlay, 4, 2, spacingHint() );
  gridLayout->setColStretch( 1, 10 );

  label = new QLabel( page, "label" );
  label->setText( i18n("Paths of spooling commands:") );
  gridLayout->addMultiCellWidget( label, 0, 0, 0, 1 );
  
  const QString cmdText[3] = 
  {
    i18n("lpq:"),
    i18n("lpc:"),
    i18n("lprm:")
  };
  for( int i=0; i<3; i++ )
  {
    label = new QLabel( page, "label" );
    label->setText( cmdText[i] );
    gridLayout->addWidget( label, i+1, 0 );
    
    mLineEdit[i] = new QLineEdit( page, "lineedit" );
    mLineEdit[i]->setMinimumWidth( fontMetrics().maxWidth()*15 );
    gridLayout->addWidget( mLineEdit[i], i+1, 1 );
  }

  topLayout->addSpacing( spacingHint() );
  topLayout->addStretch( 10 );
}

SpoolerConfig::~SpoolerConfig()
{
}


void SpoolerConfig::initConfig( const QString &spoolerName )
{
  KConfig &config = *kapp->config();

  config.setGroup("klpqBsd");
  mBsd.lpq  = config.readEntry("lpqCommand", "lpq");
  mBsd.lpc  = config.readEntry("lpcCommand", "/usr/sbin/lpc");
  mBsd.lprm = config.readEntry("lprmCommand", "lprm");

  config.setGroup("klpqPpr");
  mPpr.lpq  = config.readEntry("lpqCommand", "ppop");
  mPpr.lpc  = config.readEntry("lpcCommand", "ppop");
  mPpr.lprm = config.readEntry("lprmCommand", "ppop");

  config.setGroup("klpqLprng");
  mLprng.lpq  = config.readEntry("lpqCommand", "lpq");
  mLprng.lpc  = config.readEntry("lpcCommand", "/usr/sbin/lpc");
  mLprng.lprm = config.readEntry("lprmCommand", "lprm");

  if( spoolerName == "PPR" )
  {
    mLineEdit[0]->setText( mPpr.lpq );
    mLineEdit[1]->setText( mPpr.lpc );
    mLineEdit[2]->setText( mPpr.lprm );
    mRadio[1]->setChecked( true );
    mCurrentButton = 1;
  }
  else if( spoolerName == "LPRNG" )
  {
    mLineEdit[0]->setText( mLprng.lpq );
    mLineEdit[1]->setText( mLprng.lpc );
    mLineEdit[2]->setText( mLprng.lprm );
    mRadio[2]->setChecked( true );
    mCurrentButton = 2;
  }
  else
  {
    mLineEdit[0]->setText( mBsd.lpq );
    mLineEdit[1]->setText( mBsd.lpc );
    mLineEdit[2]->setText( mBsd.lprm );
    mRadio[0]->setChecked( true );
    mCurrentButton = 0;
  }
}


QString SpoolerConfig::saveConfig( void )
{
  KConfig &config = *kapp->config();

  QString spoolerName;  
  if( mRadio[1]->isChecked() )
  {
    mPpr.lpq  = mLineEdit[0]->text();
    mPpr.lpc  = mLineEdit[1]->text();
    mPpr.lprm = mLineEdit[2]->text();
    spoolerName = "PPR";
  }
  else if( mRadio[2]->isChecked() )
  {
    mLprng.lpq  = mLineEdit[0]->text();
    mLprng.lpc  = mLineEdit[1]->text();
    mLprng.lprm = mLineEdit[2]->text();
    spoolerName = "LPRNG";
  }
  else
  {
    mBsd.lpq  = mLineEdit[0]->text();
    mBsd.lpc  = mLineEdit[1]->text();
    mBsd.lprm = mLineEdit[2]->text();
    spoolerName = "BSD";
  }
  config.setGroup("klpq");
  config.writeEntry("Spooler", spoolerName );

  config.setGroup("klpqPpr");
  config.writeEntry("lpqCommand", mPpr.lpq );
  config.writeEntry("lpcCommand", mPpr.lpc );
  config.writeEntry("lprmCommand", mPpr.lprm );
  config.setGroup("klpqLprng");
  config.writeEntry("lpqCommand", mLprng.lpq );
  config.writeEntry("lpcCommand", mLprng.lpc );
  config.writeEntry("lprmCommand", mLprng.lprm );
  config.setGroup("klpqBsd"); 
  config.writeEntry("lpqCommand", mBsd.lpq );
  config.writeEntry("lpcCommand", mBsd.lpc );
  config.writeEntry("lprmCommand", mBsd.lprm );

  config.sync();

  return( spoolerName );
}



void SpoolerConfig::spoolerChanged( int button )
{
  //
  // Save current state.
  //
  if( mCurrentButton == 1 )
  {
    mPpr.lpq  = mLineEdit[0]->text();
    mPpr.lpc  = mLineEdit[1]->text();
    mPpr.lprm = mLineEdit[2]->text();
  }
  else if( mCurrentButton == 2 )
  {
    mLprng.lpq  = mLineEdit[0]->text();
    mLprng.lpc  = mLineEdit[1]->text();
    mLprng.lprm = mLineEdit[2]->text();
  }
  else
  {
    mBsd.lpq  = mLineEdit[0]->text();
    mBsd.lpc  = mLineEdit[1]->text();
    mBsd.lprm = mLineEdit[2]->text();
    mCurrentButton = 0;
  }

  mCurrentButton = button;

  //
  // Print new state
  //
  if( button == 1 )
  {
    mLineEdit[0]->setText( mPpr.lpq );
    mLineEdit[1]->setText( mPpr.lpc );
    mLineEdit[2]->setText( mPpr.lprm );
  }
  else if( button == 2 )
  {
    mLineEdit[0]->setText( mLprng.lpq );
    mLineEdit[1]->setText( mLprng.lpc );
    mLineEdit[2]->setText( mLprng.lprm );
  }
  else
  {
    mLineEdit[0]->setText( mBsd.lpq );
    mLineEdit[1]->setText( mBsd.lpc );
    mLineEdit[2]->setText( mBsd.lprm );
  }
}








#if 0




class QString;

class SpoolerConfig : public SpoolerConfigData
{
  Q_OBJECT
public:
  SpoolerConfig ( QWidget* parent = 0L, const char* name = 0L );
  virtual ~SpoolerConfig();

  void    initConfig( QString name);
  QString saveConfig();

protected slots:
  void buttonClicked(int id);

protected:
  //void spoolerChanged( QString name );

  QString lpq_bsd;
  QString lpc_bsd;
  QString lprm_bsd;

  QString lpq_ppr;
  QString lpc_ppr;
  QString lprm_ppr;

  QString lpq_lprng;
  QString lpc_lprng;
  QString lprm_lprng;

  int old_button;
};



SpoolerConfig::SpoolerConfig( QWidget* parent, const char* name )
  : SpoolerConfigData( parent, name )
{
  setCaption( i18n("Select your spooling system") );
  connect( bg_spooler, SIGNAL(clicked(int)), this, SLOT(buttonClicked(int)) );
  connect( b_ok, SIGNAL(clicked()), this, SLOT(accept()) );
  connect( b_cancel, SIGNAL(clicked()), this, SLOT(reject()) );
}

SpoolerConfig::~SpoolerConfig()
{
}

void SpoolerConfig::initConfig( QString name )
{
  KConfig *config = KApplication::kApplication()->config();
  config->setGroup("klpqPpr");
  lpq_ppr = config->readEntry("lpqCommand", "ppop");
  lpc_ppr = config->readEntry("lpcCommand", "ppop");
  lprm_ppr = config->readEntry("lprmCommand", "ppop");
  config->setGroup("klpqLprng");
  lpq_lprng = config->readEntry("lpqCommand", "lpq");
  lpc_lprng = config->readEntry("lpcCommand", "/usr/sbin/lpc");
  lprm_lprng = config->readEntry("lprmCommand", "lprm");
  config->setGroup("klpqBsd");
  lpq_bsd = config->readEntry("lpqCommand", "lpq");
  lpc_bsd = config->readEntry("lpcCommand", "/usr/sbin/lpc");
  lprm_bsd = config->readEntry("lprmCommand", "lprm");
  if( name == "PPR" )
    {
      i_lpq->setText(lpq_ppr);
      i_lpc->setText(lpc_ppr);
      i_lprm->setText(lprm_ppr);
      old_button = 1;
      rb_ppr->setChecked( TRUE );
    }
  else if( name == "LPRNG" )
    {
      i_lpq->setText(lpq_lprng);
      i_lpc->setText(lpc_lprng);
      i_lprm->setText(lprm_lprng);
      old_button = 2;
      rb_lprng->setChecked( TRUE );
    }
  else
    {
      i_lpq->setText(lpq_bsd);
      i_lpc->setText(lpc_bsd);
      i_lprm->setText(lprm_bsd);
      old_button = 0;
      rb_bsd->setChecked( TRUE );
    }
}

QString SpoolerConfig::saveConfig()
{
  KConfig *config = KApplication::kApplication()->config();
  QString temp;  
  if( rb_ppr->isChecked() )
    {
      lpq_ppr = i_lpq->text();
      lpc_ppr = i_lpc->text();
      lprm_ppr = i_lprm->text();
      temp = "PPR";
    }
  else if( rb_lprng->isChecked() )
    {
      lpq_lprng = i_lpq->text();
      lpc_lprng = i_lpc->text();
      lprm_lprng = i_lprm->text();
      temp = "LPRNG";
    }
  else
    {
      lpq_bsd = i_lpq->text();
      lpc_bsd = i_lpc->text();
      lprm_bsd = i_lprm->text();
      temp = "BSD";
    }
  config->setGroup("klpq");
  config->writeEntry("Spooler", temp );

  config->setGroup("klpqPpr");
  config->writeEntry("lpqCommand", lpq_ppr);
  config->writeEntry("lpcCommand", lpc_ppr);
  config->writeEntry("lprmCommand", lprm_ppr);
  config->setGroup("klpqLprng");
  config->writeEntry("lpqCommand", lpq_lprng);
  config->writeEntry("lpcCommand", lpc_lprng);
  config->writeEntry("lprmCommand", lprm_lprng);
  config->setGroup("klpqBsd"); 
  config->writeEntry("lpqCommand", lpq_bsd);
  config->writeEntry("lpcCommand", lpc_bsd);
  config->writeEntry("lprmCommand", lprm_bsd);
  return temp;
}

void SpoolerConfig::buttonClicked(int id)
{
  if( old_button == id )
    return;
  switch( old_button ) {
  case 1:
    lpq_ppr = i_lpq->text();
    lpc_ppr = i_lpc->text();
    lprm_ppr = i_lprm->text();
    break;
  case 2:
    lpq_lprng = i_lpq->text();
    lpc_lprng = i_lpc->text();
    lprm_lprng = i_lprm->text();
    break;
  default:
    lpq_bsd = i_lpq->text();
    lpc_bsd = i_lpc->text();
    lprm_bsd = i_lprm->text();
  };

  switch( id ) {
  case 1:
    i_lpq->setText(lpq_ppr);
    i_lpc->setText(lpc_ppr);
    i_lprm->setText(lprm_ppr);
    break;
  case 2:
    i_lpq->setText(lpq_lprng);
    i_lpc->setText(lpc_lprng);
    i_lprm->setText(lprm_lprng);
    break;
  default:
    i_lpq->setText(lpq_bsd);
    i_lpc->setText(lpc_bsd);
    i_lprm->setText(lprm_bsd);
  };
  old_button = id;
}
#endif
