/* vi: ts=8 sts=4 sw=4
 *
 * $Id: sshdlg.cpp,v 1.2 2000/05/20 14:29:29 jansen Exp $
 *
 * This file is part of the KDE project, module kdesu.
 * Copyright (C) 2000 Geert Jansen <jansen@kde.org>
 */

#include <qstring.h>
#include <klocale.h>
#include <kmessagebox.h>

#include <kdesu/ssh.h>
#include "sshdlg.h"


KDEsshDialog::KDEsshDialog(QCString host, QCString user, QCString prompt, 
	bool enableKeep)
    : KPasswordDialog(Password, "", enableKeep)
{
    m_Host = host;
    m_User = user;

    setCaption(QString::fromLatin1("%1@%2").arg(m_User).arg(m_Host));

    // Make the prompt a little more polite :-)
    if (!strnicmp(prompt, "Enter ", 6))
	prompt.remove(0, 6);
    int pos = prompt.find(':');
    if (pos != -1)
	prompt.remove(pos, 10);
    prompt += '.';
    prompt.prepend(i18n("The action you requested needs authentication. "
	    "Please enter "));
    setPrompt(prompt);
}


KDEsshDialog::~KDEsshDialog()
{
}


bool KDEsshDialog::checkPassword(const char *password)
{
    SshProcess proc(m_Host, m_User);
    int ret = proc.checkInstall(password);
    if (ret != 0) 
    {
        KMessageBox::sorry(this, i18n("Incorrect password! Please try again."));
	return false;
    }
    return true;
}


#include "sshdlg.moc"
