/* This file implements the method to open a file..
 *
 * the KDE addressbook
 * copyright:  (C) Mirko Sucker, 1998, 1999, 2000
 * mail to:    Mirko Sucker <mirko@kde.org>
 * requires:   recent C++-compiler, at least Qt 2.0
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public License
 along with this library; see the file COPYING.LIB.  If not, write to
 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 * $Revision: 1.11 $
 */

#include <kabapi.h>
#include "kab_topwidget.h"
#include <qstring.h>
#include <qfileinfo.h>
#include <qdir.h>
#include <kapp.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kurl.h>
#include <kdebug.h>

void TopLevelWidget::loadDatabaseFile()
{
  register bool GUARD; GUARD=true;
  // ###########################################################################
  kdDebug() << "KabMainWindow::open: called.";
  QString home, filename;
  KURL dummy;
  QFileInfo info;
  // ----- select the filename:
  home=QDir::homeDirPath();
  if(home.isEmpty())
    {
      KMessageBox::sorry
	(this, i18n("Could not find the users home directory."), i18n("Sorry"));
      setStatus(i18n("Intern error!"));
      kapp->beep();
      return;
    }
  for(;;) // do forever
    {
      dummy = KFileDialog::getOpenURL(home, "*kab", this);
      if(dummy.isEmpty()) // dialog has been cancelled
	{
	  setStatus(i18n("Cancelled."));
	  qApp->beep();
	  return;
	}
      // WORK_TO_DO: download the URL or find the local file name in filename
      if(!dummy.isLocalFile())
      {
        setStatus(i18n("Only local files supported yet."));
	qApp->beep();
        return;
      } else {
	filename=dummy.path();
      }
      // ...
      // -----
      info.setFile(filename);
      if(info.isDir() || !info.exists())
	{
	  KMessageBox::sorry
	    (this, i18n("The file does not exist or is a directory.\n"
			"Use \"New File\" to create a new one.\n"
			"Select an existing file to load it."),
	     i18n("File error"));
	} else {
	  kdDebug() << "KabMainWindow::newFile: filename is " <<
		     filename.data();
	  break;
	}
    }
  // ----- load the file:
  if(api->addressbook()->load(filename)!=AddressBook::NoError)
    {
      KMessageBox::sorry
	(this, i18n("The file could not be loaded."),
	 i18n("File error"));
      kapp->beep();
      return;
    }
  // -----
  modified=false;
  enableButtons();
  // WORK_TO_DO: updateGUI();
  kdDebug() << "KabMainWindow::newFile: done.";  
  // ###########################################################################
}

