/*
 *  Copyright (c) 2000 Matthias Elter <elter@kde.org>
 *  based on keyes (C) 1999 by Jerome Tollet <tollet@magic.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 */

#ifndef __eyes_h__
#define __eyes_h__

#include <kpanelapplet.h>

#include <X11/Xlib.h>

typedef struct
{
    Window root;
    Screen *scr;
    int height, width;
    double PixelsPerMM;
} _screenInfo;


class EyesApplet : public KPanelApplet
{
  Q_OBJECT
	
public:
  EyesApplet( QWidget* parent = 0, const char* name = 0 );
  ~EyesApplet();

  int widthForHeight(int height);
  int heightForWidth(int width);

protected:
  void timerEvent(QTimerEvent*);
  void resizeEvent(QResizeEvent*);
  void paintEvent(QPaintEvent*);

  QPoint oldPoint1,oldPoint2;
  Display *display;
  Window root, RootIDRet, ChildIDRet;
  int sizeEye;
  unsigned int StateMask;
};

#endif // __eyes_h__
