#ifndef KOEVENTVIEWER_H
#define KOEVENTVIEWER_H
// $Id: koeventviewer.h,v 1.2 2000/05/21 12:32:08 cschumac Exp $
//
// Viewer widget and dialog for events.
//

#include <qtextview.h>

#include <kdialogbase.h>

class KOEvent;


class KOEventViewer : public QTextView {
    Q_OBJECT
  public:
    KOEventViewer(QWidget *parent=0,const char *name=0);
    virtual ~KOEventViewer();

    void setEvent(KOEvent *event);
    void setTodo(KOEvent *event);
    
    void appendEvent(KOEvent *event);
    
    void clearEvents(bool now=false);
    
  protected:
    void addTag(const QString & tag,const QString & text);

  private:
    QTextView *mEventTextView;

    QString mText;    
};

class KOEventViewerDialog : public KDialogBase {
    Q_OBJECT
  public:
    KOEventViewerDialog(QWidget *parent=0,const char *name=0);
    virtual ~KOEventViewerDialog();

    void setEvent(KOEvent *event);
    void setTodo(KOEvent *event);
    
  private:
    KOEventViewer *mEventViewer;
};

#endif
