/* 
 *  Copyright (C) 1999-2000 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#ifndef _SITE_H_
#define _SITE_H_


#include <qdict.h>
#include <qlist.h>
#include <qdom.h>


struct InputTag
{
    QString name;
    QString value;
    bool user;
};


class Site {

public:
  Site();
  ~Site();

  QString makeQueryUrl(const QString &query);

  QString name;
  QString action;
  QString icon;
  QList<InputTag> inputs;
  QString resultListStart;
  QString resultItemStart;
  QString resultListEnd;
  QString resultItemEnd;

};


class SiteFactory
{
public:
    virtual Site *create(const QString &filename);
    virtual void input(Site *site, const QDomElement &el);
    virtual void interpret(Site *site, const QDomElement &el);
    virtual Site *newSite();
};

    
class SiteManager
{
public:
    SiteManager(const QString &sitetype, SiteFactory &factory);
    //    ~SiteManager();

    QDict<Site> dict;
};

#endif
