/*
* pollcfg.cpp -- Implementation of class KPollCfg.
* Author:	Sirtaj Singh Kang
* Version:	$Id: pollcfg.cpp,v 1.1 1999/07/22 18:17:04 tibirna Exp $
* Generated:	Mon Aug  3 01:51:07 EST 1998
*/

#include <assert.h>
#include <stdlib.h>

#include <kglobal.h>
#include <klocale.h>
#include <qlabel.h>
#include <qlined.h>
#include <qlayout.h>

//#include "typolayout.h"
#include "pollcfg.h"
#include "polldrop.h"

KPollCfg::KPollCfg( KPollableDrop *drop ) 
	: KMonitorCfg( drop ),
	_freq( 0 ) 
{
}

const QString KPollCfg::name() const
{
	return i18n( "Poll" );
}

QWidget *KPollCfg::makeWidget( QWidget *parent )
{
	KPollableDrop *d = (KPollableDrop *) drop();

	QWidget *dlg = new QWidget ( parent );
	QGridLayout *layout = new QGridLayout( dlg, 3, 2, 10 );
	layout->setRowStretch(0, 1);
	layout->setRowStretch(1, 0);
	layout->setRowStretch(2, 1);

	QString s;
	s.setNum( d->freq() );

	QLabel *aLabel = new QLabel( i18n( "Check Frequency (sec)" ), dlg);
	layout->addWidget(aLabel, 1, 0);

	_freq = new QLineEdit( s, dlg );
	layout->addWidget(_freq, 1, 1);

	return dlg;
}

void KPollCfg::updateConfig()
{
	KPollableDrop *d = (KPollableDrop *) drop();
	d->setFreq( atoi(_freq->text()) );
}
